/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.match.MatchField;
import org.projectfloodlight.openflow.protocol.oxm.OFOxm;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmMplsBos;
import org.projectfloodlight.openflow.types.OFBooleanValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFOxmMplsBosVer13
implements OFOxmMplsBos {
    private static final Logger logger = LoggerFactory.getLogger(OFOxmMplsBosVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int LENGTH = 5;
    private static final OFBooleanValue DEFAULT_VALUE = OFBooleanValue.FALSE;
    private final OFBooleanValue value;
    static final OFOxmMplsBosVer13 DEFAULT = new OFOxmMplsBosVer13(DEFAULT_VALUE);
    static final Reader READER = new Reader();
    static final OFOxmMplsBosVer13Funnel FUNNEL = new OFOxmMplsBosVer13Funnel();
    static final Writer WRITER = new Writer();

    OFOxmMplsBosVer13(OFBooleanValue value) {
        if (value == null) {
            throw new NullPointerException("OFOxmMplsBosVer13: property value cannot be null");
        }
        this.value = value;
    }

    @Override
    public long getTypeLen() {
        return 2147502081L;
    }

    @Override
    public OFBooleanValue getValue() {
        return this.value;
    }

    @Override
    public MatchField<OFBooleanValue> getMatchField() {
        return MatchField.MPLS_BOS;
    }

    @Override
    public boolean isMasked() {
        return false;
    }

    @Override
    public OFOxm<OFBooleanValue> getCanonical() {
        return this;
    }

    @Override
    public OFBooleanValue getMask() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property mask not supported in version 1.3");
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFOxmMplsBos.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFOxmMplsBosVer13(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFOxmMplsBosVer13 other = (OFOxmMplsBosVer13)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFOxmMplsBosVer13> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFOxmMplsBosVer13 message) {
            bb.writeInt(-2147465215);
            bb.writeByte(message.value.getInt());
        }
    }

    static class OFOxmMplsBosVer13Funnel
    implements Funnel<OFOxmMplsBosVer13> {
        private static final long serialVersionUID = 1L;

        OFOxmMplsBosVer13Funnel() {
        }

        public void funnel(OFOxmMplsBosVer13 message, PrimitiveSink sink) {
            sink.putInt(-2147465215);
            message.value.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFOxmMplsBos> {
        Reader() {
        }

        @Override
        public OFOxmMplsBos readFrom(ByteBuf bb) throws OFParseError {
            int typeLen = bb.readInt();
            if (typeLen != -2147465215) {
                throw new OFParseError("Wrong typeLen: Expected=0x80004801L(0x80004801L), got=" + typeLen);
            }
            OFBooleanValue value = OFBooleanValue.of(bb.readByte() != 0);
            OFOxmMplsBosVer13 oxmMplsBosVer13 = new OFOxmMplsBosVer13(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)oxmMplsBosVer13);
            }
            return oxmMplsBosVer13;
        }
    }

    static class Builder
    implements OFOxmMplsBos.Builder {
        private boolean valueSet;
        private OFBooleanValue value;

        Builder() {
        }

        @Override
        public long getTypeLen() {
            return 2147502081L;
        }

        @Override
        public OFBooleanValue getValue() {
            return this.value;
        }

        @Override
        public OFOxmMplsBos.Builder setValue(OFBooleanValue value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public MatchField<OFBooleanValue> getMatchField() {
            return MatchField.MPLS_BOS;
        }

        @Override
        public boolean isMasked() {
            return false;
        }

        @Override
        public OFOxm<OFBooleanValue> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.3");
        }

        @Override
        public OFBooleanValue getMask() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property mask not supported in version 1.3");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFOxmMplsBos build() {
            OFBooleanValue value;
            OFBooleanValue oFBooleanValue = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFOxmMplsBosVer13(value);
        }
    }

    static class BuilderWithParent
    implements OFOxmMplsBos.Builder {
        final OFOxmMplsBosVer13 parentMessage;
        private boolean valueSet;
        private OFBooleanValue value;

        BuilderWithParent(OFOxmMplsBosVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public long getTypeLen() {
            return 2147502081L;
        }

        @Override
        public OFBooleanValue getValue() {
            return this.value;
        }

        @Override
        public OFOxmMplsBos.Builder setValue(OFBooleanValue value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public MatchField<OFBooleanValue> getMatchField() {
            return MatchField.MPLS_BOS;
        }

        @Override
        public boolean isMasked() {
            return false;
        }

        @Override
        public OFOxm<OFBooleanValue> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.3");
        }

        @Override
        public OFBooleanValue getMask() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property mask not supported in version 1.3");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFOxmMplsBos build() {
            OFBooleanValue value;
            OFBooleanValue oFBooleanValue = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFOxmMplsBosVer13(value);
        }
    }
}

