/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.collect.ImmutableSet;
import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import java.util.Set;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBsnHashSelectFlags;
import org.projectfloodlight.openflow.protocol.OFInstructionType;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.instruction.OFInstructionBsnHashSelect;
import org.projectfloodlight.openflow.protocol.ver13.OFBsnHashSelectFlagsSerializerVer13;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFInstructionBsnHashSelectVer13
implements OFInstructionBsnHashSelect {
    private static final Logger logger = LoggerFactory.getLogger(OFInstructionBsnHashSelectVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int LENGTH = 16;
    private static final Set<OFBsnHashSelectFlags> DEFAULT_FLAGS = ImmutableSet.of();
    private final Set<OFBsnHashSelectFlags> flags;
    static final OFInstructionBsnHashSelectVer13 DEFAULT = new OFInstructionBsnHashSelectVer13(DEFAULT_FLAGS);
    static final Reader READER = new Reader();
    static final OFInstructionBsnHashSelectVer13Funnel FUNNEL = new OFInstructionBsnHashSelectVer13Funnel();
    static final Writer WRITER = new Writer();

    OFInstructionBsnHashSelectVer13(Set<OFBsnHashSelectFlags> flags) {
        if (flags == null) {
            throw new NullPointerException("OFInstructionBsnHashSelectVer13: property flags cannot be null");
        }
        this.flags = flags;
    }

    @Override
    public OFInstructionType getType() {
        return OFInstructionType.EXPERIMENTER;
    }

    @Override
    public long getExperimenter() {
        return 6035143L;
    }

    @Override
    public long getSubtype() {
        return 15L;
    }

    @Override
    public Set<OFBsnHashSelectFlags> getFlags() {
        return this.flags;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFInstructionBsnHashSelect.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFInstructionBsnHashSelectVer13(");
        b.append("flags=").append(this.flags);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFInstructionBsnHashSelectVer13 other = (OFInstructionBsnHashSelectVer13)obj;
        return !(this.flags == null ? other.flags != null : !this.flags.equals(other.flags));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.flags == null ? 0 : this.flags.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFInstructionBsnHashSelectVer13> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFInstructionBsnHashSelectVer13 message) {
            bb.writeShort(-1);
            bb.writeShort(16);
            bb.writeInt(6035143);
            bb.writeInt(15);
            OFBsnHashSelectFlagsSerializerVer13.writeTo(bb, message.flags);
        }
    }

    static class OFInstructionBsnHashSelectVer13Funnel
    implements Funnel<OFInstructionBsnHashSelectVer13> {
        private static final long serialVersionUID = 1L;

        OFInstructionBsnHashSelectVer13Funnel() {
        }

        public void funnel(OFInstructionBsnHashSelectVer13 message, PrimitiveSink sink) {
            sink.putShort((short)-1);
            sink.putShort((short)16);
            sink.putInt(6035143);
            sink.putInt(15);
            OFBsnHashSelectFlagsSerializerVer13.putTo(message.flags, sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFInstructionBsnHashSelect> {
        Reader() {
        }

        @Override
        public OFInstructionBsnHashSelect readFrom(ByteBuf bb) throws OFParseError {
            int experimenter;
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != -1) {
                throw new OFParseError("Wrong type: Expected=OFInstructionType.EXPERIMENTER(65535), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 16) {
                throw new OFParseError("Wrong length: Expected=16(16), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            if ((experimenter = bb.readInt()) != 6035143) {
                throw new OFParseError("Wrong experimenter: Expected=0x5c16c7L(0x5c16c7L), got=" + experimenter);
            }
            int subtype = bb.readInt();
            if (subtype != 15) {
                throw new OFParseError("Wrong subtype: Expected=0xfL(0xfL), got=" + subtype);
            }
            Set<OFBsnHashSelectFlags> flags = OFBsnHashSelectFlagsSerializerVer13.readFrom(bb);
            OFInstructionBsnHashSelectVer13 instructionBsnHashSelectVer13 = new OFInstructionBsnHashSelectVer13(flags);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)instructionBsnHashSelectVer13);
            }
            return instructionBsnHashSelectVer13;
        }
    }

    static class Builder
    implements OFInstructionBsnHashSelect.Builder {
        private boolean flagsSet;
        private Set<OFBsnHashSelectFlags> flags;

        Builder() {
        }

        @Override
        public OFInstructionType getType() {
            return OFInstructionType.EXPERIMENTER;
        }

        @Override
        public long getExperimenter() {
            return 6035143L;
        }

        @Override
        public long getSubtype() {
            return 15L;
        }

        @Override
        public Set<OFBsnHashSelectFlags> getFlags() {
            return this.flags;
        }

        @Override
        public OFInstructionBsnHashSelect.Builder setFlags(Set<OFBsnHashSelectFlags> flags) {
            this.flags = flags;
            this.flagsSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFInstructionBsnHashSelect build() {
            Set<OFBsnHashSelectFlags> flags;
            Set<OFBsnHashSelectFlags> set = flags = this.flagsSet ? this.flags : DEFAULT_FLAGS;
            if (flags == null) {
                throw new NullPointerException("Property flags must not be null");
            }
            return new OFInstructionBsnHashSelectVer13(flags);
        }
    }

    static class BuilderWithParent
    implements OFInstructionBsnHashSelect.Builder {
        final OFInstructionBsnHashSelectVer13 parentMessage;
        private boolean flagsSet;
        private Set<OFBsnHashSelectFlags> flags;

        BuilderWithParent(OFInstructionBsnHashSelectVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFInstructionType getType() {
            return OFInstructionType.EXPERIMENTER;
        }

        @Override
        public long getExperimenter() {
            return 6035143L;
        }

        @Override
        public long getSubtype() {
            return 15L;
        }

        @Override
        public Set<OFBsnHashSelectFlags> getFlags() {
            return this.flags;
        }

        @Override
        public OFInstructionBsnHashSelect.Builder setFlags(Set<OFBsnHashSelectFlags> flags) {
            this.flags = flags;
            this.flagsSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFInstructionBsnHashSelect build() {
            Set flags;
            Set set = flags = this.flagsSet ? this.flags : this.parentMessage.flags;
            if (flags == null) {
                throw new NullPointerException("Property flags must not be null");
            }
            return new OFInstructionBsnHashSelectVer13(flags);
        }
    }
}

