/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBsnVlanCounterClear;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFType;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnVlanCounterClearVer13
implements OFBsnVlanCounterClear {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnVlanCounterClearVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int LENGTH = 18;
    private static final long DEFAULT_XID = 0L;
    private static final int DEFAULT_VLAN_VID = 0;
    private final long xid;
    private final int vlanVid;
    static final OFBsnVlanCounterClearVer13 DEFAULT = new OFBsnVlanCounterClearVer13(0L, 0);
    static final Reader READER = new Reader();
    static final OFBsnVlanCounterClearVer13Funnel FUNNEL = new OFBsnVlanCounterClearVer13Funnel();
    static final Writer WRITER = new Writer();

    OFBsnVlanCounterClearVer13(long xid, int vlanVid) {
        this.xid = U32.normalize(xid);
        this.vlanVid = U16.normalize(vlanVid);
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFType getType() {
        return OFType.EXPERIMENTER;
    }

    @Override
    public long getXid() {
        return this.xid;
    }

    @Override
    public long getExperimenter() {
        return 6035143L;
    }

    @Override
    public long getSubtype() {
        return 70L;
    }

    @Override
    public int getVlanVid() {
        return this.vlanVid;
    }

    @Override
    public OFBsnVlanCounterClear.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnVlanCounterClearVer13(");
        b.append("xid=").append(this.xid);
        b.append(", ");
        b.append("vlanVid=").append(this.vlanVid);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnVlanCounterClearVer13 other = (OFBsnVlanCounterClearVer13)obj;
        if (this.xid != other.xid) {
            return false;
        }
        return this.vlanVid == other.vlanVid;
    }

    @Override
    public boolean equalsIgnoreXid(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnVlanCounterClearVer13 other = (OFBsnVlanCounterClearVer13)obj;
        return this.vlanVid == other.vlanVid;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.xid ^ this.xid >>> 32);
        result = 31 * result + this.vlanVid;
        return result;
    }

    @Override
    public int hashCodeIgnoreXid() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.vlanVid;
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnVlanCounterClearVer13> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnVlanCounterClearVer13 message) {
            bb.writeByte(4);
            bb.writeByte(4);
            bb.writeShort(18);
            bb.writeInt(U32.t(message.xid));
            bb.writeInt(6035143);
            bb.writeInt(70);
            bb.writeShort((int)U16.t(message.vlanVid));
        }
    }

    static class OFBsnVlanCounterClearVer13Funnel
    implements Funnel<OFBsnVlanCounterClearVer13> {
        private static final long serialVersionUID = 1L;

        OFBsnVlanCounterClearVer13Funnel() {
        }

        public void funnel(OFBsnVlanCounterClearVer13 message, PrimitiveSink sink) {
            sink.putByte((byte)4);
            sink.putByte((byte)4);
            sink.putShort((short)18);
            sink.putLong(message.xid);
            sink.putInt(6035143);
            sink.putInt(70);
            sink.putInt(message.vlanVid);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnVlanCounterClear> {
        Reader() {
        }

        @Override
        public OFBsnVlanCounterClear readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 4) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_13(4), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 4) {
                throw new OFParseError("Wrong type: Expected=OFType.EXPERIMENTER(4), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 18) {
                throw new OFParseError("Wrong length: Expected=18(18), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long xid = U32.f(bb.readInt());
            int experimenter = bb.readInt();
            if (experimenter != 6035143) {
                throw new OFParseError("Wrong experimenter: Expected=0x5c16c7L(0x5c16c7L), got=" + experimenter);
            }
            int subtype = bb.readInt();
            if (subtype != 70) {
                throw new OFParseError("Wrong subtype: Expected=0x46L(0x46L), got=" + subtype);
            }
            int vlanVid = U16.f(bb.readShort());
            OFBsnVlanCounterClearVer13 bsnVlanCounterClearVer13 = new OFBsnVlanCounterClearVer13(xid, vlanVid);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnVlanCounterClearVer13);
            }
            return bsnVlanCounterClearVer13;
        }
    }

    static class Builder
    implements OFBsnVlanCounterClear.Builder {
        private boolean xidSet;
        private long xid;
        private boolean vlanVidSet;
        private int vlanVid;

        Builder() {
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFType getType() {
            return OFType.EXPERIMENTER;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFBsnVlanCounterClear.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public long getExperimenter() {
            return 6035143L;
        }

        @Override
        public long getSubtype() {
            return 70L;
        }

        @Override
        public int getVlanVid() {
            return this.vlanVid;
        }

        @Override
        public OFBsnVlanCounterClear.Builder setVlanVid(int vlanVid) {
            this.vlanVid = vlanVid;
            this.vlanVidSet = true;
            return this;
        }

        @Override
        public OFBsnVlanCounterClear build() {
            long xid = this.xidSet ? this.xid : 0L;
            int vlanVid = this.vlanVidSet ? this.vlanVid : 0;
            return new OFBsnVlanCounterClearVer13(xid, vlanVid);
        }
    }

    static class BuilderWithParent
    implements OFBsnVlanCounterClear.Builder {
        final OFBsnVlanCounterClearVer13 parentMessage;
        private boolean xidSet;
        private long xid;
        private boolean vlanVidSet;
        private int vlanVid;

        BuilderWithParent(OFBsnVlanCounterClearVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFType getType() {
            return OFType.EXPERIMENTER;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFBsnVlanCounterClear.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public long getExperimenter() {
            return 6035143L;
        }

        @Override
        public long getSubtype() {
            return 70L;
        }

        @Override
        public int getVlanVid() {
            return this.vlanVid;
        }

        @Override
        public OFBsnVlanCounterClear.Builder setVlanVid(int vlanVid) {
            this.vlanVid = vlanVid;
            this.vlanVidSet = true;
            return this;
        }

        @Override
        public OFBsnVlanCounterClear build() {
            long xid = this.xidSet ? this.xid : this.parentMessage.xid;
            int vlanVid = this.vlanVidSet ? this.vlanVid : this.parentMessage.vlanVid;
            return new OFBsnVlanCounterClearVer13(xid, vlanVid);
        }
    }
}

