/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlvPduaRxInstance;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.util.ChannelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnTlvPduaRxInstanceVer13
implements OFBsnTlvPduaRxInstance {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnTlvPduaRxInstanceVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int MINIMUM_LENGTH = 4;
    static final int MAXIMUM_LENGTH = 65535;
    private static final byte[] DEFAULT_VALUE = new byte[0];
    private final byte[] value;
    static final OFBsnTlvPduaRxInstanceVer13 DEFAULT = new OFBsnTlvPduaRxInstanceVer13(DEFAULT_VALUE);
    static final Reader READER = new Reader();
    static final OFBsnTlvPduaRxInstanceVer13Funnel FUNNEL = new OFBsnTlvPduaRxInstanceVer13Funnel();
    static final Writer WRITER = new Writer();

    OFBsnTlvPduaRxInstanceVer13(byte[] value) {
        if (value == null) {
            throw new NullPointerException("OFBsnTlvPduaRxInstanceVer13: property value cannot be null");
        }
        this.value = value;
    }

    @Override
    public int getType() {
        return 159;
    }

    @Override
    public byte[] getValue() {
        return this.value;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFBsnTlvPduaRxInstance.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnTlvPduaRxInstanceVer13(");
        b.append("value=").append(Arrays.toString(this.value));
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnTlvPduaRxInstanceVer13 other = (OFBsnTlvPduaRxInstanceVer13)obj;
        return Arrays.equals(this.value, other.value);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.value);
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnTlvPduaRxInstanceVer13> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnTlvPduaRxInstanceVer13 message) {
            int startIndex = bb.writerIndex();
            bb.writeShort(159);
            int lengthIndex = bb.writerIndex();
            bb.writeShort((int)U16.t(0));
            bb.writeBytes(message.value);
            int length = bb.writerIndex() - startIndex;
            if (length > 65535) {
                throw new IllegalArgumentException("OFBsnTlvPduaRxInstanceVer13: message length (" + length + ") exceeds maximum (0xFFFF)");
            }
            bb.setShort(lengthIndex, length);
        }
    }

    static class OFBsnTlvPduaRxInstanceVer13Funnel
    implements Funnel<OFBsnTlvPduaRxInstanceVer13> {
        private static final long serialVersionUID = 1L;

        OFBsnTlvPduaRxInstanceVer13Funnel() {
        }

        public void funnel(OFBsnTlvPduaRxInstanceVer13 message, PrimitiveSink sink) {
            sink.putShort((short)159);
            sink.putBytes(message.value);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnTlvPduaRxInstance> {
        Reader() {
        }

        @Override
        public OFBsnTlvPduaRxInstance readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 159) {
                throw new OFParseError("Wrong type: Expected=0x9f(0x9f), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length < 4) {
                throw new OFParseError("Wrong length: Expected to be >= 4, was: " + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            byte[] value = ChannelUtils.readBytes(bb, length - (bb.readerIndex() - start));
            OFBsnTlvPduaRxInstanceVer13 bsnTlvPduaRxInstanceVer13 = new OFBsnTlvPduaRxInstanceVer13(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnTlvPduaRxInstanceVer13);
            }
            return bsnTlvPduaRxInstanceVer13;
        }
    }

    static class Builder
    implements OFBsnTlvPduaRxInstance.Builder {
        private boolean valueSet;
        private byte[] value;

        Builder() {
        }

        @Override
        public int getType() {
            return 159;
        }

        @Override
        public byte[] getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvPduaRxInstance.Builder setValue(byte[] value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFBsnTlvPduaRxInstance build() {
            byte[] value;
            byte[] byArray = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvPduaRxInstanceVer13(value);
        }
    }

    static class BuilderWithParent
    implements OFBsnTlvPduaRxInstance.Builder {
        final OFBsnTlvPduaRxInstanceVer13 parentMessage;
        private boolean valueSet;
        private byte[] value;

        BuilderWithParent(OFBsnTlvPduaRxInstanceVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 159;
        }

        @Override
        public byte[] getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvPduaRxInstance.Builder setValue(byte[] value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFBsnTlvPduaRxInstance build() {
            byte[] value;
            byte[] byArray = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvPduaRxInstanceVer13(value);
        }
    }
}

