/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlvOffset;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnTlvOffsetVer13
implements OFBsnTlvOffset {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnTlvOffsetVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int LENGTH = 6;
    private static final int DEFAULT_VALUE = 0;
    private final int value;
    static final OFBsnTlvOffsetVer13 DEFAULT = new OFBsnTlvOffsetVer13(0);
    static final Reader READER = new Reader();
    static final OFBsnTlvOffsetVer13Funnel FUNNEL = new OFBsnTlvOffsetVer13Funnel();
    static final Writer WRITER = new Writer();

    OFBsnTlvOffsetVer13(int value) {
        this.value = U16.normalize(value);
    }

    @Override
    public int getType() {
        return 82;
    }

    @Override
    public int getValue() {
        return this.value;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFBsnTlvOffset.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnTlvOffsetVer13(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnTlvOffsetVer13 other = (OFBsnTlvOffsetVer13)obj;
        return this.value == other.value;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.value;
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnTlvOffsetVer13> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnTlvOffsetVer13 message) {
            bb.writeShort(82);
            bb.writeShort(6);
            bb.writeShort((int)U16.t(message.value));
        }
    }

    static class OFBsnTlvOffsetVer13Funnel
    implements Funnel<OFBsnTlvOffsetVer13> {
        private static final long serialVersionUID = 1L;

        OFBsnTlvOffsetVer13Funnel() {
        }

        public void funnel(OFBsnTlvOffsetVer13 message, PrimitiveSink sink) {
            sink.putShort((short)82);
            sink.putShort((short)6);
            sink.putInt(message.value);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnTlvOffset> {
        Reader() {
        }

        @Override
        public OFBsnTlvOffset readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 82) {
                throw new OFParseError("Wrong type: Expected=0x52(0x52), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 6) {
                throw new OFParseError("Wrong length: Expected=6(6), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            int value = U16.f(bb.readShort());
            OFBsnTlvOffsetVer13 bsnTlvOffsetVer13 = new OFBsnTlvOffsetVer13(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnTlvOffsetVer13);
            }
            return bsnTlvOffsetVer13;
        }
    }

    static class Builder
    implements OFBsnTlvOffset.Builder {
        private boolean valueSet;
        private int value;

        Builder() {
        }

        @Override
        public int getType() {
            return 82;
        }

        @Override
        public int getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvOffset.Builder setValue(int value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFBsnTlvOffset build() {
            int value = this.valueSet ? this.value : 0;
            return new OFBsnTlvOffsetVer13(value);
        }
    }

    static class BuilderWithParent
    implements OFBsnTlvOffset.Builder {
        final OFBsnTlvOffsetVer13 parentMessage;
        private boolean valueSet;
        private int value;

        BuilderWithParent(OFBsnTlvOffsetVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 82;
        }

        @Override
        public int getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvOffset.Builder setValue(int value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFBsnTlvOffset build() {
            int value = this.valueSet ? this.value : this.parentMessage.value;
            return new OFBsnTlvOffsetVer13(value);
        }
    }
}

