/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlvMulticastInterfaceId;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnTlvMulticastInterfaceIdVer13
implements OFBsnTlvMulticastInterfaceId {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnTlvMulticastInterfaceIdVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int LENGTH = 8;
    private static final long DEFAULT_VALUE = 0L;
    private final long value;
    static final OFBsnTlvMulticastInterfaceIdVer13 DEFAULT = new OFBsnTlvMulticastInterfaceIdVer13(0L);
    static final Reader READER = new Reader();
    static final OFBsnTlvMulticastInterfaceIdVer13Funnel FUNNEL = new OFBsnTlvMulticastInterfaceIdVer13Funnel();
    static final Writer WRITER = new Writer();

    OFBsnTlvMulticastInterfaceIdVer13(long value) {
        this.value = U32.normalize(value);
    }

    @Override
    public int getType() {
        return 95;
    }

    @Override
    public long getValue() {
        return this.value;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFBsnTlvMulticastInterfaceId.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnTlvMulticastInterfaceIdVer13(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnTlvMulticastInterfaceIdVer13 other = (OFBsnTlvMulticastInterfaceIdVer13)obj;
        return this.value == other.value;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.value ^ this.value >>> 32);
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnTlvMulticastInterfaceIdVer13> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnTlvMulticastInterfaceIdVer13 message) {
            bb.writeShort(95);
            bb.writeShort(8);
            bb.writeInt(U32.t(message.value));
        }
    }

    static class OFBsnTlvMulticastInterfaceIdVer13Funnel
    implements Funnel<OFBsnTlvMulticastInterfaceIdVer13> {
        private static final long serialVersionUID = 1L;

        OFBsnTlvMulticastInterfaceIdVer13Funnel() {
        }

        public void funnel(OFBsnTlvMulticastInterfaceIdVer13 message, PrimitiveSink sink) {
            sink.putShort((short)95);
            sink.putShort((short)8);
            sink.putLong(message.value);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnTlvMulticastInterfaceId> {
        Reader() {
        }

        @Override
        public OFBsnTlvMulticastInterfaceId readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 95) {
                throw new OFParseError("Wrong type: Expected=0x5f(0x5f), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 8) {
                throw new OFParseError("Wrong length: Expected=8(8), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long value = U32.f(bb.readInt());
            OFBsnTlvMulticastInterfaceIdVer13 bsnTlvMulticastInterfaceIdVer13 = new OFBsnTlvMulticastInterfaceIdVer13(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnTlvMulticastInterfaceIdVer13);
            }
            return bsnTlvMulticastInterfaceIdVer13;
        }
    }

    static class Builder
    implements OFBsnTlvMulticastInterfaceId.Builder {
        private boolean valueSet;
        private long value;

        Builder() {
        }

        @Override
        public int getType() {
            return 95;
        }

        @Override
        public long getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvMulticastInterfaceId.Builder setValue(long value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFBsnTlvMulticastInterfaceId build() {
            long value = this.valueSet ? this.value : 0L;
            return new OFBsnTlvMulticastInterfaceIdVer13(value);
        }
    }

    static class BuilderWithParent
    implements OFBsnTlvMulticastInterfaceId.Builder {
        final OFBsnTlvMulticastInterfaceIdVer13 parentMessage;
        private boolean valueSet;
        private long value;

        BuilderWithParent(OFBsnTlvMulticastInterfaceIdVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 95;
        }

        @Override
        public long getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvMulticastInterfaceId.Builder setValue(long value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFBsnTlvMulticastInterfaceId build() {
            long value = this.valueSet ? this.value : this.parentMessage.value;
            return new OFBsnTlvMulticastInterfaceIdVer13(value);
        }
    }
}

