/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlvIpProto;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U8;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnTlvIpProtoVer13
implements OFBsnTlvIpProto {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnTlvIpProtoVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int LENGTH = 5;
    private static final short DEFAULT_VALUE = 0;
    private final short value;
    static final OFBsnTlvIpProtoVer13 DEFAULT = new OFBsnTlvIpProtoVer13(0);
    static final Reader READER = new Reader();
    static final OFBsnTlvIpProtoVer13Funnel FUNNEL = new OFBsnTlvIpProtoVer13Funnel();
    static final Writer WRITER = new Writer();

    OFBsnTlvIpProtoVer13(short value) {
        this.value = U8.normalize(value);
    }

    @Override
    public int getType() {
        return 67;
    }

    @Override
    public short getValue() {
        return this.value;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFBsnTlvIpProto.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnTlvIpProtoVer13(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnTlvIpProtoVer13 other = (OFBsnTlvIpProtoVer13)obj;
        return this.value == other.value;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.value;
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnTlvIpProtoVer13> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnTlvIpProtoVer13 message) {
            bb.writeShort(67);
            bb.writeShort(5);
            bb.writeByte((int)U8.t(message.value));
        }
    }

    static class OFBsnTlvIpProtoVer13Funnel
    implements Funnel<OFBsnTlvIpProtoVer13> {
        private static final long serialVersionUID = 1L;

        OFBsnTlvIpProtoVer13Funnel() {
        }

        public void funnel(OFBsnTlvIpProtoVer13 message, PrimitiveSink sink) {
            sink.putShort((short)67);
            sink.putShort((short)5);
            sink.putShort(message.value);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnTlvIpProto> {
        Reader() {
        }

        @Override
        public OFBsnTlvIpProto readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 67) {
                throw new OFParseError("Wrong type: Expected=0x43(0x43), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 5) {
                throw new OFParseError("Wrong length: Expected=5(5), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            short value = U8.f(bb.readByte());
            OFBsnTlvIpProtoVer13 bsnTlvIpProtoVer13 = new OFBsnTlvIpProtoVer13(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnTlvIpProtoVer13);
            }
            return bsnTlvIpProtoVer13;
        }
    }

    static class Builder
    implements OFBsnTlvIpProto.Builder {
        private boolean valueSet;
        private short value;

        Builder() {
        }

        @Override
        public int getType() {
            return 67;
        }

        @Override
        public short getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvIpProto.Builder setValue(short value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFBsnTlvIpProto build() {
            short value = this.valueSet ? this.value : (short)0;
            return new OFBsnTlvIpProtoVer13(value);
        }
    }

    static class BuilderWithParent
    implements OFBsnTlvIpProto.Builder {
        final OFBsnTlvIpProtoVer13 parentMessage;
        private boolean valueSet;
        private short value;

        BuilderWithParent(OFBsnTlvIpProtoVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 67;
        }

        @Override
        public short getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvIpProto.Builder setValue(short value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFBsnTlvIpProto build() {
            short value = this.valueSet ? this.value : this.parentMessage.value;
            return new OFBsnTlvIpProtoVer13(value);
        }
    }
}

