/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlvIcmpv6Chksum;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnTlvIcmpv6ChksumVer13
implements OFBsnTlvIcmpv6Chksum {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnTlvIcmpv6ChksumVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int LENGTH = 6;
    private static final int DEFAULT_VALUE = 0;
    private final int value;
    static final OFBsnTlvIcmpv6ChksumVer13 DEFAULT = new OFBsnTlvIcmpv6ChksumVer13(0);
    static final Reader READER = new Reader();
    static final OFBsnTlvIcmpv6ChksumVer13Funnel FUNNEL = new OFBsnTlvIcmpv6ChksumVer13Funnel();
    static final Writer WRITER = new Writer();

    OFBsnTlvIcmpv6ChksumVer13(int value) {
        this.value = U16.normalize(value);
    }

    @Override
    public int getType() {
        return 125;
    }

    @Override
    public int getValue() {
        return this.value;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFBsnTlvIcmpv6Chksum.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnTlvIcmpv6ChksumVer13(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnTlvIcmpv6ChksumVer13 other = (OFBsnTlvIcmpv6ChksumVer13)obj;
        return this.value == other.value;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.value;
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnTlvIcmpv6ChksumVer13> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnTlvIcmpv6ChksumVer13 message) {
            bb.writeShort(125);
            bb.writeShort(6);
            bb.writeShort((int)U16.t(message.value));
        }
    }

    static class OFBsnTlvIcmpv6ChksumVer13Funnel
    implements Funnel<OFBsnTlvIcmpv6ChksumVer13> {
        private static final long serialVersionUID = 1L;

        OFBsnTlvIcmpv6ChksumVer13Funnel() {
        }

        public void funnel(OFBsnTlvIcmpv6ChksumVer13 message, PrimitiveSink sink) {
            sink.putShort((short)125);
            sink.putShort((short)6);
            sink.putInt(message.value);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnTlvIcmpv6Chksum> {
        Reader() {
        }

        @Override
        public OFBsnTlvIcmpv6Chksum readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 125) {
                throw new OFParseError("Wrong type: Expected=0x7d(0x7d), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 6) {
                throw new OFParseError("Wrong length: Expected=6(6), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            int value = U16.f(bb.readShort());
            OFBsnTlvIcmpv6ChksumVer13 bsnTlvIcmpv6ChksumVer13 = new OFBsnTlvIcmpv6ChksumVer13(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnTlvIcmpv6ChksumVer13);
            }
            return bsnTlvIcmpv6ChksumVer13;
        }
    }

    static class Builder
    implements OFBsnTlvIcmpv6Chksum.Builder {
        private boolean valueSet;
        private int value;

        Builder() {
        }

        @Override
        public int getType() {
            return 125;
        }

        @Override
        public int getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvIcmpv6Chksum.Builder setValue(int value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFBsnTlvIcmpv6Chksum build() {
            int value = this.valueSet ? this.value : 0;
            return new OFBsnTlvIcmpv6ChksumVer13(value);
        }
    }

    static class BuilderWithParent
    implements OFBsnTlvIcmpv6Chksum.Builder {
        final OFBsnTlvIcmpv6ChksumVer13 parentMessage;
        private boolean valueSet;
        private int value;

        BuilderWithParent(OFBsnTlvIcmpv6ChksumVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 125;
        }

        @Override
        public int getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvIcmpv6Chksum.Builder setValue(int value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFBsnTlvIcmpv6Chksum build() {
            int value = this.valueSet ? this.value : this.parentMessage.value;
            return new OFBsnTlvIcmpv6ChksumVer13(value);
        }
    }
}

