/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBsnHashAlgorithmType;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlvHashAlgorithm;
import org.projectfloodlight.openflow.protocol.ver13.OFBsnHashAlgorithmTypeSerializerVer13;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnTlvHashAlgorithmVer13
implements OFBsnTlvHashAlgorithm {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnTlvHashAlgorithmVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int LENGTH = 6;
    private final OFBsnHashAlgorithmType value;
    static final Reader READER = new Reader();
    static final OFBsnTlvHashAlgorithmVer13Funnel FUNNEL = new OFBsnTlvHashAlgorithmVer13Funnel();
    static final Writer WRITER = new Writer();

    OFBsnTlvHashAlgorithmVer13(OFBsnHashAlgorithmType value) {
        if (value == null) {
            throw new NullPointerException("OFBsnTlvHashAlgorithmVer13: property value cannot be null");
        }
        this.value = value;
    }

    @Override
    public int getType() {
        return 145;
    }

    @Override
    public OFBsnHashAlgorithmType getValue() {
        return this.value;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFBsnTlvHashAlgorithm.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnTlvHashAlgorithmVer13(");
        b.append("value=").append((Object)this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnTlvHashAlgorithmVer13 other = (OFBsnTlvHashAlgorithmVer13)obj;
        return !(this.value == null ? other.value != null : !this.value.equals((Object)other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnTlvHashAlgorithmVer13> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnTlvHashAlgorithmVer13 message) {
            bb.writeShort(145);
            bb.writeShort(6);
            OFBsnHashAlgorithmTypeSerializerVer13.writeTo(bb, message.value);
        }
    }

    static class OFBsnTlvHashAlgorithmVer13Funnel
    implements Funnel<OFBsnTlvHashAlgorithmVer13> {
        private static final long serialVersionUID = 1L;

        OFBsnTlvHashAlgorithmVer13Funnel() {
        }

        public void funnel(OFBsnTlvHashAlgorithmVer13 message, PrimitiveSink sink) {
            sink.putShort((short)145);
            sink.putShort((short)6);
            OFBsnHashAlgorithmTypeSerializerVer13.putTo(message.value, sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnTlvHashAlgorithm> {
        Reader() {
        }

        @Override
        public OFBsnTlvHashAlgorithm readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 145) {
                throw new OFParseError("Wrong type: Expected=0x91(0x91), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 6) {
                throw new OFParseError("Wrong length: Expected=6(6), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            OFBsnHashAlgorithmType value = OFBsnHashAlgorithmTypeSerializerVer13.readFrom(bb);
            OFBsnTlvHashAlgorithmVer13 bsnTlvHashAlgorithmVer13 = new OFBsnTlvHashAlgorithmVer13(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnTlvHashAlgorithmVer13);
            }
            return bsnTlvHashAlgorithmVer13;
        }
    }

    static class Builder
    implements OFBsnTlvHashAlgorithm.Builder {
        private boolean valueSet;
        private OFBsnHashAlgorithmType value;

        Builder() {
        }

        @Override
        public int getType() {
            return 145;
        }

        @Override
        public OFBsnHashAlgorithmType getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvHashAlgorithm.Builder setValue(OFBsnHashAlgorithmType value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFBsnTlvHashAlgorithm build() {
            if (!this.valueSet) {
                throw new IllegalStateException("Property value doesn't have default value -- must be set");
            }
            if (this.value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvHashAlgorithmVer13(this.value);
        }
    }

    static class BuilderWithParent
    implements OFBsnTlvHashAlgorithm.Builder {
        final OFBsnTlvHashAlgorithmVer13 parentMessage;
        private boolean valueSet;
        private OFBsnHashAlgorithmType value;

        BuilderWithParent(OFBsnTlvHashAlgorithmVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 145;
        }

        @Override
        public OFBsnHashAlgorithmType getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvHashAlgorithm.Builder setValue(OFBsnHashAlgorithmType value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFBsnTlvHashAlgorithm build() {
            OFBsnHashAlgorithmType value;
            OFBsnHashAlgorithmType oFBsnHashAlgorithmType = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvHashAlgorithmVer13(value);
        }
    }
}

