/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlvFailCount;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnTlvFailCountVer13
implements OFBsnTlvFailCount {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnTlvFailCountVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int LENGTH = 12;
    private static final U64 DEFAULT_VALUE = U64.ZERO;
    private final U64 value;
    static final OFBsnTlvFailCountVer13 DEFAULT = new OFBsnTlvFailCountVer13(DEFAULT_VALUE);
    static final Reader READER = new Reader();
    static final OFBsnTlvFailCountVer13Funnel FUNNEL = new OFBsnTlvFailCountVer13Funnel();
    static final Writer WRITER = new Writer();

    OFBsnTlvFailCountVer13(U64 value) {
        if (value == null) {
            throw new NullPointerException("OFBsnTlvFailCountVer13: property value cannot be null");
        }
        this.value = value;
    }

    @Override
    public int getType() {
        return 194;
    }

    @Override
    public U64 getValue() {
        return this.value;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFBsnTlvFailCount.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnTlvFailCountVer13(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnTlvFailCountVer13 other = (OFBsnTlvFailCountVer13)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnTlvFailCountVer13> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnTlvFailCountVer13 message) {
            bb.writeShort(194);
            bb.writeShort(12);
            bb.writeLong(message.value.getValue());
        }
    }

    static class OFBsnTlvFailCountVer13Funnel
    implements Funnel<OFBsnTlvFailCountVer13> {
        private static final long serialVersionUID = 1L;

        OFBsnTlvFailCountVer13Funnel() {
        }

        public void funnel(OFBsnTlvFailCountVer13 message, PrimitiveSink sink) {
            sink.putShort((short)194);
            sink.putShort((short)12);
            message.value.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnTlvFailCount> {
        Reader() {
        }

        @Override
        public OFBsnTlvFailCount readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 194) {
                throw new OFParseError("Wrong type: Expected=0xc2(0xc2), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 12) {
                throw new OFParseError("Wrong length: Expected=12(12), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            U64 value = U64.ofRaw(bb.readLong());
            OFBsnTlvFailCountVer13 bsnTlvFailCountVer13 = new OFBsnTlvFailCountVer13(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnTlvFailCountVer13);
            }
            return bsnTlvFailCountVer13;
        }
    }

    static class Builder
    implements OFBsnTlvFailCount.Builder {
        private boolean valueSet;
        private U64 value;

        Builder() {
        }

        @Override
        public int getType() {
            return 194;
        }

        @Override
        public U64 getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvFailCount.Builder setValue(U64 value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFBsnTlvFailCount build() {
            U64 value;
            U64 u64 = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvFailCountVer13(value);
        }
    }

    static class BuilderWithParent
    implements OFBsnTlvFailCount.Builder {
        final OFBsnTlvFailCountVer13 parentMessage;
        private boolean valueSet;
        private U64 value;

        BuilderWithParent(OFBsnTlvFailCountVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 194;
        }

        @Override
        public U64 getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvFailCount.Builder setValue(U64 value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFBsnTlvFailCount build() {
            U64 value;
            U64 u64 = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvFailCountVer13(value);
        }
    }
}

