/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBsnBfdEndpoint;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlvBfdEndpoint;
import org.projectfloodlight.openflow.protocol.ver13.OFBsnBfdEndpointSerializerVer13;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnTlvBfdEndpointVer13
implements OFBsnTlvBfdEndpoint {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnTlvBfdEndpointVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int LENGTH = 5;
    private final OFBsnBfdEndpoint value;
    static final Reader READER = new Reader();
    static final OFBsnTlvBfdEndpointVer13Funnel FUNNEL = new OFBsnTlvBfdEndpointVer13Funnel();
    static final Writer WRITER = new Writer();

    OFBsnTlvBfdEndpointVer13(OFBsnBfdEndpoint value) {
        if (value == null) {
            throw new NullPointerException("OFBsnTlvBfdEndpointVer13: property value cannot be null");
        }
        this.value = value;
    }

    @Override
    public int getType() {
        return 176;
    }

    @Override
    public OFBsnBfdEndpoint getValue() {
        return this.value;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFBsnTlvBfdEndpoint.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnTlvBfdEndpointVer13(");
        b.append("value=").append((Object)this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnTlvBfdEndpointVer13 other = (OFBsnTlvBfdEndpointVer13)obj;
        return !(this.value == null ? other.value != null : !this.value.equals((Object)other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnTlvBfdEndpointVer13> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnTlvBfdEndpointVer13 message) {
            bb.writeShort(176);
            bb.writeShort(5);
            OFBsnBfdEndpointSerializerVer13.writeTo(bb, message.value);
        }
    }

    static class OFBsnTlvBfdEndpointVer13Funnel
    implements Funnel<OFBsnTlvBfdEndpointVer13> {
        private static final long serialVersionUID = 1L;

        OFBsnTlvBfdEndpointVer13Funnel() {
        }

        public void funnel(OFBsnTlvBfdEndpointVer13 message, PrimitiveSink sink) {
            sink.putShort((short)176);
            sink.putShort((short)5);
            OFBsnBfdEndpointSerializerVer13.putTo(message.value, sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnTlvBfdEndpoint> {
        Reader() {
        }

        @Override
        public OFBsnTlvBfdEndpoint readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 176) {
                throw new OFParseError("Wrong type: Expected=0xb0(0xb0), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 5) {
                throw new OFParseError("Wrong length: Expected=5(5), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            OFBsnBfdEndpoint value = OFBsnBfdEndpointSerializerVer13.readFrom(bb);
            OFBsnTlvBfdEndpointVer13 bsnTlvBfdEndpointVer13 = new OFBsnTlvBfdEndpointVer13(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnTlvBfdEndpointVer13);
            }
            return bsnTlvBfdEndpointVer13;
        }
    }

    static class Builder
    implements OFBsnTlvBfdEndpoint.Builder {
        private boolean valueSet;
        private OFBsnBfdEndpoint value;

        Builder() {
        }

        @Override
        public int getType() {
            return 176;
        }

        @Override
        public OFBsnBfdEndpoint getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvBfdEndpoint.Builder setValue(OFBsnBfdEndpoint value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFBsnTlvBfdEndpoint build() {
            if (!this.valueSet) {
                throw new IllegalStateException("Property value doesn't have default value -- must be set");
            }
            if (this.value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvBfdEndpointVer13(this.value);
        }
    }

    static class BuilderWithParent
    implements OFBsnTlvBfdEndpoint.Builder {
        final OFBsnTlvBfdEndpointVer13 parentMessage;
        private boolean valueSet;
        private OFBsnBfdEndpoint value;

        BuilderWithParent(OFBsnTlvBfdEndpointVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 176;
        }

        @Override
        public OFBsnBfdEndpoint getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvBfdEndpoint.Builder setValue(OFBsnBfdEndpoint value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFBsnTlvBfdEndpoint build() {
            OFBsnBfdEndpoint value;
            OFBsnBfdEndpoint oFBsnBfdEndpoint = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvBfdEndpointVer13(value);
        }
    }
}

