/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBsnLuaCommandRequest;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFType;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.projectfloodlight.openflow.util.ChannelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnLuaCommandRequestVer13
implements OFBsnLuaCommandRequest {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnLuaCommandRequestVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int MINIMUM_LENGTH = 16;
    static final int MAXIMUM_LENGTH = 65535;
    private static final long DEFAULT_XID = 0L;
    private static final byte[] DEFAULT_DATA = new byte[0];
    private final long xid;
    private final byte[] data;
    static final OFBsnLuaCommandRequestVer13 DEFAULT = new OFBsnLuaCommandRequestVer13(0L, DEFAULT_DATA);
    static final Reader READER = new Reader();
    static final OFBsnLuaCommandRequestVer13Funnel FUNNEL = new OFBsnLuaCommandRequestVer13Funnel();
    static final Writer WRITER = new Writer();

    OFBsnLuaCommandRequestVer13(long xid, byte[] data) {
        if (data == null) {
            throw new NullPointerException("OFBsnLuaCommandRequestVer13: property data cannot be null");
        }
        this.xid = U32.normalize(xid);
        this.data = data;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFType getType() {
        return OFType.EXPERIMENTER;
    }

    @Override
    public long getXid() {
        return this.xid;
    }

    @Override
    public long getExperimenter() {
        return 6035143L;
    }

    @Override
    public long getSubtype() {
        return 65L;
    }

    @Override
    public byte[] getData() {
        return this.data;
    }

    @Override
    public OFBsnLuaCommandRequest.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnLuaCommandRequestVer13(");
        b.append("xid=").append(this.xid);
        b.append(", ");
        b.append("data=").append(Arrays.toString(this.data));
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnLuaCommandRequestVer13 other = (OFBsnLuaCommandRequestVer13)obj;
        if (this.xid != other.xid) {
            return false;
        }
        return Arrays.equals(this.data, other.data);
    }

    @Override
    public boolean equalsIgnoreXid(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnLuaCommandRequestVer13 other = (OFBsnLuaCommandRequestVer13)obj;
        return Arrays.equals(this.data, other.data);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.xid ^ this.xid >>> 32);
        result = 31 * result + Arrays.hashCode(this.data);
        return result;
    }

    @Override
    public int hashCodeIgnoreXid() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.data);
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnLuaCommandRequestVer13> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnLuaCommandRequestVer13 message) {
            int startIndex = bb.writerIndex();
            bb.writeByte(4);
            bb.writeByte(4);
            int lengthIndex = bb.writerIndex();
            bb.writeShort((int)U16.t(0));
            bb.writeInt(U32.t(message.xid));
            bb.writeInt(6035143);
            bb.writeInt(65);
            bb.writeBytes(message.data);
            int length = bb.writerIndex() - startIndex;
            if (length > 65535) {
                throw new IllegalArgumentException("OFBsnLuaCommandRequestVer13: message length (" + length + ") exceeds maximum (0xFFFF)");
            }
            bb.setShort(lengthIndex, length);
        }
    }

    static class OFBsnLuaCommandRequestVer13Funnel
    implements Funnel<OFBsnLuaCommandRequestVer13> {
        private static final long serialVersionUID = 1L;

        OFBsnLuaCommandRequestVer13Funnel() {
        }

        public void funnel(OFBsnLuaCommandRequestVer13 message, PrimitiveSink sink) {
            sink.putByte((byte)4);
            sink.putByte((byte)4);
            sink.putLong(message.xid);
            sink.putInt(6035143);
            sink.putInt(65);
            sink.putBytes(message.data);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnLuaCommandRequest> {
        Reader() {
        }

        @Override
        public OFBsnLuaCommandRequest readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 4) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_13(4), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 4) {
                throw new OFParseError("Wrong type: Expected=OFType.EXPERIMENTER(4), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length < 16) {
                throw new OFParseError("Wrong length: Expected to be >= 16, was: " + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long xid = U32.f(bb.readInt());
            int experimenter = bb.readInt();
            if (experimenter != 6035143) {
                throw new OFParseError("Wrong experimenter: Expected=0x5c16c7L(0x5c16c7L), got=" + experimenter);
            }
            int subtype = bb.readInt();
            if (subtype != 65) {
                throw new OFParseError("Wrong subtype: Expected=0x41L(0x41L), got=" + subtype);
            }
            byte[] data = ChannelUtils.readBytes(bb, length - (bb.readerIndex() - start));
            OFBsnLuaCommandRequestVer13 bsnLuaCommandRequestVer13 = new OFBsnLuaCommandRequestVer13(xid, data);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnLuaCommandRequestVer13);
            }
            return bsnLuaCommandRequestVer13;
        }
    }

    static class Builder
    implements OFBsnLuaCommandRequest.Builder {
        private boolean xidSet;
        private long xid;
        private boolean dataSet;
        private byte[] data;

        Builder() {
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFType getType() {
            return OFType.EXPERIMENTER;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFBsnLuaCommandRequest.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public long getExperimenter() {
            return 6035143L;
        }

        @Override
        public long getSubtype() {
            return 65L;
        }

        @Override
        public byte[] getData() {
            return this.data;
        }

        @Override
        public OFBsnLuaCommandRequest.Builder setData(byte[] data) {
            this.data = data;
            this.dataSet = true;
            return this;
        }

        @Override
        public OFBsnLuaCommandRequest build() {
            byte[] data;
            long xid = this.xidSet ? this.xid : 0L;
            byte[] byArray = data = this.dataSet ? this.data : DEFAULT_DATA;
            if (data == null) {
                throw new NullPointerException("Property data must not be null");
            }
            return new OFBsnLuaCommandRequestVer13(xid, data);
        }
    }

    static class BuilderWithParent
    implements OFBsnLuaCommandRequest.Builder {
        final OFBsnLuaCommandRequestVer13 parentMessage;
        private boolean xidSet;
        private long xid;
        private boolean dataSet;
        private byte[] data;

        BuilderWithParent(OFBsnLuaCommandRequestVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFType getType() {
            return OFType.EXPERIMENTER;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFBsnLuaCommandRequest.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public long getExperimenter() {
            return 6035143L;
        }

        @Override
        public long getSubtype() {
            return 65L;
        }

        @Override
        public byte[] getData() {
            return this.data;
        }

        @Override
        public OFBsnLuaCommandRequest.Builder setData(byte[] data) {
            this.data = data;
            this.dataSet = true;
            return this;
        }

        @Override
        public OFBsnLuaCommandRequest build() {
            byte[] data;
            long xid = this.xidSet ? this.xid : this.parentMessage.xid;
            byte[] byArray = data = this.dataSet ? this.data : this.parentMessage.data;
            if (data == null) {
                throw new NullPointerException("Property data must not be null");
            }
            return new OFBsnLuaCommandRequestVer13(xid, data);
        }
    }
}

