/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBsnGetSwitchPipelineRequest;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFType;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnGetSwitchPipelineRequestVer13
implements OFBsnGetSwitchPipelineRequest {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnGetSwitchPipelineRequestVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int LENGTH = 16;
    private static final long DEFAULT_XID = 0L;
    private final long xid;
    static final OFBsnGetSwitchPipelineRequestVer13 DEFAULT = new OFBsnGetSwitchPipelineRequestVer13(0L);
    static final Reader READER = new Reader();
    static final OFBsnGetSwitchPipelineRequestVer13Funnel FUNNEL = new OFBsnGetSwitchPipelineRequestVer13Funnel();
    static final Writer WRITER = new Writer();

    OFBsnGetSwitchPipelineRequestVer13(long xid) {
        this.xid = U32.normalize(xid);
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFType getType() {
        return OFType.EXPERIMENTER;
    }

    @Override
    public long getXid() {
        return this.xid;
    }

    @Override
    public long getExperimenter() {
        return 6035143L;
    }

    @Override
    public long getSubtype() {
        return 51L;
    }

    @Override
    public OFBsnGetSwitchPipelineRequest.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnGetSwitchPipelineRequestVer13(");
        b.append("xid=").append(this.xid);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnGetSwitchPipelineRequestVer13 other = (OFBsnGetSwitchPipelineRequestVer13)obj;
        return this.xid == other.xid;
    }

    @Override
    public boolean equalsIgnoreXid(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnGetSwitchPipelineRequestVer13 other = (OFBsnGetSwitchPipelineRequestVer13)obj;
        return true;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.xid ^ this.xid >>> 32);
        return result;
    }

    @Override
    public int hashCodeIgnoreXid() {
        int prime = 31;
        int result = 1;
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnGetSwitchPipelineRequestVer13> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnGetSwitchPipelineRequestVer13 message) {
            bb.writeByte(4);
            bb.writeByte(4);
            bb.writeShort(16);
            bb.writeInt(U32.t(message.xid));
            bb.writeInt(6035143);
            bb.writeInt(51);
        }
    }

    static class OFBsnGetSwitchPipelineRequestVer13Funnel
    implements Funnel<OFBsnGetSwitchPipelineRequestVer13> {
        private static final long serialVersionUID = 1L;

        OFBsnGetSwitchPipelineRequestVer13Funnel() {
        }

        public void funnel(OFBsnGetSwitchPipelineRequestVer13 message, PrimitiveSink sink) {
            sink.putByte((byte)4);
            sink.putByte((byte)4);
            sink.putShort((short)16);
            sink.putLong(message.xid);
            sink.putInt(6035143);
            sink.putInt(51);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnGetSwitchPipelineRequest> {
        Reader() {
        }

        @Override
        public OFBsnGetSwitchPipelineRequest readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 4) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_13(4), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 4) {
                throw new OFParseError("Wrong type: Expected=OFType.EXPERIMENTER(4), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 16) {
                throw new OFParseError("Wrong length: Expected=16(16), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long xid = U32.f(bb.readInt());
            int experimenter = bb.readInt();
            if (experimenter != 6035143) {
                throw new OFParseError("Wrong experimenter: Expected=0x5c16c7L(0x5c16c7L), got=" + experimenter);
            }
            int subtype = bb.readInt();
            if (subtype != 51) {
                throw new OFParseError("Wrong subtype: Expected=0x33L(0x33L), got=" + subtype);
            }
            OFBsnGetSwitchPipelineRequestVer13 bsnGetSwitchPipelineRequestVer13 = new OFBsnGetSwitchPipelineRequestVer13(xid);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnGetSwitchPipelineRequestVer13);
            }
            return bsnGetSwitchPipelineRequestVer13;
        }
    }

    static class Builder
    implements OFBsnGetSwitchPipelineRequest.Builder {
        private boolean xidSet;
        private long xid;

        Builder() {
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFType getType() {
            return OFType.EXPERIMENTER;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFBsnGetSwitchPipelineRequest.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public long getExperimenter() {
            return 6035143L;
        }

        @Override
        public long getSubtype() {
            return 51L;
        }

        @Override
        public OFBsnGetSwitchPipelineRequest build() {
            long xid = this.xidSet ? this.xid : 0L;
            return new OFBsnGetSwitchPipelineRequestVer13(xid);
        }
    }

    static class BuilderWithParent
    implements OFBsnGetSwitchPipelineRequest.Builder {
        final OFBsnGetSwitchPipelineRequestVer13 parentMessage;
        private boolean xidSet;
        private long xid;

        BuilderWithParent(OFBsnGetSwitchPipelineRequestVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFType getType() {
            return OFType.EXPERIMENTER;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFBsnGetSwitchPipelineRequest.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public long getExperimenter() {
            return 6035143L;
        }

        @Override
        public long getSubtype() {
            return 51L;
        }

        @Override
        public OFBsnGetSwitchPipelineRequest build() {
            long xid = this.xidSet ? this.xid : this.parentMessage.xid;
            return new OFBsnGetSwitchPipelineRequestVer13(xid);
        }
    }
}

