/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.errormsg.OFBsnBaseError;
import org.projectfloodlight.openflow.protocol.ver13.OFBsnErrorVer13;
import org.projectfloodlight.openflow.protocol.ver13.OFBsnGentableErrorVer13;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;

abstract class OFBsnBaseErrorVer13 {
    static final byte WIRE_VERSION = 4;
    static final int MINIMUM_LENGTH = 272;
    public static final Reader READER = new Reader();

    OFBsnBaseErrorVer13() {
    }

    static class Reader
    implements OFMessageReader<OFBsnBaseError> {
        Reader() {
        }

        @Override
        public OFBsnBaseError readFrom(ByteBuf bb) throws OFParseError {
            if (bb.readableBytes() < 272) {
                return null;
            }
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 4) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_13(4), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 1) {
                throw new OFParseError("Wrong type: Expected=OFType.ERROR(1), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length < 272) {
                throw new OFParseError("Wrong length: Expected to be >= 272, was: " + length);
            }
            U32.f(bb.readInt());
            short errType = bb.readShort();
            if (errType != -1) {
                throw new OFParseError("Wrong errType: Expected=OFErrorType.EXPERIMENTER(65535), got=" + errType);
            }
            short subtype = bb.readShort();
            bb.readerIndex(start);
            switch (subtype) {
                case 1: {
                    return OFBsnErrorVer13.READER.readFrom(bb);
                }
                case 2: {
                    return OFBsnGentableErrorVer13.READER.readFrom(bb);
                }
            }
            throw new OFParseError("Unknown value for discriminator subtype of class OFBsnBaseErrorVer13: " + subtype);
        }
    }
}

