/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver12;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import java.util.List;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFHello;
import org.projectfloodlight.openflow.protocol.OFHelloElem;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFType;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFHelloVer12
implements OFHello {
    private static final Logger logger = LoggerFactory.getLogger(OFHelloVer12.class);
    static final byte WIRE_VERSION = 3;
    static final int LENGTH = 8;
    private static final long DEFAULT_XID = 0L;
    private final long xid;
    static final OFHelloVer12 DEFAULT = new OFHelloVer12(0L);
    static final Reader READER = new Reader();
    static final OFHelloVer12Funnel FUNNEL = new OFHelloVer12Funnel();
    static final Writer WRITER = new Writer();

    OFHelloVer12(long xid) {
        this.xid = U32.normalize(xid);
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_12;
    }

    @Override
    public OFType getType() {
        return OFType.HELLO;
    }

    @Override
    public long getXid() {
        return this.xid;
    }

    @Override
    public List<OFHelloElem> getElements() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property elements not supported in version 1.2");
    }

    @Override
    public OFHello.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFHelloVer12(");
        b.append("xid=").append(this.xid);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFHelloVer12 other = (OFHelloVer12)obj;
        return this.xid == other.xid;
    }

    @Override
    public boolean equalsIgnoreXid(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFHelloVer12 other = (OFHelloVer12)obj;
        return true;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.xid ^ this.xid >>> 32);
        return result;
    }

    @Override
    public int hashCodeIgnoreXid() {
        int prime = 31;
        int result = 1;
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFHelloVer12> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFHelloVer12 message) {
            bb.writeByte(3);
            bb.writeByte(0);
            bb.writeShort(8);
            bb.writeInt(U32.t(message.xid));
        }
    }

    static class OFHelloVer12Funnel
    implements Funnel<OFHelloVer12> {
        private static final long serialVersionUID = 1L;

        OFHelloVer12Funnel() {
        }

        public void funnel(OFHelloVer12 message, PrimitiveSink sink) {
            sink.putByte((byte)3);
            sink.putByte((byte)0);
            sink.putShort((short)8);
            sink.putLong(message.xid);
        }
    }

    static class Reader
    implements OFMessageReader<OFHello> {
        Reader() {
        }

        @Override
        public OFHello readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 3) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_12(3), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 0) {
                throw new OFParseError("Wrong type: Expected=OFType.HELLO(0), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 8) {
                throw new OFParseError("Wrong length: Expected=8(8), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long xid = U32.f(bb.readInt());
            OFHelloVer12 helloVer12 = new OFHelloVer12(xid);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)helloVer12);
            }
            return helloVer12;
        }
    }

    static class Builder
    implements OFHello.Builder {
        private boolean xidSet;
        private long xid;

        Builder() {
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_12;
        }

        @Override
        public OFType getType() {
            return OFType.HELLO;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFHello.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public List<OFHelloElem> getElements() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property elements not supported in version 1.2");
        }

        @Override
        public OFHello.Builder setElements(List<OFHelloElem> elements) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property elements not supported in version 1.2");
        }

        @Override
        public OFHello build() {
            long xid = this.xidSet ? this.xid : 0L;
            return new OFHelloVer12(xid);
        }
    }

    static class BuilderWithParent
    implements OFHello.Builder {
        final OFHelloVer12 parentMessage;
        private boolean xidSet;
        private long xid;

        BuilderWithParent(OFHelloVer12 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_12;
        }

        @Override
        public OFType getType() {
            return OFType.HELLO;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFHello.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public List<OFHelloElem> getElements() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property elements not supported in version 1.2");
        }

        @Override
        public OFHello.Builder setElements(List<OFHelloElem> elements) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property elements not supported in version 1.2");
        }

        @Override
        public OFHello build() {
            long xid = this.xidSet ? this.xid : this.parentMessage.xid;
            return new OFHelloVer12(xid);
        }
    }
}

