/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver12;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFEchoReply;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFType;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.projectfloodlight.openflow.util.ChannelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFEchoReplyVer12
implements OFEchoReply {
    private static final Logger logger = LoggerFactory.getLogger(OFEchoReplyVer12.class);
    static final byte WIRE_VERSION = 3;
    static final int MINIMUM_LENGTH = 8;
    static final int MAXIMUM_LENGTH = 65535;
    private static final long DEFAULT_XID = 0L;
    private static final byte[] DEFAULT_DATA = new byte[0];
    private final long xid;
    private final byte[] data;
    static final OFEchoReplyVer12 DEFAULT = new OFEchoReplyVer12(0L, DEFAULT_DATA);
    static final Reader READER = new Reader();
    static final OFEchoReplyVer12Funnel FUNNEL = new OFEchoReplyVer12Funnel();
    static final Writer WRITER = new Writer();

    OFEchoReplyVer12(long xid, byte[] data) {
        if (data == null) {
            throw new NullPointerException("OFEchoReplyVer12: property data cannot be null");
        }
        this.xid = U32.normalize(xid);
        this.data = data;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_12;
    }

    @Override
    public OFType getType() {
        return OFType.ECHO_REPLY;
    }

    @Override
    public long getXid() {
        return this.xid;
    }

    @Override
    public byte[] getData() {
        return this.data;
    }

    @Override
    public OFEchoReply.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFEchoReplyVer12(");
        b.append("xid=").append(this.xid);
        b.append(", ");
        b.append("data=").append(Arrays.toString(this.data));
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFEchoReplyVer12 other = (OFEchoReplyVer12)obj;
        if (this.xid != other.xid) {
            return false;
        }
        return Arrays.equals(this.data, other.data);
    }

    @Override
    public boolean equalsIgnoreXid(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFEchoReplyVer12 other = (OFEchoReplyVer12)obj;
        return Arrays.equals(this.data, other.data);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.xid ^ this.xid >>> 32);
        result = 31 * result + Arrays.hashCode(this.data);
        return result;
    }

    @Override
    public int hashCodeIgnoreXid() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.data);
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFEchoReplyVer12> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFEchoReplyVer12 message) {
            int startIndex = bb.writerIndex();
            bb.writeByte(3);
            bb.writeByte(3);
            int lengthIndex = bb.writerIndex();
            bb.writeShort((int)U16.t(0));
            bb.writeInt(U32.t(message.xid));
            bb.writeBytes(message.data);
            int length = bb.writerIndex() - startIndex;
            if (length > 65535) {
                throw new IllegalArgumentException("OFEchoReplyVer12: message length (" + length + ") exceeds maximum (0xFFFF)");
            }
            bb.setShort(lengthIndex, length);
        }
    }

    static class OFEchoReplyVer12Funnel
    implements Funnel<OFEchoReplyVer12> {
        private static final long serialVersionUID = 1L;

        OFEchoReplyVer12Funnel() {
        }

        public void funnel(OFEchoReplyVer12 message, PrimitiveSink sink) {
            sink.putByte((byte)3);
            sink.putByte((byte)3);
            sink.putLong(message.xid);
            sink.putBytes(message.data);
        }
    }

    static class Reader
    implements OFMessageReader<OFEchoReply> {
        Reader() {
        }

        @Override
        public OFEchoReply readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 3) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_12(3), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 3) {
                throw new OFParseError("Wrong type: Expected=OFType.ECHO_REPLY(3), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length < 8) {
                throw new OFParseError("Wrong length: Expected to be >= 8, was: " + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long xid = U32.f(bb.readInt());
            byte[] data = ChannelUtils.readBytes(bb, length - (bb.readerIndex() - start));
            OFEchoReplyVer12 echoReplyVer12 = new OFEchoReplyVer12(xid, data);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)echoReplyVer12);
            }
            return echoReplyVer12;
        }
    }

    static class Builder
    implements OFEchoReply.Builder {
        private boolean xidSet;
        private long xid;
        private boolean dataSet;
        private byte[] data;

        Builder() {
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_12;
        }

        @Override
        public OFType getType() {
            return OFType.ECHO_REPLY;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFEchoReply.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public byte[] getData() {
            return this.data;
        }

        @Override
        public OFEchoReply.Builder setData(byte[] data) {
            this.data = data;
            this.dataSet = true;
            return this;
        }

        @Override
        public OFEchoReply build() {
            byte[] data;
            long xid = this.xidSet ? this.xid : 0L;
            byte[] byArray = data = this.dataSet ? this.data : DEFAULT_DATA;
            if (data == null) {
                throw new NullPointerException("Property data must not be null");
            }
            return new OFEchoReplyVer12(xid, data);
        }
    }

    static class BuilderWithParent
    implements OFEchoReply.Builder {
        final OFEchoReplyVer12 parentMessage;
        private boolean xidSet;
        private long xid;
        private boolean dataSet;
        private byte[] data;

        BuilderWithParent(OFEchoReplyVer12 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_12;
        }

        @Override
        public OFType getType() {
            return OFType.ECHO_REPLY;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFEchoReply.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public byte[] getData() {
            return this.data;
        }

        @Override
        public OFEchoReply.Builder setData(byte[] data) {
            this.data = data;
            this.dataSet = true;
            return this;
        }

        @Override
        public OFEchoReply build() {
            byte[] data;
            long xid = this.xidSet ? this.xid : this.parentMessage.xid;
            byte[] byArray = data = this.dataSet ? this.data : this.parentMessage.data;
            if (data == null) {
                throw new NullPointerException("Property data must not be null");
            }
            return new OFEchoReplyVer12(xid, data);
        }
    }
}

