/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver12;

import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFActionType;

public class OFActionTypeSerializerVer12 {
    public static final short OUTPUT_VAL = 0;
    public static final short COPY_TTL_OUT_VAL = 11;
    public static final short COPY_TTL_IN_VAL = 12;
    public static final short SET_MPLS_TTL_VAL = 15;
    public static final short DEC_MPLS_TTL_VAL = 16;
    public static final short PUSH_VLAN_VAL = 17;
    public static final short POP_VLAN_VAL = 18;
    public static final short PUSH_MPLS_VAL = 19;
    public static final short POP_MPLS_VAL = 20;
    public static final short SET_QUEUE_VAL = 21;
    public static final short GROUP_VAL = 22;
    public static final short SET_NW_TTL_VAL = 23;
    public static final short DEC_NW_TTL_VAL = 24;
    public static final short SET_FIELD_VAL = 25;
    public static final short EXPERIMENTER_VAL = -1;

    public static OFActionType readFrom(ByteBuf bb) throws OFParseError {
        try {
            return OFActionTypeSerializerVer12.ofWireValue(bb.readShort());
        }
        catch (IllegalArgumentException e) {
            throw new OFParseError(e);
        }
    }

    public static void writeTo(ByteBuf bb, OFActionType e) {
        bb.writeShort((int)OFActionTypeSerializerVer12.toWireValue(e));
    }

    public static void putTo(OFActionType e, PrimitiveSink sink) {
        sink.putShort(OFActionTypeSerializerVer12.toWireValue(e));
    }

    public static OFActionType ofWireValue(short val) {
        switch (val) {
            case 0: {
                return OFActionType.OUTPUT;
            }
            case 11: {
                return OFActionType.COPY_TTL_OUT;
            }
            case 12: {
                return OFActionType.COPY_TTL_IN;
            }
            case 15: {
                return OFActionType.SET_MPLS_TTL;
            }
            case 16: {
                return OFActionType.DEC_MPLS_TTL;
            }
            case 17: {
                return OFActionType.PUSH_VLAN;
            }
            case 18: {
                return OFActionType.POP_VLAN;
            }
            case 19: {
                return OFActionType.PUSH_MPLS;
            }
            case 20: {
                return OFActionType.POP_MPLS;
            }
            case 21: {
                return OFActionType.SET_QUEUE;
            }
            case 22: {
                return OFActionType.GROUP;
            }
            case 23: {
                return OFActionType.SET_NW_TTL;
            }
            case 24: {
                return OFActionType.DEC_NW_TTL;
            }
            case 25: {
                return OFActionType.SET_FIELD;
            }
            case -1: {
                return OFActionType.EXPERIMENTER;
            }
        }
        throw new IllegalArgumentException("Illegal wire value for type OFActionType in version 1.2: " + val);
    }

    public static short toWireValue(OFActionType e) {
        switch (e) {
            case OUTPUT: {
                return 0;
            }
            case COPY_TTL_OUT: {
                return 11;
            }
            case COPY_TTL_IN: {
                return 12;
            }
            case SET_MPLS_TTL: {
                return 15;
            }
            case DEC_MPLS_TTL: {
                return 16;
            }
            case PUSH_VLAN: {
                return 17;
            }
            case POP_VLAN: {
                return 18;
            }
            case PUSH_MPLS: {
                return 19;
            }
            case POP_MPLS: {
                return 20;
            }
            case SET_QUEUE: {
                return 21;
            }
            case GROUP: {
                return 22;
            }
            case SET_NW_TTL: {
                return 23;
            }
            case DEC_NW_TTL: {
                return 24;
            }
            case SET_FIELD: {
                return 25;
            }
            case EXPERIMENTER: {
                return -1;
            }
        }
        throw new IllegalArgumentException("Illegal enum value for type OFActionType in version 1.2: " + (Object)((Object)e));
    }
}

