/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver11;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFErrorType;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFTableModFailedCode;
import org.projectfloodlight.openflow.protocol.OFType;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.errormsg.OFTableModFailedErrorMsg;
import org.projectfloodlight.openflow.protocol.ver11.OFTableModFailedCodeSerializerVer11;
import org.projectfloodlight.openflow.types.OFErrorCauseData;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFTableModFailedErrorMsgVer11
implements OFTableModFailedErrorMsg {
    private static final Logger logger = LoggerFactory.getLogger(OFTableModFailedErrorMsgVer11.class);
    static final byte WIRE_VERSION = 2;
    static final int MINIMUM_LENGTH = 12;
    static final int MAXIMUM_LENGTH = 65535;
    private static final long DEFAULT_XID = 0L;
    private static final OFErrorCauseData DEFAULT_DATA = OFErrorCauseData.NONE;
    private final long xid;
    private final OFTableModFailedCode code;
    private final OFErrorCauseData data;
    static final Reader READER = new Reader();
    static final OFTableModFailedErrorMsgVer11Funnel FUNNEL = new OFTableModFailedErrorMsgVer11Funnel();
    static final Writer WRITER = new Writer();

    OFTableModFailedErrorMsgVer11(long xid, OFTableModFailedCode code, OFErrorCauseData data) {
        if (code == null) {
            throw new NullPointerException("OFTableModFailedErrorMsgVer11: property code cannot be null");
        }
        if (data == null) {
            throw new NullPointerException("OFTableModFailedErrorMsgVer11: property data cannot be null");
        }
        this.xid = U32.normalize(xid);
        this.code = code;
        this.data = data;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_11;
    }

    @Override
    public OFType getType() {
        return OFType.ERROR;
    }

    @Override
    public long getXid() {
        return this.xid;
    }

    @Override
    public OFErrorType getErrType() {
        return OFErrorType.TABLE_MOD_FAILED;
    }

    @Override
    public OFTableModFailedCode getCode() {
        return this.code;
    }

    @Override
    public OFErrorCauseData getData() {
        return this.data;
    }

    @Override
    public OFTableModFailedErrorMsg.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFTableModFailedErrorMsgVer11(");
        b.append("xid=").append(this.xid);
        b.append(", ");
        b.append("code=").append((Object)this.code);
        b.append(", ");
        b.append("data=").append(this.data);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFTableModFailedErrorMsgVer11 other = (OFTableModFailedErrorMsgVer11)obj;
        if (this.xid != other.xid) {
            return false;
        }
        if (this.code == null ? other.code != null : !this.code.equals((Object)other.code)) {
            return false;
        }
        return !(this.data == null ? other.data != null : !this.data.equals(other.data));
    }

    @Override
    public boolean equalsIgnoreXid(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFTableModFailedErrorMsgVer11 other = (OFTableModFailedErrorMsgVer11)obj;
        if (this.code == null ? other.code != null : !this.code.equals((Object)other.code)) {
            return false;
        }
        return !(this.data == null ? other.data != null : !this.data.equals(other.data));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.xid ^ this.xid >>> 32);
        result = 31 * result + (this.code == null ? 0 : this.code.hashCode());
        result = 31 * result + (this.data == null ? 0 : this.data.hashCode());
        return result;
    }

    @Override
    public int hashCodeIgnoreXid() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.code == null ? 0 : this.code.hashCode());
        result = 31 * result + (this.data == null ? 0 : this.data.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFTableModFailedErrorMsgVer11> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFTableModFailedErrorMsgVer11 message) {
            int startIndex = bb.writerIndex();
            bb.writeByte(2);
            bb.writeByte(1);
            int lengthIndex = bb.writerIndex();
            bb.writeShort((int)U16.t(0));
            bb.writeInt(U32.t(message.xid));
            bb.writeShort(8);
            OFTableModFailedCodeSerializerVer11.writeTo(bb, message.code);
            message.data.writeTo(bb);
            int length = bb.writerIndex() - startIndex;
            if (length > 65535) {
                throw new IllegalArgumentException("OFTableModFailedErrorMsgVer11: message length (" + length + ") exceeds maximum (0xFFFF)");
            }
            bb.setShort(lengthIndex, length);
        }
    }

    static class OFTableModFailedErrorMsgVer11Funnel
    implements Funnel<OFTableModFailedErrorMsgVer11> {
        private static final long serialVersionUID = 1L;

        OFTableModFailedErrorMsgVer11Funnel() {
        }

        public void funnel(OFTableModFailedErrorMsgVer11 message, PrimitiveSink sink) {
            sink.putByte((byte)2);
            sink.putByte((byte)1);
            sink.putLong(message.xid);
            sink.putShort((short)8);
            OFTableModFailedCodeSerializerVer11.putTo(message.code, sink);
            message.data.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFTableModFailedErrorMsg> {
        Reader() {
        }

        @Override
        public OFTableModFailedErrorMsg readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 2) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_11(2), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 1) {
                throw new OFParseError("Wrong type: Expected=OFType.ERROR(1), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length < 12) {
                throw new OFParseError("Wrong length: Expected to be >= 12, was: " + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long xid = U32.f(bb.readInt());
            short errType = bb.readShort();
            if (errType != 8) {
                throw new OFParseError("Wrong errType: Expected=OFErrorType.TABLE_MOD_FAILED(8), got=" + errType);
            }
            OFTableModFailedCode code = OFTableModFailedCodeSerializerVer11.readFrom(bb);
            OFErrorCauseData data = OFErrorCauseData.read(bb, length - (bb.readerIndex() - start), OFVersion.OF_11);
            OFTableModFailedErrorMsgVer11 tableModFailedErrorMsgVer11 = new OFTableModFailedErrorMsgVer11(xid, code, data);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)tableModFailedErrorMsgVer11);
            }
            return tableModFailedErrorMsgVer11;
        }
    }

    static class Builder
    implements OFTableModFailedErrorMsg.Builder {
        private boolean xidSet;
        private long xid;
        private boolean codeSet;
        private OFTableModFailedCode code;
        private boolean dataSet;
        private OFErrorCauseData data;

        Builder() {
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_11;
        }

        @Override
        public OFType getType() {
            return OFType.ERROR;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFTableModFailedErrorMsg.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public OFErrorType getErrType() {
            return OFErrorType.TABLE_MOD_FAILED;
        }

        @Override
        public OFTableModFailedCode getCode() {
            return this.code;
        }

        @Override
        public OFTableModFailedErrorMsg.Builder setCode(OFTableModFailedCode code) {
            this.code = code;
            this.codeSet = true;
            return this;
        }

        @Override
        public OFErrorCauseData getData() {
            return this.data;
        }

        @Override
        public OFTableModFailedErrorMsg.Builder setData(OFErrorCauseData data) {
            this.data = data;
            this.dataSet = true;
            return this;
        }

        @Override
        public OFTableModFailedErrorMsg build() {
            OFErrorCauseData data;
            long xid;
            long l = xid = this.xidSet ? this.xid : 0L;
            if (!this.codeSet) {
                throw new IllegalStateException("Property code doesn't have default value -- must be set");
            }
            if (this.code == null) {
                throw new NullPointerException("Property code must not be null");
            }
            OFErrorCauseData oFErrorCauseData = data = this.dataSet ? this.data : DEFAULT_DATA;
            if (data == null) {
                throw new NullPointerException("Property data must not be null");
            }
            return new OFTableModFailedErrorMsgVer11(xid, this.code, data);
        }
    }

    static class BuilderWithParent
    implements OFTableModFailedErrorMsg.Builder {
        final OFTableModFailedErrorMsgVer11 parentMessage;
        private boolean xidSet;
        private long xid;
        private boolean codeSet;
        private OFTableModFailedCode code;
        private boolean dataSet;
        private OFErrorCauseData data;

        BuilderWithParent(OFTableModFailedErrorMsgVer11 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_11;
        }

        @Override
        public OFType getType() {
            return OFType.ERROR;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFTableModFailedErrorMsg.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public OFErrorType getErrType() {
            return OFErrorType.TABLE_MOD_FAILED;
        }

        @Override
        public OFTableModFailedCode getCode() {
            return this.code;
        }

        @Override
        public OFTableModFailedErrorMsg.Builder setCode(OFTableModFailedCode code) {
            this.code = code;
            this.codeSet = true;
            return this;
        }

        @Override
        public OFErrorCauseData getData() {
            return this.data;
        }

        @Override
        public OFTableModFailedErrorMsg.Builder setData(OFErrorCauseData data) {
            this.data = data;
            this.dataSet = true;
            return this;
        }

        @Override
        public OFTableModFailedErrorMsg build() {
            OFErrorCauseData data;
            OFTableModFailedCode code;
            long xid = this.xidSet ? this.xid : this.parentMessage.xid;
            OFTableModFailedCode oFTableModFailedCode = code = this.codeSet ? this.code : this.parentMessage.code;
            if (code == null) {
                throw new NullPointerException("Property code must not be null");
            }
            OFErrorCauseData oFErrorCauseData = data = this.dataSet ? this.data : this.parentMessage.data;
            if (data == null) {
                throw new NullPointerException("Property data must not be null");
            }
            return new OFTableModFailedErrorMsgVer11(xid, code, data);
        }
    }
}

