/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver11;

import com.google.common.collect.ImmutableList;
import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import java.util.List;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFPacketQueue;
import org.projectfloodlight.openflow.protocol.OFQueueGetConfigReply;
import org.projectfloodlight.openflow.protocol.OFType;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.ver11.OFPacketQueueVer11;
import org.projectfloodlight.openflow.types.OFPort;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.projectfloodlight.openflow.util.ChannelUtils;
import org.projectfloodlight.openflow.util.FunnelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFQueueGetConfigReplyVer11
implements OFQueueGetConfigReply {
    private static final Logger logger = LoggerFactory.getLogger(OFQueueGetConfigReplyVer11.class);
    static final byte WIRE_VERSION = 2;
    static final int MINIMUM_LENGTH = 16;
    static final int MAXIMUM_LENGTH = 65535;
    private static final long DEFAULT_XID = 0L;
    private static final OFPort DEFAULT_PORT = OFPort.ANY;
    private static final List<OFPacketQueue> DEFAULT_QUEUES = ImmutableList.of();
    private final long xid;
    private final OFPort port;
    private final List<OFPacketQueue> queues;
    static final OFQueueGetConfigReplyVer11 DEFAULT = new OFQueueGetConfigReplyVer11(0L, DEFAULT_PORT, DEFAULT_QUEUES);
    static final Reader READER = new Reader();
    static final OFQueueGetConfigReplyVer11Funnel FUNNEL = new OFQueueGetConfigReplyVer11Funnel();
    static final Writer WRITER = new Writer();

    OFQueueGetConfigReplyVer11(long xid, OFPort port, List<OFPacketQueue> queues) {
        if (port == null) {
            throw new NullPointerException("OFQueueGetConfigReplyVer11: property port cannot be null");
        }
        if (queues == null) {
            throw new NullPointerException("OFQueueGetConfigReplyVer11: property queues cannot be null");
        }
        this.xid = U32.normalize(xid);
        this.port = port;
        this.queues = queues;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_11;
    }

    @Override
    public OFType getType() {
        return OFType.QUEUE_GET_CONFIG_REPLY;
    }

    @Override
    public long getXid() {
        return this.xid;
    }

    @Override
    public OFPort getPort() {
        return this.port;
    }

    @Override
    public List<OFPacketQueue> getQueues() {
        return this.queues;
    }

    @Override
    public OFQueueGetConfigReply.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFQueueGetConfigReplyVer11(");
        b.append("xid=").append(this.xid);
        b.append(", ");
        b.append("port=").append(this.port);
        b.append(", ");
        b.append("queues=").append(this.queues);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFQueueGetConfigReplyVer11 other = (OFQueueGetConfigReplyVer11)obj;
        if (this.xid != other.xid) {
            return false;
        }
        if (this.port == null ? other.port != null : !this.port.equals(other.port)) {
            return false;
        }
        return !(this.queues == null ? other.queues != null : !this.queues.equals(other.queues));
    }

    @Override
    public boolean equalsIgnoreXid(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFQueueGetConfigReplyVer11 other = (OFQueueGetConfigReplyVer11)obj;
        if (this.port == null ? other.port != null : !this.port.equals(other.port)) {
            return false;
        }
        return !(this.queues == null ? other.queues != null : !this.queues.equals(other.queues));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.xid ^ this.xid >>> 32);
        result = 31 * result + (this.port == null ? 0 : this.port.hashCode());
        result = 31 * result + (this.queues == null ? 0 : this.queues.hashCode());
        return result;
    }

    @Override
    public int hashCodeIgnoreXid() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.port == null ? 0 : this.port.hashCode());
        result = 31 * result + (this.queues == null ? 0 : this.queues.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFQueueGetConfigReplyVer11> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFQueueGetConfigReplyVer11 message) {
            int startIndex = bb.writerIndex();
            bb.writeByte(2);
            bb.writeByte(23);
            int lengthIndex = bb.writerIndex();
            bb.writeShort((int)U16.t(0));
            bb.writeInt(U32.t(message.xid));
            message.port.write4Bytes(bb);
            bb.writeZero(4);
            ChannelUtils.writeList(bb, message.queues);
            int length = bb.writerIndex() - startIndex;
            if (length > 65535) {
                throw new IllegalArgumentException("OFQueueGetConfigReplyVer11: message length (" + length + ") exceeds maximum (0xFFFF)");
            }
            bb.setShort(lengthIndex, length);
        }
    }

    static class OFQueueGetConfigReplyVer11Funnel
    implements Funnel<OFQueueGetConfigReplyVer11> {
        private static final long serialVersionUID = 1L;

        OFQueueGetConfigReplyVer11Funnel() {
        }

        public void funnel(OFQueueGetConfigReplyVer11 message, PrimitiveSink sink) {
            sink.putByte((byte)2);
            sink.putByte((byte)23);
            sink.putLong(message.xid);
            message.port.putTo(sink);
            FunnelUtils.putList(message.queues, sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFQueueGetConfigReply> {
        Reader() {
        }

        @Override
        public OFQueueGetConfigReply readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 2) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_11(2), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 23) {
                throw new OFParseError("Wrong type: Expected=OFType.QUEUE_GET_CONFIG_REPLY(23), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length < 16) {
                throw new OFParseError("Wrong length: Expected to be >= 16, was: " + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long xid = U32.f(bb.readInt());
            OFPort port = OFPort.read4Bytes(bb);
            bb.skipBytes(4);
            List<OFPacketQueue> queues = ChannelUtils.readList(bb, length - (bb.readerIndex() - start), OFPacketQueueVer11.READER);
            OFQueueGetConfigReplyVer11 queueGetConfigReplyVer11 = new OFQueueGetConfigReplyVer11(xid, port, queues);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)queueGetConfigReplyVer11);
            }
            return queueGetConfigReplyVer11;
        }
    }

    static class Builder
    implements OFQueueGetConfigReply.Builder {
        private boolean xidSet;
        private long xid;
        private boolean portSet;
        private OFPort port;
        private boolean queuesSet;
        private List<OFPacketQueue> queues;

        Builder() {
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_11;
        }

        @Override
        public OFType getType() {
            return OFType.QUEUE_GET_CONFIG_REPLY;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFQueueGetConfigReply.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public OFPort getPort() {
            return this.port;
        }

        @Override
        public OFQueueGetConfigReply.Builder setPort(OFPort port) {
            this.port = port;
            this.portSet = true;
            return this;
        }

        @Override
        public List<OFPacketQueue> getQueues() {
            return this.queues;
        }

        @Override
        public OFQueueGetConfigReply.Builder setQueues(List<OFPacketQueue> queues) {
            this.queues = queues;
            this.queuesSet = true;
            return this;
        }

        @Override
        public OFQueueGetConfigReply build() {
            List<OFPacketQueue> queues;
            OFPort port;
            long xid = this.xidSet ? this.xid : 0L;
            OFPort oFPort = port = this.portSet ? this.port : DEFAULT_PORT;
            if (port == null) {
                throw new NullPointerException("Property port must not be null");
            }
            List<OFPacketQueue> list = queues = this.queuesSet ? this.queues : DEFAULT_QUEUES;
            if (queues == null) {
                throw new NullPointerException("Property queues must not be null");
            }
            return new OFQueueGetConfigReplyVer11(xid, port, queues);
        }
    }

    static class BuilderWithParent
    implements OFQueueGetConfigReply.Builder {
        final OFQueueGetConfigReplyVer11 parentMessage;
        private boolean xidSet;
        private long xid;
        private boolean portSet;
        private OFPort port;
        private boolean queuesSet;
        private List<OFPacketQueue> queues;

        BuilderWithParent(OFQueueGetConfigReplyVer11 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_11;
        }

        @Override
        public OFType getType() {
            return OFType.QUEUE_GET_CONFIG_REPLY;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFQueueGetConfigReply.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public OFPort getPort() {
            return this.port;
        }

        @Override
        public OFQueueGetConfigReply.Builder setPort(OFPort port) {
            this.port = port;
            this.portSet = true;
            return this;
        }

        @Override
        public List<OFPacketQueue> getQueues() {
            return this.queues;
        }

        @Override
        public OFQueueGetConfigReply.Builder setQueues(List<OFPacketQueue> queues) {
            this.queues = queues;
            this.queuesSet = true;
            return this;
        }

        @Override
        public OFQueueGetConfigReply build() {
            List queues;
            OFPort port;
            long xid = this.xidSet ? this.xid : this.parentMessage.xid;
            OFPort oFPort = port = this.portSet ? this.port : this.parentMessage.port;
            if (port == null) {
                throw new NullPointerException("Property port must not be null");
            }
            List list = queues = this.queuesSet ? this.queues : this.parentMessage.queues;
            if (queues == null) {
                throw new NullPointerException("Property queues must not be null");
            }
            return new OFQueueGetConfigReplyVer11(xid, port, queues);
        }
    }
}

