/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver11;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMatchV2;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.match.Match;
import org.projectfloodlight.openflow.protocol.match.MatchField;
import org.projectfloodlight.openflow.types.IPv4Address;
import org.projectfloodlight.openflow.types.MacAddress;
import org.projectfloodlight.openflow.types.Masked;
import org.projectfloodlight.openflow.types.OFPort;
import org.projectfloodlight.openflow.types.OFValueType;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.projectfloodlight.openflow.types.U64;
import org.projectfloodlight.openflow.types.U8;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFMatchV2Ver11
implements OFMatchV2 {
    private static final Logger logger = LoggerFactory.getLogger(OFMatchV2Ver11.class);
    static final byte WIRE_VERSION = 2;
    static final int LENGTH = 88;
    private static final OFPort DEFAULT_IN_PORT = OFPort.ANY;
    private static final int DEFAULT_WILDCARDS = 1023;
    private static final MacAddress DEFAULT_ETH_SRC = MacAddress.NONE;
    private static final MacAddress DEFAULT_ETH_SRC_MASK = MacAddress.NONE;
    private static final MacAddress DEFAULT_ETH_DST = MacAddress.NONE;
    private static final MacAddress DEFAULT_ETH_DST_MASK = MacAddress.NONE;
    private static final int DEFAULT_VLAN_VID = 0;
    private static final short DEFAULT_VLAN_PCP = 0;
    private static final int DEFAULT_ETH_TYPE = 0;
    private static final short DEFAULT_IP_DSCP = 0;
    private static final short DEFAULT_IP_PROTO = 0;
    private static final IPv4Address DEFAULT_IPV4_SRC = IPv4Address.NONE;
    private static final IPv4Address DEFAULT_IPV4_SRC_MASK = IPv4Address.NONE;
    private static final IPv4Address DEFAULT_IPV4_DST = IPv4Address.NONE;
    private static final IPv4Address DEFAULT_IPV4_DST_MASK = IPv4Address.NONE;
    private static final int DEFAULT_TCP_SRC = 0;
    private static final int DEFAULT_TCP_DST = 0;
    private static final long DEFAULT_MPLS_LABEL = 0L;
    private static final short DEFAULT_MPLS_TC = 0;
    private static final U64 DEFAULT_METADATA = U64.ZERO;
    private static final U64 DEFAULT_METADATA_MASK = U64.ZERO;
    private final OFPort inPort;
    private final int wildcards;
    private final MacAddress ethSrc;
    private final MacAddress ethSrcMask;
    private final MacAddress ethDst;
    private final MacAddress ethDstMask;
    private final int vlanVid;
    private final short vlanPcp;
    private final int ethType;
    private final short ipDscp;
    private final short ipProto;
    private final IPv4Address ipv4Src;
    private final IPv4Address ipv4SrcMask;
    private final IPv4Address ipv4Dst;
    private final IPv4Address ipv4DstMask;
    private final int tcpSrc;
    private final int tcpDst;
    private final long mplsLabel;
    private final short mplsTc;
    private final U64 metadata;
    private final U64 metadataMask;
    static final OFMatchV2Ver11 DEFAULT = new OFMatchV2Ver11(DEFAULT_IN_PORT, 1023, DEFAULT_ETH_SRC, DEFAULT_ETH_SRC_MASK, DEFAULT_ETH_DST, DEFAULT_ETH_DST_MASK, 0, 0, 0, 0, 0, DEFAULT_IPV4_SRC, DEFAULT_IPV4_SRC_MASK, DEFAULT_IPV4_DST, DEFAULT_IPV4_DST_MASK, 0, 0, 0L, 0, DEFAULT_METADATA, DEFAULT_METADATA_MASK);
    static final Reader READER = new Reader();
    static final OFMatchV2Ver11Funnel FUNNEL = new OFMatchV2Ver11Funnel();
    static final Writer WRITER = new Writer();

    OFMatchV2Ver11(OFPort inPort, int wildcards, MacAddress ethSrc, MacAddress ethSrcMask, MacAddress ethDst, MacAddress ethDstMask, int vlanVid, short vlanPcp, int ethType, short ipDscp, short ipProto, IPv4Address ipv4Src, IPv4Address ipv4SrcMask, IPv4Address ipv4Dst, IPv4Address ipv4DstMask, int tcpSrc, int tcpDst, long mplsLabel, short mplsTc, U64 metadata, U64 metadataMask) {
        if (inPort == null) {
            throw new NullPointerException("OFMatchV2Ver11: property inPort cannot be null");
        }
        if (ethSrc == null) {
            throw new NullPointerException("OFMatchV2Ver11: property ethSrc cannot be null");
        }
        if (ethSrcMask == null) {
            throw new NullPointerException("OFMatchV2Ver11: property ethSrcMask cannot be null");
        }
        if (ethDst == null) {
            throw new NullPointerException("OFMatchV2Ver11: property ethDst cannot be null");
        }
        if (ethDstMask == null) {
            throw new NullPointerException("OFMatchV2Ver11: property ethDstMask cannot be null");
        }
        if (ipv4Src == null) {
            throw new NullPointerException("OFMatchV2Ver11: property ipv4Src cannot be null");
        }
        if (ipv4SrcMask == null) {
            throw new NullPointerException("OFMatchV2Ver11: property ipv4SrcMask cannot be null");
        }
        if (ipv4Dst == null) {
            throw new NullPointerException("OFMatchV2Ver11: property ipv4Dst cannot be null");
        }
        if (ipv4DstMask == null) {
            throw new NullPointerException("OFMatchV2Ver11: property ipv4DstMask cannot be null");
        }
        if (metadata == null) {
            throw new NullPointerException("OFMatchV2Ver11: property metadata cannot be null");
        }
        if (metadataMask == null) {
            throw new NullPointerException("OFMatchV2Ver11: property metadataMask cannot be null");
        }
        this.inPort = inPort;
        this.wildcards = wildcards;
        this.ethSrc = ethSrc;
        this.ethSrcMask = ethSrcMask;
        this.ethDst = ethDst;
        this.ethDstMask = ethDstMask;
        this.vlanVid = U16.normalize(vlanVid);
        this.vlanPcp = U8.normalize(vlanPcp);
        this.ethType = U16.normalize(ethType);
        this.ipDscp = U8.normalize(ipDscp);
        this.ipProto = U8.normalize(ipProto);
        this.ipv4Src = ipv4Src;
        this.ipv4SrcMask = ipv4SrcMask;
        this.ipv4Dst = ipv4Dst;
        this.ipv4DstMask = ipv4DstMask;
        this.tcpSrc = U16.normalize(tcpSrc);
        this.tcpDst = U16.normalize(tcpDst);
        this.mplsLabel = U32.normalize(mplsLabel);
        this.mplsTc = U8.normalize(mplsTc);
        this.metadata = metadata;
        this.metadataMask = metadataMask;
    }

    @Override
    public int getType() {
        return 0;
    }

    @Override
    public OFPort getInPort() {
        return this.inPort;
    }

    @Override
    public int getWildcards() {
        return this.wildcards;
    }

    @Override
    public MacAddress getEthSrc() {
        return this.ethSrc;
    }

    @Override
    public MacAddress getEthSrcMask() {
        return this.ethSrcMask;
    }

    @Override
    public MacAddress getEthDst() {
        return this.ethDst;
    }

    @Override
    public MacAddress getEthDstMask() {
        return this.ethDstMask;
    }

    @Override
    public int getVlanVid() {
        return this.vlanVid;
    }

    @Override
    public short getVlanPcp() {
        return this.vlanPcp;
    }

    @Override
    public int getEthType() {
        return this.ethType;
    }

    @Override
    public short getIpDscp() {
        return this.ipDscp;
    }

    @Override
    public short getIpProto() {
        return this.ipProto;
    }

    @Override
    public IPv4Address getIpv4Src() {
        return this.ipv4Src;
    }

    @Override
    public IPv4Address getIpv4SrcMask() {
        return this.ipv4SrcMask;
    }

    @Override
    public IPv4Address getIpv4Dst() {
        return this.ipv4Dst;
    }

    @Override
    public IPv4Address getIpv4DstMask() {
        return this.ipv4DstMask;
    }

    @Override
    public int getTcpSrc() {
        return this.tcpSrc;
    }

    @Override
    public int getTcpDst() {
        return this.tcpDst;
    }

    @Override
    public long getMplsLabel() {
        return this.mplsLabel;
    }

    @Override
    public short getMplsTc() {
        return this.mplsTc;
    }

    @Override
    public U64 getMetadata() {
        return this.metadata;
    }

    @Override
    public U64 getMetadataMask() {
        return this.metadataMask;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_11;
    }

    @Override
    public <F extends OFValueType<F>> F get(MatchField<F> field) throws UnsupportedOperationException {
        return null;
    }

    @Override
    public <F extends OFValueType<F>> Masked<F> getMasked(MatchField<F> field) throws UnsupportedOperationException {
        return null;
    }

    @Override
    public boolean supports(MatchField<?> field) {
        return false;
    }

    @Override
    public boolean supportsMasked(MatchField<?> field) {
        return false;
    }

    @Override
    public boolean isExact(MatchField<?> field) {
        return false;
    }

    @Override
    public boolean isFullyWildcarded(MatchField<?> field) {
        return false;
    }

    @Override
    public boolean isPartiallyMasked(MatchField<?> field) {
        return false;
    }

    @Override
    public Iterable<MatchField<?>> getMatchFields() {
        throw new UnsupportedOperationException();
    }

    @Override
    public OFMatchV2.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFMatchV2Ver11(");
        b.append("inPort=").append(this.inPort);
        b.append(", ");
        b.append("wildcards=").append(this.wildcards);
        b.append(", ");
        b.append("ethSrc=").append(this.ethSrc);
        b.append(", ");
        b.append("ethSrcMask=").append(this.ethSrcMask);
        b.append(", ");
        b.append("ethDst=").append(this.ethDst);
        b.append(", ");
        b.append("ethDstMask=").append(this.ethDstMask);
        b.append(", ");
        b.append("vlanVid=").append(this.vlanVid);
        b.append(", ");
        b.append("vlanPcp=").append(this.vlanPcp);
        b.append(", ");
        b.append("ethType=").append(this.ethType);
        b.append(", ");
        b.append("ipDscp=").append(this.ipDscp);
        b.append(", ");
        b.append("ipProto=").append(this.ipProto);
        b.append(", ");
        b.append("ipv4Src=").append(this.ipv4Src);
        b.append(", ");
        b.append("ipv4SrcMask=").append(this.ipv4SrcMask);
        b.append(", ");
        b.append("ipv4Dst=").append(this.ipv4Dst);
        b.append(", ");
        b.append("ipv4DstMask=").append(this.ipv4DstMask);
        b.append(", ");
        b.append("tcpSrc=").append(this.tcpSrc);
        b.append(", ");
        b.append("tcpDst=").append(this.tcpDst);
        b.append(", ");
        b.append("mplsLabel=").append(this.mplsLabel);
        b.append(", ");
        b.append("mplsTc=").append(this.mplsTc);
        b.append(", ");
        b.append("metadata=").append(this.metadata);
        b.append(", ");
        b.append("metadataMask=").append(this.metadataMask);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFMatchV2Ver11 other = (OFMatchV2Ver11)obj;
        if (this.inPort == null ? other.inPort != null : !this.inPort.equals(other.inPort)) {
            return false;
        }
        if (this.wildcards != other.wildcards) {
            return false;
        }
        if (this.ethSrc == null ? other.ethSrc != null : !this.ethSrc.equals(other.ethSrc)) {
            return false;
        }
        if (this.ethSrcMask == null ? other.ethSrcMask != null : !this.ethSrcMask.equals(other.ethSrcMask)) {
            return false;
        }
        if (this.ethDst == null ? other.ethDst != null : !this.ethDst.equals(other.ethDst)) {
            return false;
        }
        if (this.ethDstMask == null ? other.ethDstMask != null : !this.ethDstMask.equals(other.ethDstMask)) {
            return false;
        }
        if (this.vlanVid != other.vlanVid) {
            return false;
        }
        if (this.vlanPcp != other.vlanPcp) {
            return false;
        }
        if (this.ethType != other.ethType) {
            return false;
        }
        if (this.ipDscp != other.ipDscp) {
            return false;
        }
        if (this.ipProto != other.ipProto) {
            return false;
        }
        if (this.ipv4Src == null ? other.ipv4Src != null : !this.ipv4Src.equals(other.ipv4Src)) {
            return false;
        }
        if (this.ipv4SrcMask == null ? other.ipv4SrcMask != null : !this.ipv4SrcMask.equals(other.ipv4SrcMask)) {
            return false;
        }
        if (this.ipv4Dst == null ? other.ipv4Dst != null : !this.ipv4Dst.equals(other.ipv4Dst)) {
            return false;
        }
        if (this.ipv4DstMask == null ? other.ipv4DstMask != null : !this.ipv4DstMask.equals(other.ipv4DstMask)) {
            return false;
        }
        if (this.tcpSrc != other.tcpSrc) {
            return false;
        }
        if (this.tcpDst != other.tcpDst) {
            return false;
        }
        if (this.mplsLabel != other.mplsLabel) {
            return false;
        }
        if (this.mplsTc != other.mplsTc) {
            return false;
        }
        if (this.metadata == null ? other.metadata != null : !this.metadata.equals(other.metadata)) {
            return false;
        }
        return !(this.metadataMask == null ? other.metadataMask != null : !this.metadataMask.equals(other.metadataMask));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.inPort == null ? 0 : this.inPort.hashCode());
        result = 31 * result + this.wildcards;
        result = 31 * result + (this.ethSrc == null ? 0 : this.ethSrc.hashCode());
        result = 31 * result + (this.ethSrcMask == null ? 0 : this.ethSrcMask.hashCode());
        result = 31 * result + (this.ethDst == null ? 0 : this.ethDst.hashCode());
        result = 31 * result + (this.ethDstMask == null ? 0 : this.ethDstMask.hashCode());
        result = 31 * result + this.vlanVid;
        result = 31 * result + this.vlanPcp;
        result = 31 * result + this.ethType;
        result = 31 * result + this.ipDscp;
        result = 31 * result + this.ipProto;
        result = 31 * result + (this.ipv4Src == null ? 0 : this.ipv4Src.hashCode());
        result = 31 * result + (this.ipv4SrcMask == null ? 0 : this.ipv4SrcMask.hashCode());
        result = 31 * result + (this.ipv4Dst == null ? 0 : this.ipv4Dst.hashCode());
        result = 31 * result + (this.ipv4DstMask == null ? 0 : this.ipv4DstMask.hashCode());
        result = 31 * result + this.tcpSrc;
        result = 31 * result + this.tcpDst;
        result = 31 * (int)(this.mplsLabel ^ this.mplsLabel >>> 32);
        result = 31 * result + this.mplsTc;
        result = 31 * result + (this.metadata == null ? 0 : this.metadata.hashCode());
        result = 31 * result + (this.metadataMask == null ? 0 : this.metadataMask.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFMatchV2Ver11> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFMatchV2Ver11 message) {
            bb.writeShort(0);
            bb.writeShort(88);
            message.inPort.write4Bytes(bb);
            bb.writeInt(message.wildcards);
            message.ethSrc.write6Bytes(bb);
            message.ethSrcMask.write6Bytes(bb);
            message.ethDst.write6Bytes(bb);
            message.ethDstMask.write6Bytes(bb);
            bb.writeShort((int)U16.t(message.vlanVid));
            bb.writeByte((int)U8.t(message.vlanPcp));
            bb.writeZero(1);
            bb.writeShort((int)U16.t(message.ethType));
            bb.writeByte((int)U8.t(message.ipDscp));
            bb.writeByte((int)U8.t(message.ipProto));
            message.ipv4Src.write4Bytes(bb);
            message.ipv4SrcMask.write4Bytes(bb);
            message.ipv4Dst.write4Bytes(bb);
            message.ipv4DstMask.write4Bytes(bb);
            bb.writeShort((int)U16.t(message.tcpSrc));
            bb.writeShort((int)U16.t(message.tcpDst));
            bb.writeInt(U32.t(message.mplsLabel));
            bb.writeByte((int)U8.t(message.mplsTc));
            bb.writeZero(3);
            bb.writeLong(message.metadata.getValue());
            bb.writeLong(message.metadataMask.getValue());
        }
    }

    static class OFMatchV2Ver11Funnel
    implements Funnel<OFMatchV2Ver11> {
        private static final long serialVersionUID = 1L;

        OFMatchV2Ver11Funnel() {
        }

        public void funnel(OFMatchV2Ver11 message, PrimitiveSink sink) {
            sink.putShort((short)0);
            sink.putShort((short)88);
            message.inPort.putTo(sink);
            sink.putInt(message.wildcards);
            message.ethSrc.putTo(sink);
            message.ethSrcMask.putTo(sink);
            message.ethDst.putTo(sink);
            message.ethDstMask.putTo(sink);
            sink.putInt(message.vlanVid);
            sink.putShort(message.vlanPcp);
            sink.putInt(message.ethType);
            sink.putShort(message.ipDscp);
            sink.putShort(message.ipProto);
            message.ipv4Src.putTo(sink);
            message.ipv4SrcMask.putTo(sink);
            message.ipv4Dst.putTo(sink);
            message.ipv4DstMask.putTo(sink);
            sink.putInt(message.tcpSrc);
            sink.putInt(message.tcpDst);
            sink.putLong(message.mplsLabel);
            sink.putShort(message.mplsTc);
            message.metadata.putTo(sink);
            message.metadataMask.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFMatchV2> {
        Reader() {
        }

        @Override
        public OFMatchV2 readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 0) {
                throw new OFParseError("Wrong type: Expected=0x0(0x0), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 88) {
                throw new OFParseError("Wrong length: Expected=88(88), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            OFPort inPort = OFPort.read4Bytes(bb);
            int wildcards = bb.readInt();
            MacAddress ethSrc = MacAddress.read6Bytes(bb);
            MacAddress ethSrcMask = MacAddress.read6Bytes(bb);
            MacAddress ethDst = MacAddress.read6Bytes(bb);
            MacAddress ethDstMask = MacAddress.read6Bytes(bb);
            int vlanVid = U16.f(bb.readShort());
            short vlanPcp = U8.f(bb.readByte());
            bb.skipBytes(1);
            int ethType = U16.f(bb.readShort());
            short ipDscp = U8.f(bb.readByte());
            short ipProto = U8.f(bb.readByte());
            IPv4Address ipv4Src = IPv4Address.read4Bytes(bb);
            IPv4Address ipv4SrcMask = IPv4Address.read4Bytes(bb);
            IPv4Address ipv4Dst = IPv4Address.read4Bytes(bb);
            IPv4Address ipv4DstMask = IPv4Address.read4Bytes(bb);
            int tcpSrc = U16.f(bb.readShort());
            int tcpDst = U16.f(bb.readShort());
            long mplsLabel = U32.f(bb.readInt());
            short mplsTc = U8.f(bb.readByte());
            bb.skipBytes(3);
            U64 metadata = U64.ofRaw(bb.readLong());
            U64 metadataMask = U64.ofRaw(bb.readLong());
            OFMatchV2Ver11 matchV2Ver11 = new OFMatchV2Ver11(inPort, wildcards, ethSrc, ethSrcMask, ethDst, ethDstMask, vlanVid, vlanPcp, ethType, ipDscp, ipProto, ipv4Src, ipv4SrcMask, ipv4Dst, ipv4DstMask, tcpSrc, tcpDst, mplsLabel, mplsTc, metadata, metadataMask);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)matchV2Ver11);
            }
            return matchV2Ver11;
        }
    }

    static class Builder
    implements OFMatchV2.Builder {
        private boolean inPortSet;
        private OFPort inPort;
        private boolean wildcardsSet;
        private int wildcards;
        private boolean ethSrcSet;
        private MacAddress ethSrc;
        private boolean ethSrcMaskSet;
        private MacAddress ethSrcMask;
        private boolean ethDstSet;
        private MacAddress ethDst;
        private boolean ethDstMaskSet;
        private MacAddress ethDstMask;
        private boolean vlanVidSet;
        private int vlanVid;
        private boolean vlanPcpSet;
        private short vlanPcp;
        private boolean ethTypeSet;
        private int ethType;
        private boolean ipDscpSet;
        private short ipDscp;
        private boolean ipProtoSet;
        private short ipProto;
        private boolean ipv4SrcSet;
        private IPv4Address ipv4Src;
        private boolean ipv4SrcMaskSet;
        private IPv4Address ipv4SrcMask;
        private boolean ipv4DstSet;
        private IPv4Address ipv4Dst;
        private boolean ipv4DstMaskSet;
        private IPv4Address ipv4DstMask;
        private boolean tcpSrcSet;
        private int tcpSrc;
        private boolean tcpDstSet;
        private int tcpDst;
        private boolean mplsLabelSet;
        private long mplsLabel;
        private boolean mplsTcSet;
        private short mplsTc;
        private boolean metadataSet;
        private U64 metadata;
        private boolean metadataMaskSet;
        private U64 metadataMask;

        Builder() {
        }

        @Override
        public int getType() {
            return 0;
        }

        @Override
        public OFPort getInPort() {
            return this.inPort;
        }

        @Override
        public OFMatchV2.Builder setInPort(OFPort inPort) {
            this.inPort = inPort;
            this.inPortSet = true;
            return this;
        }

        @Override
        public int getWildcards() {
            return this.wildcards;
        }

        @Override
        public OFMatchV2.Builder setWildcards(int wildcards) {
            this.wildcards = wildcards;
            this.wildcardsSet = true;
            return this;
        }

        @Override
        public MacAddress getEthSrc() {
            return this.ethSrc;
        }

        @Override
        public OFMatchV2.Builder setEthSrc(MacAddress ethSrc) {
            this.ethSrc = ethSrc;
            this.ethSrcSet = true;
            return this;
        }

        @Override
        public MacAddress getEthSrcMask() {
            return this.ethSrcMask;
        }

        @Override
        public OFMatchV2.Builder setEthSrcMask(MacAddress ethSrcMask) {
            this.ethSrcMask = ethSrcMask;
            this.ethSrcMaskSet = true;
            return this;
        }

        @Override
        public MacAddress getEthDst() {
            return this.ethDst;
        }

        @Override
        public OFMatchV2.Builder setEthDst(MacAddress ethDst) {
            this.ethDst = ethDst;
            this.ethDstSet = true;
            return this;
        }

        @Override
        public MacAddress getEthDstMask() {
            return this.ethDstMask;
        }

        @Override
        public OFMatchV2.Builder setEthDstMask(MacAddress ethDstMask) {
            this.ethDstMask = ethDstMask;
            this.ethDstMaskSet = true;
            return this;
        }

        @Override
        public int getVlanVid() {
            return this.vlanVid;
        }

        @Override
        public OFMatchV2.Builder setVlanVid(int vlanVid) {
            this.vlanVid = vlanVid;
            this.vlanVidSet = true;
            return this;
        }

        @Override
        public short getVlanPcp() {
            return this.vlanPcp;
        }

        @Override
        public OFMatchV2.Builder setVlanPcp(short vlanPcp) {
            this.vlanPcp = vlanPcp;
            this.vlanPcpSet = true;
            return this;
        }

        @Override
        public int getEthType() {
            return this.ethType;
        }

        @Override
        public OFMatchV2.Builder setEthType(int ethType) {
            this.ethType = ethType;
            this.ethTypeSet = true;
            return this;
        }

        @Override
        public short getIpDscp() {
            return this.ipDscp;
        }

        @Override
        public OFMatchV2.Builder setIpDscp(short ipDscp) {
            this.ipDscp = ipDscp;
            this.ipDscpSet = true;
            return this;
        }

        @Override
        public short getIpProto() {
            return this.ipProto;
        }

        @Override
        public OFMatchV2.Builder setIpProto(short ipProto) {
            this.ipProto = ipProto;
            this.ipProtoSet = true;
            return this;
        }

        @Override
        public IPv4Address getIpv4Src() {
            return this.ipv4Src;
        }

        @Override
        public OFMatchV2.Builder setIpv4Src(IPv4Address ipv4Src) {
            this.ipv4Src = ipv4Src;
            this.ipv4SrcSet = true;
            return this;
        }

        @Override
        public IPv4Address getIpv4SrcMask() {
            return this.ipv4SrcMask;
        }

        @Override
        public OFMatchV2.Builder setIpv4SrcMask(IPv4Address ipv4SrcMask) {
            this.ipv4SrcMask = ipv4SrcMask;
            this.ipv4SrcMaskSet = true;
            return this;
        }

        @Override
        public IPv4Address getIpv4Dst() {
            return this.ipv4Dst;
        }

        @Override
        public OFMatchV2.Builder setIpv4Dst(IPv4Address ipv4Dst) {
            this.ipv4Dst = ipv4Dst;
            this.ipv4DstSet = true;
            return this;
        }

        @Override
        public IPv4Address getIpv4DstMask() {
            return this.ipv4DstMask;
        }

        @Override
        public OFMatchV2.Builder setIpv4DstMask(IPv4Address ipv4DstMask) {
            this.ipv4DstMask = ipv4DstMask;
            this.ipv4DstMaskSet = true;
            return this;
        }

        @Override
        public int getTcpSrc() {
            return this.tcpSrc;
        }

        @Override
        public OFMatchV2.Builder setTcpSrc(int tcpSrc) {
            this.tcpSrc = tcpSrc;
            this.tcpSrcSet = true;
            return this;
        }

        @Override
        public int getTcpDst() {
            return this.tcpDst;
        }

        @Override
        public OFMatchV2.Builder setTcpDst(int tcpDst) {
            this.tcpDst = tcpDst;
            this.tcpDstSet = true;
            return this;
        }

        @Override
        public long getMplsLabel() {
            return this.mplsLabel;
        }

        @Override
        public OFMatchV2.Builder setMplsLabel(long mplsLabel) {
            this.mplsLabel = mplsLabel;
            this.mplsLabelSet = true;
            return this;
        }

        @Override
        public short getMplsTc() {
            return this.mplsTc;
        }

        @Override
        public OFMatchV2.Builder setMplsTc(short mplsTc) {
            this.mplsTc = mplsTc;
            this.mplsTcSet = true;
            return this;
        }

        @Override
        public U64 getMetadata() {
            return this.metadata;
        }

        @Override
        public OFMatchV2.Builder setMetadata(U64 metadata) {
            this.metadata = metadata;
            this.metadataSet = true;
            return this;
        }

        @Override
        public U64 getMetadataMask() {
            return this.metadataMask;
        }

        @Override
        public OFMatchV2.Builder setMetadataMask(U64 metadataMask) {
            this.metadataMask = metadataMask;
            this.metadataMaskSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_11;
        }

        @Override
        public OFMatchV2 build() {
            U64 metadataMask;
            U64 metadata;
            IPv4Address ipv4DstMask;
            IPv4Address ipv4Dst;
            IPv4Address ipv4SrcMask;
            IPv4Address ipv4Src;
            MacAddress ethDstMask;
            MacAddress ethDst;
            MacAddress ethSrcMask;
            MacAddress ethSrc;
            OFPort inPort;
            OFPort oFPort = inPort = this.inPortSet ? this.inPort : DEFAULT_IN_PORT;
            if (inPort == null) {
                throw new NullPointerException("Property inPort must not be null");
            }
            int wildcards = this.wildcardsSet ? this.wildcards : 1023;
            MacAddress macAddress = ethSrc = this.ethSrcSet ? this.ethSrc : DEFAULT_ETH_SRC;
            if (ethSrc == null) {
                throw new NullPointerException("Property ethSrc must not be null");
            }
            MacAddress macAddress2 = ethSrcMask = this.ethSrcMaskSet ? this.ethSrcMask : DEFAULT_ETH_SRC_MASK;
            if (ethSrcMask == null) {
                throw new NullPointerException("Property ethSrcMask must not be null");
            }
            MacAddress macAddress3 = ethDst = this.ethDstSet ? this.ethDst : DEFAULT_ETH_DST;
            if (ethDst == null) {
                throw new NullPointerException("Property ethDst must not be null");
            }
            MacAddress macAddress4 = ethDstMask = this.ethDstMaskSet ? this.ethDstMask : DEFAULT_ETH_DST_MASK;
            if (ethDstMask == null) {
                throw new NullPointerException("Property ethDstMask must not be null");
            }
            int vlanVid = this.vlanVidSet ? this.vlanVid : 0;
            short vlanPcp = this.vlanPcpSet ? this.vlanPcp : (short)0;
            int ethType = this.ethTypeSet ? this.ethType : 0;
            short ipDscp = this.ipDscpSet ? this.ipDscp : (short)0;
            short ipProto = this.ipProtoSet ? this.ipProto : (short)0;
            IPv4Address iPv4Address = ipv4Src = this.ipv4SrcSet ? this.ipv4Src : DEFAULT_IPV4_SRC;
            if (ipv4Src == null) {
                throw new NullPointerException("Property ipv4Src must not be null");
            }
            IPv4Address iPv4Address2 = ipv4SrcMask = this.ipv4SrcMaskSet ? this.ipv4SrcMask : DEFAULT_IPV4_SRC_MASK;
            if (ipv4SrcMask == null) {
                throw new NullPointerException("Property ipv4SrcMask must not be null");
            }
            IPv4Address iPv4Address3 = ipv4Dst = this.ipv4DstSet ? this.ipv4Dst : DEFAULT_IPV4_DST;
            if (ipv4Dst == null) {
                throw new NullPointerException("Property ipv4Dst must not be null");
            }
            IPv4Address iPv4Address4 = ipv4DstMask = this.ipv4DstMaskSet ? this.ipv4DstMask : DEFAULT_IPV4_DST_MASK;
            if (ipv4DstMask == null) {
                throw new NullPointerException("Property ipv4DstMask must not be null");
            }
            int tcpSrc = this.tcpSrcSet ? this.tcpSrc : 0;
            int tcpDst = this.tcpDstSet ? this.tcpDst : 0;
            long mplsLabel = this.mplsLabelSet ? this.mplsLabel : 0L;
            short mplsTc = this.mplsTcSet ? this.mplsTc : (short)0;
            U64 u64 = metadata = this.metadataSet ? this.metadata : DEFAULT_METADATA;
            if (metadata == null) {
                throw new NullPointerException("Property metadata must not be null");
            }
            U64 u642 = metadataMask = this.metadataMaskSet ? this.metadataMask : DEFAULT_METADATA_MASK;
            if (metadataMask == null) {
                throw new NullPointerException("Property metadataMask must not be null");
            }
            return new OFMatchV2Ver11(inPort, wildcards, ethSrc, ethSrcMask, ethDst, ethDstMask, vlanVid, vlanPcp, ethType, ipDscp, ipProto, ipv4Src, ipv4SrcMask, ipv4Dst, ipv4DstMask, tcpSrc, tcpDst, mplsLabel, mplsTc, metadata, metadataMask);
        }

        @Override
        public <F extends OFValueType<F>> F get(MatchField<F> field) throws UnsupportedOperationException {
            return null;
        }

        @Override
        public <F extends OFValueType<F>> Masked<F> getMasked(MatchField<F> field) throws UnsupportedOperationException {
            return null;
        }

        @Override
        public boolean supports(MatchField<?> field) {
            return false;
        }

        @Override
        public boolean supportsMasked(MatchField<?> field) {
            return false;
        }

        @Override
        public boolean isExact(MatchField<?> field) {
            return false;
        }

        @Override
        public boolean isFullyWildcarded(MatchField<?> field) {
            return false;
        }

        @Override
        public boolean isPartiallyMasked(MatchField<?> field) {
            return false;
        }

        @Override
        public <F extends OFValueType<F>> Match.Builder setExact(MatchField<F> field, F value) {
            return null;
        }

        @Override
        public <F extends OFValueType<F>> Match.Builder setMasked(MatchField<F> field, F value, F mask) {
            return null;
        }

        @Override
        public <F extends OFValueType<F>> Match.Builder setMasked(MatchField<F> field, Masked<F> valueWithMask) {
            return null;
        }

        @Override
        public <F extends OFValueType<F>> Match.Builder wildcard(MatchField<F> field) {
            return null;
        }
    }

    static class BuilderWithParent
    implements OFMatchV2.Builder {
        final OFMatchV2Ver11 parentMessage;
        private boolean inPortSet;
        private OFPort inPort;
        private boolean wildcardsSet;
        private int wildcards;
        private boolean ethSrcSet;
        private MacAddress ethSrc;
        private boolean ethSrcMaskSet;
        private MacAddress ethSrcMask;
        private boolean ethDstSet;
        private MacAddress ethDst;
        private boolean ethDstMaskSet;
        private MacAddress ethDstMask;
        private boolean vlanVidSet;
        private int vlanVid;
        private boolean vlanPcpSet;
        private short vlanPcp;
        private boolean ethTypeSet;
        private int ethType;
        private boolean ipDscpSet;
        private short ipDscp;
        private boolean ipProtoSet;
        private short ipProto;
        private boolean ipv4SrcSet;
        private IPv4Address ipv4Src;
        private boolean ipv4SrcMaskSet;
        private IPv4Address ipv4SrcMask;
        private boolean ipv4DstSet;
        private IPv4Address ipv4Dst;
        private boolean ipv4DstMaskSet;
        private IPv4Address ipv4DstMask;
        private boolean tcpSrcSet;
        private int tcpSrc;
        private boolean tcpDstSet;
        private int tcpDst;
        private boolean mplsLabelSet;
        private long mplsLabel;
        private boolean mplsTcSet;
        private short mplsTc;
        private boolean metadataSet;
        private U64 metadata;
        private boolean metadataMaskSet;
        private U64 metadataMask;

        BuilderWithParent(OFMatchV2Ver11 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 0;
        }

        @Override
        public OFPort getInPort() {
            return this.inPort;
        }

        @Override
        public OFMatchV2.Builder setInPort(OFPort inPort) {
            this.inPort = inPort;
            this.inPortSet = true;
            return this;
        }

        @Override
        public int getWildcards() {
            return this.wildcards;
        }

        @Override
        public OFMatchV2.Builder setWildcards(int wildcards) {
            this.wildcards = wildcards;
            this.wildcardsSet = true;
            return this;
        }

        @Override
        public MacAddress getEthSrc() {
            return this.ethSrc;
        }

        @Override
        public OFMatchV2.Builder setEthSrc(MacAddress ethSrc) {
            this.ethSrc = ethSrc;
            this.ethSrcSet = true;
            return this;
        }

        @Override
        public MacAddress getEthSrcMask() {
            return this.ethSrcMask;
        }

        @Override
        public OFMatchV2.Builder setEthSrcMask(MacAddress ethSrcMask) {
            this.ethSrcMask = ethSrcMask;
            this.ethSrcMaskSet = true;
            return this;
        }

        @Override
        public MacAddress getEthDst() {
            return this.ethDst;
        }

        @Override
        public OFMatchV2.Builder setEthDst(MacAddress ethDst) {
            this.ethDst = ethDst;
            this.ethDstSet = true;
            return this;
        }

        @Override
        public MacAddress getEthDstMask() {
            return this.ethDstMask;
        }

        @Override
        public OFMatchV2.Builder setEthDstMask(MacAddress ethDstMask) {
            this.ethDstMask = ethDstMask;
            this.ethDstMaskSet = true;
            return this;
        }

        @Override
        public int getVlanVid() {
            return this.vlanVid;
        }

        @Override
        public OFMatchV2.Builder setVlanVid(int vlanVid) {
            this.vlanVid = vlanVid;
            this.vlanVidSet = true;
            return this;
        }

        @Override
        public short getVlanPcp() {
            return this.vlanPcp;
        }

        @Override
        public OFMatchV2.Builder setVlanPcp(short vlanPcp) {
            this.vlanPcp = vlanPcp;
            this.vlanPcpSet = true;
            return this;
        }

        @Override
        public int getEthType() {
            return this.ethType;
        }

        @Override
        public OFMatchV2.Builder setEthType(int ethType) {
            this.ethType = ethType;
            this.ethTypeSet = true;
            return this;
        }

        @Override
        public short getIpDscp() {
            return this.ipDscp;
        }

        @Override
        public OFMatchV2.Builder setIpDscp(short ipDscp) {
            this.ipDscp = ipDscp;
            this.ipDscpSet = true;
            return this;
        }

        @Override
        public short getIpProto() {
            return this.ipProto;
        }

        @Override
        public OFMatchV2.Builder setIpProto(short ipProto) {
            this.ipProto = ipProto;
            this.ipProtoSet = true;
            return this;
        }

        @Override
        public IPv4Address getIpv4Src() {
            return this.ipv4Src;
        }

        @Override
        public OFMatchV2.Builder setIpv4Src(IPv4Address ipv4Src) {
            this.ipv4Src = ipv4Src;
            this.ipv4SrcSet = true;
            return this;
        }

        @Override
        public IPv4Address getIpv4SrcMask() {
            return this.ipv4SrcMask;
        }

        @Override
        public OFMatchV2.Builder setIpv4SrcMask(IPv4Address ipv4SrcMask) {
            this.ipv4SrcMask = ipv4SrcMask;
            this.ipv4SrcMaskSet = true;
            return this;
        }

        @Override
        public IPv4Address getIpv4Dst() {
            return this.ipv4Dst;
        }

        @Override
        public OFMatchV2.Builder setIpv4Dst(IPv4Address ipv4Dst) {
            this.ipv4Dst = ipv4Dst;
            this.ipv4DstSet = true;
            return this;
        }

        @Override
        public IPv4Address getIpv4DstMask() {
            return this.ipv4DstMask;
        }

        @Override
        public OFMatchV2.Builder setIpv4DstMask(IPv4Address ipv4DstMask) {
            this.ipv4DstMask = ipv4DstMask;
            this.ipv4DstMaskSet = true;
            return this;
        }

        @Override
        public int getTcpSrc() {
            return this.tcpSrc;
        }

        @Override
        public OFMatchV2.Builder setTcpSrc(int tcpSrc) {
            this.tcpSrc = tcpSrc;
            this.tcpSrcSet = true;
            return this;
        }

        @Override
        public int getTcpDst() {
            return this.tcpDst;
        }

        @Override
        public OFMatchV2.Builder setTcpDst(int tcpDst) {
            this.tcpDst = tcpDst;
            this.tcpDstSet = true;
            return this;
        }

        @Override
        public long getMplsLabel() {
            return this.mplsLabel;
        }

        @Override
        public OFMatchV2.Builder setMplsLabel(long mplsLabel) {
            this.mplsLabel = mplsLabel;
            this.mplsLabelSet = true;
            return this;
        }

        @Override
        public short getMplsTc() {
            return this.mplsTc;
        }

        @Override
        public OFMatchV2.Builder setMplsTc(short mplsTc) {
            this.mplsTc = mplsTc;
            this.mplsTcSet = true;
            return this;
        }

        @Override
        public U64 getMetadata() {
            return this.metadata;
        }

        @Override
        public OFMatchV2.Builder setMetadata(U64 metadata) {
            this.metadata = metadata;
            this.metadataSet = true;
            return this;
        }

        @Override
        public U64 getMetadataMask() {
            return this.metadataMask;
        }

        @Override
        public OFMatchV2.Builder setMetadataMask(U64 metadataMask) {
            this.metadataMask = metadataMask;
            this.metadataMaskSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_11;
        }

        @Override
        public OFMatchV2 build() {
            U64 metadataMask;
            U64 metadata;
            IPv4Address ipv4DstMask;
            IPv4Address ipv4Dst;
            IPv4Address ipv4SrcMask;
            IPv4Address ipv4Src;
            MacAddress ethDstMask;
            MacAddress ethDst;
            MacAddress ethSrcMask;
            MacAddress ethSrc;
            OFPort inPort;
            OFPort oFPort = inPort = this.inPortSet ? this.inPort : this.parentMessage.inPort;
            if (inPort == null) {
                throw new NullPointerException("Property inPort must not be null");
            }
            int wildcards = this.wildcardsSet ? this.wildcards : this.parentMessage.wildcards;
            MacAddress macAddress = ethSrc = this.ethSrcSet ? this.ethSrc : this.parentMessage.ethSrc;
            if (ethSrc == null) {
                throw new NullPointerException("Property ethSrc must not be null");
            }
            MacAddress macAddress2 = ethSrcMask = this.ethSrcMaskSet ? this.ethSrcMask : this.parentMessage.ethSrcMask;
            if (ethSrcMask == null) {
                throw new NullPointerException("Property ethSrcMask must not be null");
            }
            MacAddress macAddress3 = ethDst = this.ethDstSet ? this.ethDst : this.parentMessage.ethDst;
            if (ethDst == null) {
                throw new NullPointerException("Property ethDst must not be null");
            }
            MacAddress macAddress4 = ethDstMask = this.ethDstMaskSet ? this.ethDstMask : this.parentMessage.ethDstMask;
            if (ethDstMask == null) {
                throw new NullPointerException("Property ethDstMask must not be null");
            }
            int vlanVid = this.vlanVidSet ? this.vlanVid : this.parentMessage.vlanVid;
            short vlanPcp = this.vlanPcpSet ? this.vlanPcp : this.parentMessage.vlanPcp;
            int ethType = this.ethTypeSet ? this.ethType : this.parentMessage.ethType;
            short ipDscp = this.ipDscpSet ? this.ipDscp : this.parentMessage.ipDscp;
            short ipProto = this.ipProtoSet ? this.ipProto : this.parentMessage.ipProto;
            IPv4Address iPv4Address = ipv4Src = this.ipv4SrcSet ? this.ipv4Src : this.parentMessage.ipv4Src;
            if (ipv4Src == null) {
                throw new NullPointerException("Property ipv4Src must not be null");
            }
            IPv4Address iPv4Address2 = ipv4SrcMask = this.ipv4SrcMaskSet ? this.ipv4SrcMask : this.parentMessage.ipv4SrcMask;
            if (ipv4SrcMask == null) {
                throw new NullPointerException("Property ipv4SrcMask must not be null");
            }
            IPv4Address iPv4Address3 = ipv4Dst = this.ipv4DstSet ? this.ipv4Dst : this.parentMessage.ipv4Dst;
            if (ipv4Dst == null) {
                throw new NullPointerException("Property ipv4Dst must not be null");
            }
            IPv4Address iPv4Address4 = ipv4DstMask = this.ipv4DstMaskSet ? this.ipv4DstMask : this.parentMessage.ipv4DstMask;
            if (ipv4DstMask == null) {
                throw new NullPointerException("Property ipv4DstMask must not be null");
            }
            int tcpSrc = this.tcpSrcSet ? this.tcpSrc : this.parentMessage.tcpSrc;
            int tcpDst = this.tcpDstSet ? this.tcpDst : this.parentMessage.tcpDst;
            long mplsLabel = this.mplsLabelSet ? this.mplsLabel : this.parentMessage.mplsLabel;
            short mplsTc = this.mplsTcSet ? this.mplsTc : this.parentMessage.mplsTc;
            U64 u64 = metadata = this.metadataSet ? this.metadata : this.parentMessage.metadata;
            if (metadata == null) {
                throw new NullPointerException("Property metadata must not be null");
            }
            U64 u642 = metadataMask = this.metadataMaskSet ? this.metadataMask : this.parentMessage.metadataMask;
            if (metadataMask == null) {
                throw new NullPointerException("Property metadataMask must not be null");
            }
            return new OFMatchV2Ver11(inPort, wildcards, ethSrc, ethSrcMask, ethDst, ethDstMask, vlanVid, vlanPcp, ethType, ipDscp, ipProto, ipv4Src, ipv4SrcMask, ipv4Dst, ipv4DstMask, tcpSrc, tcpDst, mplsLabel, mplsTc, metadata, metadataMask);
        }

        @Override
        public <F extends OFValueType<F>> F get(MatchField<F> field) throws UnsupportedOperationException {
            return null;
        }

        @Override
        public <F extends OFValueType<F>> Masked<F> getMasked(MatchField<F> field) throws UnsupportedOperationException {
            return null;
        }

        @Override
        public boolean supports(MatchField<?> field) {
            return false;
        }

        @Override
        public boolean supportsMasked(MatchField<?> field) {
            return false;
        }

        @Override
        public boolean isExact(MatchField<?> field) {
            return false;
        }

        @Override
        public boolean isFullyWildcarded(MatchField<?> field) {
            return false;
        }

        @Override
        public boolean isPartiallyMasked(MatchField<?> field) {
            return false;
        }

        @Override
        public <F extends OFValueType<F>> Match.Builder setExact(MatchField<F> field, F value) {
            return null;
        }

        @Override
        public <F extends OFValueType<F>> Match.Builder setMasked(MatchField<F> field, F value, F mask) {
            return null;
        }

        @Override
        public <F extends OFValueType<F>> Match.Builder setMasked(MatchField<F> field, Masked<F> valueWithMask) {
            return null;
        }

        @Override
        public <F extends OFValueType<F>> Match.Builder wildcard(MatchField<F> field) {
            return null;
        }
    }
}

