/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver11;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFFeaturesRequest;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFType;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFFeaturesRequestVer11
implements OFFeaturesRequest {
    private static final Logger logger = LoggerFactory.getLogger(OFFeaturesRequestVer11.class);
    static final byte WIRE_VERSION = 2;
    static final int LENGTH = 8;
    private static final long DEFAULT_XID = 0L;
    private final long xid;
    static final OFFeaturesRequestVer11 DEFAULT = new OFFeaturesRequestVer11(0L);
    static final Reader READER = new Reader();
    static final OFFeaturesRequestVer11Funnel FUNNEL = new OFFeaturesRequestVer11Funnel();
    static final Writer WRITER = new Writer();

    OFFeaturesRequestVer11(long xid) {
        this.xid = U32.normalize(xid);
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_11;
    }

    @Override
    public OFType getType() {
        return OFType.FEATURES_REQUEST;
    }

    @Override
    public long getXid() {
        return this.xid;
    }

    @Override
    public OFFeaturesRequest.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFFeaturesRequestVer11(");
        b.append("xid=").append(this.xid);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFFeaturesRequestVer11 other = (OFFeaturesRequestVer11)obj;
        return this.xid == other.xid;
    }

    @Override
    public boolean equalsIgnoreXid(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFFeaturesRequestVer11 other = (OFFeaturesRequestVer11)obj;
        return true;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.xid ^ this.xid >>> 32);
        return result;
    }

    @Override
    public int hashCodeIgnoreXid() {
        int prime = 31;
        int result = 1;
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFFeaturesRequestVer11> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFFeaturesRequestVer11 message) {
            bb.writeByte(2);
            bb.writeByte(5);
            bb.writeShort(8);
            bb.writeInt(U32.t(message.xid));
        }
    }

    static class OFFeaturesRequestVer11Funnel
    implements Funnel<OFFeaturesRequestVer11> {
        private static final long serialVersionUID = 1L;

        OFFeaturesRequestVer11Funnel() {
        }

        public void funnel(OFFeaturesRequestVer11 message, PrimitiveSink sink) {
            sink.putByte((byte)2);
            sink.putByte((byte)5);
            sink.putShort((short)8);
            sink.putLong(message.xid);
        }
    }

    static class Reader
    implements OFMessageReader<OFFeaturesRequest> {
        Reader() {
        }

        @Override
        public OFFeaturesRequest readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 2) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_11(2), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 5) {
                throw new OFParseError("Wrong type: Expected=OFType.FEATURES_REQUEST(5), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 8) {
                throw new OFParseError("Wrong length: Expected=8(8), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long xid = U32.f(bb.readInt());
            OFFeaturesRequestVer11 featuresRequestVer11 = new OFFeaturesRequestVer11(xid);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)featuresRequestVer11);
            }
            return featuresRequestVer11;
        }
    }

    static class Builder
    implements OFFeaturesRequest.Builder {
        private boolean xidSet;
        private long xid;

        Builder() {
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_11;
        }

        @Override
        public OFType getType() {
            return OFType.FEATURES_REQUEST;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFFeaturesRequest.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public OFFeaturesRequest build() {
            long xid = this.xidSet ? this.xid : 0L;
            return new OFFeaturesRequestVer11(xid);
        }
    }

    static class BuilderWithParent
    implements OFFeaturesRequest.Builder {
        final OFFeaturesRequestVer11 parentMessage;
        private boolean xidSet;
        private long xid;

        BuilderWithParent(OFFeaturesRequestVer11 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_11;
        }

        @Override
        public OFType getType() {
            return OFType.FEATURES_REQUEST;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFFeaturesRequest.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public OFFeaturesRequest build() {
            long xid = this.xidSet ? this.xid : this.parentMessage.xid;
            return new OFFeaturesRequestVer11(xid);
        }
    }
}

