/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver11;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBsnBwEnableSetReply;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFType;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnBwEnableSetReplyVer11
implements OFBsnBwEnableSetReply {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnBwEnableSetReplyVer11.class);
    static final byte WIRE_VERSION = 2;
    static final int LENGTH = 24;
    private static final long DEFAULT_XID = 0L;
    private static final long DEFAULT_ENABLE = 0L;
    private static final long DEFAULT_STATUS = 0L;
    private final long xid;
    private final long enable;
    private final long status;
    static final OFBsnBwEnableSetReplyVer11 DEFAULT = new OFBsnBwEnableSetReplyVer11(0L, 0L, 0L);
    static final Reader READER = new Reader();
    static final OFBsnBwEnableSetReplyVer11Funnel FUNNEL = new OFBsnBwEnableSetReplyVer11Funnel();
    static final Writer WRITER = new Writer();

    OFBsnBwEnableSetReplyVer11(long xid, long enable, long status) {
        this.xid = U32.normalize(xid);
        this.enable = U32.normalize(enable);
        this.status = U32.normalize(status);
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_11;
    }

    @Override
    public OFType getType() {
        return OFType.EXPERIMENTER;
    }

    @Override
    public long getXid() {
        return this.xid;
    }

    @Override
    public long getExperimenter() {
        return 6035143L;
    }

    @Override
    public long getSubtype() {
        return 23L;
    }

    @Override
    public long getEnable() {
        return this.enable;
    }

    @Override
    public long getStatus() {
        return this.status;
    }

    @Override
    public OFBsnBwEnableSetReply.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnBwEnableSetReplyVer11(");
        b.append("xid=").append(this.xid);
        b.append(", ");
        b.append("enable=").append(this.enable);
        b.append(", ");
        b.append("status=").append(this.status);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnBwEnableSetReplyVer11 other = (OFBsnBwEnableSetReplyVer11)obj;
        if (this.xid != other.xid) {
            return false;
        }
        if (this.enable != other.enable) {
            return false;
        }
        return this.status == other.status;
    }

    @Override
    public boolean equalsIgnoreXid(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnBwEnableSetReplyVer11 other = (OFBsnBwEnableSetReplyVer11)obj;
        if (this.enable != other.enable) {
            return false;
        }
        return this.status == other.status;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.xid ^ this.xid >>> 32);
        result = 31 * (int)(this.enable ^ this.enable >>> 32);
        result = 31 * (int)(this.status ^ this.status >>> 32);
        return result;
    }

    @Override
    public int hashCodeIgnoreXid() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.enable ^ this.enable >>> 32);
        result = 31 * (int)(this.status ^ this.status >>> 32);
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnBwEnableSetReplyVer11> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnBwEnableSetReplyVer11 message) {
            bb.writeByte(2);
            bb.writeByte(4);
            bb.writeShort(24);
            bb.writeInt(U32.t(message.xid));
            bb.writeInt(6035143);
            bb.writeInt(23);
            bb.writeInt(U32.t(message.enable));
            bb.writeInt(U32.t(message.status));
        }
    }

    static class OFBsnBwEnableSetReplyVer11Funnel
    implements Funnel<OFBsnBwEnableSetReplyVer11> {
        private static final long serialVersionUID = 1L;

        OFBsnBwEnableSetReplyVer11Funnel() {
        }

        public void funnel(OFBsnBwEnableSetReplyVer11 message, PrimitiveSink sink) {
            sink.putByte((byte)2);
            sink.putByte((byte)4);
            sink.putShort((short)24);
            sink.putLong(message.xid);
            sink.putInt(6035143);
            sink.putInt(23);
            sink.putLong(message.enable);
            sink.putLong(message.status);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnBwEnableSetReply> {
        Reader() {
        }

        @Override
        public OFBsnBwEnableSetReply readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 2) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_11(2), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 4) {
                throw new OFParseError("Wrong type: Expected=OFType.EXPERIMENTER(4), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 24) {
                throw new OFParseError("Wrong length: Expected=24(24), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long xid = U32.f(bb.readInt());
            int experimenter = bb.readInt();
            if (experimenter != 6035143) {
                throw new OFParseError("Wrong experimenter: Expected=0x5c16c7L(0x5c16c7L), got=" + experimenter);
            }
            int subtype = bb.readInt();
            if (subtype != 23) {
                throw new OFParseError("Wrong subtype: Expected=0x17L(0x17L), got=" + subtype);
            }
            long enable = U32.f(bb.readInt());
            long status = U32.f(bb.readInt());
            OFBsnBwEnableSetReplyVer11 bsnBwEnableSetReplyVer11 = new OFBsnBwEnableSetReplyVer11(xid, enable, status);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnBwEnableSetReplyVer11);
            }
            return bsnBwEnableSetReplyVer11;
        }
    }

    static class Builder
    implements OFBsnBwEnableSetReply.Builder {
        private boolean xidSet;
        private long xid;
        private boolean enableSet;
        private long enable;
        private boolean statusSet;
        private long status;

        Builder() {
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_11;
        }

        @Override
        public OFType getType() {
            return OFType.EXPERIMENTER;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFBsnBwEnableSetReply.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public long getExperimenter() {
            return 6035143L;
        }

        @Override
        public long getSubtype() {
            return 23L;
        }

        @Override
        public long getEnable() {
            return this.enable;
        }

        @Override
        public OFBsnBwEnableSetReply.Builder setEnable(long enable) {
            this.enable = enable;
            this.enableSet = true;
            return this;
        }

        @Override
        public long getStatus() {
            return this.status;
        }

        @Override
        public OFBsnBwEnableSetReply.Builder setStatus(long status) {
            this.status = status;
            this.statusSet = true;
            return this;
        }

        @Override
        public OFBsnBwEnableSetReply build() {
            long xid = this.xidSet ? this.xid : 0L;
            long enable = this.enableSet ? this.enable : 0L;
            long status = this.statusSet ? this.status : 0L;
            return new OFBsnBwEnableSetReplyVer11(xid, enable, status);
        }
    }

    static class BuilderWithParent
    implements OFBsnBwEnableSetReply.Builder {
        final OFBsnBwEnableSetReplyVer11 parentMessage;
        private boolean xidSet;
        private long xid;
        private boolean enableSet;
        private long enable;
        private boolean statusSet;
        private long status;

        BuilderWithParent(OFBsnBwEnableSetReplyVer11 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_11;
        }

        @Override
        public OFType getType() {
            return OFType.EXPERIMENTER;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFBsnBwEnableSetReply.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public long getExperimenter() {
            return 6035143L;
        }

        @Override
        public long getSubtype() {
            return 23L;
        }

        @Override
        public long getEnable() {
            return this.enable;
        }

        @Override
        public OFBsnBwEnableSetReply.Builder setEnable(long enable) {
            this.enable = enable;
            this.enableSet = true;
            return this;
        }

        @Override
        public long getStatus() {
            return this.status;
        }

        @Override
        public OFBsnBwEnableSetReply.Builder setStatus(long status) {
            this.status = status;
            this.statusSet = true;
            return this;
        }

        @Override
        public OFBsnBwEnableSetReply build() {
            long xid = this.xidSet ? this.xid : this.parentMessage.xid;
            long enable = this.enableSet ? this.enable : this.parentMessage.enable;
            long status = this.statusSet ? this.status : this.parentMessage.status;
            return new OFBsnBwEnableSetReplyVer11(xid, enable, status);
        }
    }
}

