/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver11;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFActionType;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.action.OFActionSetNwTos;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U8;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFActionSetNwTosVer11
implements OFActionSetNwTos {
    private static final Logger logger = LoggerFactory.getLogger(OFActionSetNwTosVer11.class);
    static final byte WIRE_VERSION = 2;
    static final int LENGTH = 8;
    private static final short DEFAULT_NW_TOS = 0;
    private final short nwTos;
    static final OFActionSetNwTosVer11 DEFAULT = new OFActionSetNwTosVer11(0);
    static final Reader READER = new Reader();
    static final OFActionSetNwTosVer11Funnel FUNNEL = new OFActionSetNwTosVer11Funnel();
    static final Writer WRITER = new Writer();

    OFActionSetNwTosVer11(short nwTos) {
        this.nwTos = U8.normalize(nwTos);
    }

    @Override
    public OFActionType getType() {
        return OFActionType.SET_NW_TOS;
    }

    @Override
    public short getNwTos() {
        return this.nwTos;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_11;
    }

    @Override
    public OFActionSetNwTos.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFActionSetNwTosVer11(");
        b.append("nwTos=").append(this.nwTos);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFActionSetNwTosVer11 other = (OFActionSetNwTosVer11)obj;
        return this.nwTos == other.nwTos;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.nwTos;
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFActionSetNwTosVer11> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFActionSetNwTosVer11 message) {
            bb.writeShort(7);
            bb.writeShort(8);
            bb.writeByte((int)U8.t(message.nwTos));
            bb.writeZero(3);
        }
    }

    static class OFActionSetNwTosVer11Funnel
    implements Funnel<OFActionSetNwTosVer11> {
        private static final long serialVersionUID = 1L;

        OFActionSetNwTosVer11Funnel() {
        }

        public void funnel(OFActionSetNwTosVer11 message, PrimitiveSink sink) {
            sink.putShort((short)7);
            sink.putShort((short)8);
            sink.putShort(message.nwTos);
        }
    }

    static class Reader
    implements OFMessageReader<OFActionSetNwTos> {
        Reader() {
        }

        @Override
        public OFActionSetNwTos readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 7) {
                throw new OFParseError("Wrong type: Expected=OFActionType.SET_NW_TOS(7), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 8) {
                throw new OFParseError("Wrong length: Expected=8(8), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            short nwTos = U8.f(bb.readByte());
            bb.skipBytes(3);
            OFActionSetNwTosVer11 actionSetNwTosVer11 = new OFActionSetNwTosVer11(nwTos);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)actionSetNwTosVer11);
            }
            return actionSetNwTosVer11;
        }
    }

    static class Builder
    implements OFActionSetNwTos.Builder {
        private boolean nwTosSet;
        private short nwTos;

        Builder() {
        }

        @Override
        public OFActionType getType() {
            return OFActionType.SET_NW_TOS;
        }

        @Override
        public short getNwTos() {
            return this.nwTos;
        }

        @Override
        public OFActionSetNwTos.Builder setNwTos(short nwTos) {
            this.nwTos = nwTos;
            this.nwTosSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_11;
        }

        @Override
        public OFActionSetNwTos build() {
            short nwTos = this.nwTosSet ? this.nwTos : (short)0;
            return new OFActionSetNwTosVer11(nwTos);
        }
    }

    static class BuilderWithParent
    implements OFActionSetNwTos.Builder {
        final OFActionSetNwTosVer11 parentMessage;
        private boolean nwTosSet;
        private short nwTos;

        BuilderWithParent(OFActionSetNwTosVer11 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFActionType getType() {
            return OFActionType.SET_NW_TOS;
        }

        @Override
        public short getNwTos() {
            return this.nwTos;
        }

        @Override
        public OFActionSetNwTos.Builder setNwTos(short nwTos) {
            this.nwTos = nwTos;
            this.nwTosSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_11;
        }

        @Override
        public OFActionSetNwTos build() {
            short nwTos = this.nwTosSet ? this.nwTos : this.parentMessage.nwTos;
            return new OFActionSetNwTosVer11(nwTos);
        }
    }
}

