/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver11;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFActionType;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.action.OFActionSetNwEcn;
import org.projectfloodlight.openflow.types.IpEcn;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFActionSetNwEcnVer11
implements OFActionSetNwEcn {
    private static final Logger logger = LoggerFactory.getLogger(OFActionSetNwEcnVer11.class);
    static final byte WIRE_VERSION = 2;
    static final int LENGTH = 8;
    private static final IpEcn DEFAULT_NW_ECN = IpEcn.NONE;
    private final IpEcn nwEcn;
    static final OFActionSetNwEcnVer11 DEFAULT = new OFActionSetNwEcnVer11(DEFAULT_NW_ECN);
    static final Reader READER = new Reader();
    static final OFActionSetNwEcnVer11Funnel FUNNEL = new OFActionSetNwEcnVer11Funnel();
    static final Writer WRITER = new Writer();

    OFActionSetNwEcnVer11(IpEcn nwEcn) {
        if (nwEcn == null) {
            throw new NullPointerException("OFActionSetNwEcnVer11: property nwEcn cannot be null");
        }
        this.nwEcn = nwEcn;
    }

    @Override
    public OFActionType getType() {
        return OFActionType.SET_NW_ECN;
    }

    @Override
    public IpEcn getNwEcn() {
        return this.nwEcn;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_11;
    }

    @Override
    public OFActionSetNwEcn.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFActionSetNwEcnVer11(");
        b.append("nwEcn=").append(this.nwEcn);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFActionSetNwEcnVer11 other = (OFActionSetNwEcnVer11)obj;
        return !(this.nwEcn == null ? other.nwEcn != null : !this.nwEcn.equals(other.nwEcn));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.nwEcn == null ? 0 : this.nwEcn.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFActionSetNwEcnVer11> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFActionSetNwEcnVer11 message) {
            bb.writeShort(8);
            bb.writeShort(8);
            message.nwEcn.writeByte(bb);
            bb.writeZero(3);
        }
    }

    static class OFActionSetNwEcnVer11Funnel
    implements Funnel<OFActionSetNwEcnVer11> {
        private static final long serialVersionUID = 1L;

        OFActionSetNwEcnVer11Funnel() {
        }

        public void funnel(OFActionSetNwEcnVer11 message, PrimitiveSink sink) {
            sink.putShort((short)8);
            sink.putShort((short)8);
            message.nwEcn.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFActionSetNwEcn> {
        Reader() {
        }

        @Override
        public OFActionSetNwEcn readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 8) {
                throw new OFParseError("Wrong type: Expected=OFActionType.SET_NW_ECN(8), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 8) {
                throw new OFParseError("Wrong length: Expected=8(8), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            IpEcn nwEcn = IpEcn.readByte(bb);
            bb.skipBytes(3);
            OFActionSetNwEcnVer11 actionSetNwEcnVer11 = new OFActionSetNwEcnVer11(nwEcn);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)actionSetNwEcnVer11);
            }
            return actionSetNwEcnVer11;
        }
    }

    static class Builder
    implements OFActionSetNwEcn.Builder {
        private boolean nwEcnSet;
        private IpEcn nwEcn;

        Builder() {
        }

        @Override
        public OFActionType getType() {
            return OFActionType.SET_NW_ECN;
        }

        @Override
        public IpEcn getNwEcn() {
            return this.nwEcn;
        }

        @Override
        public OFActionSetNwEcn.Builder setNwEcn(IpEcn nwEcn) {
            this.nwEcn = nwEcn;
            this.nwEcnSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_11;
        }

        @Override
        public OFActionSetNwEcn build() {
            IpEcn nwEcn;
            IpEcn ipEcn = nwEcn = this.nwEcnSet ? this.nwEcn : DEFAULT_NW_ECN;
            if (nwEcn == null) {
                throw new NullPointerException("Property nwEcn must not be null");
            }
            return new OFActionSetNwEcnVer11(nwEcn);
        }
    }

    static class BuilderWithParent
    implements OFActionSetNwEcn.Builder {
        final OFActionSetNwEcnVer11 parentMessage;
        private boolean nwEcnSet;
        private IpEcn nwEcn;

        BuilderWithParent(OFActionSetNwEcnVer11 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFActionType getType() {
            return OFActionType.SET_NW_ECN;
        }

        @Override
        public IpEcn getNwEcn() {
            return this.nwEcn;
        }

        @Override
        public OFActionSetNwEcn.Builder setNwEcn(IpEcn nwEcn) {
            this.nwEcn = nwEcn;
            this.nwEcnSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_11;
        }

        @Override
        public OFActionSetNwEcn build() {
            IpEcn nwEcn;
            IpEcn ipEcn = nwEcn = this.nwEcnSet ? this.nwEcn : this.parentMessage.nwEcn;
            if (nwEcn == null) {
                throw new NullPointerException("Property nwEcn must not be null");
            }
            return new OFActionSetNwEcnVer11(nwEcn);
        }
    }
}

