/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver11;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFActionType;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.action.OFActionDecNwTtl;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFActionDecNwTtlVer11
implements OFActionDecNwTtl {
    private static final Logger logger = LoggerFactory.getLogger(OFActionDecNwTtlVer11.class);
    static final byte WIRE_VERSION = 2;
    static final int LENGTH = 8;
    static final OFActionDecNwTtlVer11 DEFAULT = new OFActionDecNwTtlVer11();
    static final OFActionDecNwTtlVer11 INSTANCE = new OFActionDecNwTtlVer11();
    static final Reader READER = new Reader();
    static final OFActionDecNwTtlVer11Funnel FUNNEL = new OFActionDecNwTtlVer11Funnel();
    static final Writer WRITER = new Writer();

    private OFActionDecNwTtlVer11() {
    }

    @Override
    public OFActionType getType() {
        return OFActionType.DEC_NW_TTL;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_11;
    }

    @Override
    public OFActionDecNwTtl.Builder createBuilder() {
        throw new UnsupportedOperationException("OFActionDecNwTtlVer11 has no mutable properties -- builder unneeded");
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFActionDecNwTtlVer11(");
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        return this.getClass() == obj.getClass();
    }

    public int hashCode() {
        int result = 1;
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFActionDecNwTtlVer11> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFActionDecNwTtlVer11 message) {
            bb.writeShort(24);
            bb.writeShort(8);
            bb.writeZero(4);
        }
    }

    static class OFActionDecNwTtlVer11Funnel
    implements Funnel<OFActionDecNwTtlVer11> {
        private static final long serialVersionUID = 1L;

        OFActionDecNwTtlVer11Funnel() {
        }

        public void funnel(OFActionDecNwTtlVer11 message, PrimitiveSink sink) {
            sink.putShort((short)24);
            sink.putShort((short)8);
        }
    }

    static class Reader
    implements OFMessageReader<OFActionDecNwTtl> {
        Reader() {
        }

        @Override
        public OFActionDecNwTtl readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 24) {
                throw new OFParseError("Wrong type: Expected=OFActionType.DEC_NW_TTL(24), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 8) {
                throw new OFParseError("Wrong length: Expected=8(8), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            bb.skipBytes(4);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - returning shared instance={}", (Object)INSTANCE);
            }
            return INSTANCE;
        }
    }
}

