/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver10;

import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFNiciraHeader;
import org.projectfloodlight.openflow.protocol.ver10.OFNiciraControllerRoleReplyVer10;
import org.projectfloodlight.openflow.protocol.ver10.OFNiciraControllerRoleRequestVer10;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;

abstract class OFNiciraHeaderVer10 {
    static final byte WIRE_VERSION = 1;
    static final int MINIMUM_LENGTH = 16;
    public static final Reader READER = new Reader();

    OFNiciraHeaderVer10() {
    }

    static class Reader
    implements OFMessageReader<OFNiciraHeader> {
        Reader() {
        }

        @Override
        public OFNiciraHeader readFrom(ByteBuf bb) throws OFParseError {
            if (bb.readableBytes() < 16) {
                return null;
            }
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 1) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_10(1), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 4) {
                throw new OFParseError("Wrong type: Expected=OFType.EXPERIMENTER(4), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length < 16) {
                throw new OFParseError("Wrong length: Expected to be >= 16, was: " + length);
            }
            U32.f(bb.readInt());
            int experimenter = bb.readInt();
            if (experimenter != 8992) {
                throw new OFParseError("Wrong experimenter: Expected=0x2320L(0x2320L), got=" + experimenter);
            }
            int subtype = bb.readInt();
            bb.readerIndex(start);
            switch (subtype) {
                case 11: {
                    return OFNiciraControllerRoleReplyVer10.READER.readFrom(bb);
                }
                case 10: {
                    return OFNiciraControllerRoleRequestVer10.READER.readFrom(bb);
                }
            }
            throw new OFParseError("Unknown value for discriminator subtype of class OFNiciraHeaderVer10: " + subtype);
        }
    }
}

