/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver10;

import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFExperimenterStatsReply;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.ver10.OFBsnStatsReplyVer10;
import org.projectfloodlight.openflow.protocol.ver10.OFStatsReplyFlagsSerializerVer10;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;

abstract class OFExperimenterStatsReplyVer10 {
    static final byte WIRE_VERSION = 1;
    static final int MINIMUM_LENGTH = 16;
    public static final Reader READER = new Reader();

    OFExperimenterStatsReplyVer10() {
    }

    static class Reader
    implements OFMessageReader<OFExperimenterStatsReply> {
        Reader() {
        }

        @Override
        public OFExperimenterStatsReply readFrom(ByteBuf bb) throws OFParseError {
            if (bb.readableBytes() < 16) {
                return null;
            }
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 1) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_10(1), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 17) {
                throw new OFParseError("Wrong type: Expected=OFType.STATS_REPLY(17), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length < 16) {
                throw new OFParseError("Wrong length: Expected to be >= 16, was: " + length);
            }
            U32.f(bb.readInt());
            short statsType = bb.readShort();
            if (statsType != -1) {
                throw new OFParseError("Wrong statsType: Expected=OFStatsType.EXPERIMENTER(65535), got=" + statsType);
            }
            OFStatsReplyFlagsSerializerVer10.readFrom(bb);
            int experimenter = bb.readInt();
            bb.readerIndex(start);
            switch (experimenter) {
                case 6035143: {
                    return OFBsnStatsReplyVer10.READER.readFrom(bb);
                }
            }
            throw new OFParseError("Unknown value for discriminator experimenter of class OFExperimenterStatsReplyVer10: " + experimenter);
        }
    }
}

