// Copyright (c) 2008 The Board of Trustees of The Leland Stanford Junior University
// Copyright (c) 2011, 2012 Open Networking Foundation
// Copyright (c) 2012, 2013 Big Switch Networks, Inc.
// This library was generated by the LoxiGen Compiler.
// See the file LICENSE.txt which should have been included in the source distribution

// Automatically generated by LOXI from template of_class.java
// Do not modify

package org.projectfloodlight.openflow.protocol.ver15;

import org.projectfloodlight.openflow.protocol.*;
import org.projectfloodlight.openflow.protocol.action.*;
import org.projectfloodlight.openflow.protocol.actionid.*;
import org.projectfloodlight.openflow.protocol.bsntlv.*;
import org.projectfloodlight.openflow.protocol.errormsg.*;
import org.projectfloodlight.openflow.protocol.meterband.*;
import org.projectfloodlight.openflow.protocol.instruction.*;
import org.projectfloodlight.openflow.protocol.instructionid.*;
import org.projectfloodlight.openflow.protocol.match.*;
import org.projectfloodlight.openflow.protocol.stat.*;
import org.projectfloodlight.openflow.protocol.oxm.*;
import org.projectfloodlight.openflow.protocol.oxs.*;
import org.projectfloodlight.openflow.protocol.queueprop.*;
import org.projectfloodlight.openflow.types.*;
import org.projectfloodlight.openflow.util.*;
import org.projectfloodlight.openflow.exceptions.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import java.util.List;
import com.google.common.collect.ImmutableList;
import java.util.Set;
import io.netty.buffer.ByteBuf;
import com.google.common.hash.PrimitiveSink;
import com.google.common.hash.Funnel;

class OFBundlePropTimeVer15 implements OFBundlePropTime {
    private static final Logger logger = LoggerFactory.getLogger(OFBundlePropTimeVer15.class);
    // version: 1.5
    final static byte WIRE_VERSION = 6;
    final static int MINIMUM_LENGTH = 8;
    // maximum OF message length: 16 bit, unsigned
    final static int MAXIMUM_LENGTH = 0xFFFF;

        private final static List<OFTime> DEFAULT_SCHEDULED_TIME = ImmutableList.<OFTime>of();

    // OF message fields
    private final List<OFTime> scheduledTime;
//
    // Immutable default instance
    final static OFBundlePropTimeVer15 DEFAULT = new OFBundlePropTimeVer15(
        DEFAULT_SCHEDULED_TIME
    );

    // package private constructor - used by readers, builders, and factory
    OFBundlePropTimeVer15(List<OFTime> scheduledTime) {
        if(scheduledTime == null) {
            throw new NullPointerException("OFBundlePropTimeVer15: property scheduledTime cannot be null");
        }
        this.scheduledTime = scheduledTime;
    }

    // Accessors for OF message fields
    @Override
    public int getType() {
        return 0x1;
    }

    @Override
    public List<OFTime> getScheduledTime() {
        return scheduledTime;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }



    public OFBundlePropTime.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    static class BuilderWithParent implements OFBundlePropTime.Builder {
        final OFBundlePropTimeVer15 parentMessage;

        // OF message fields
        private boolean scheduledTimeSet;
        private List<OFTime> scheduledTime;

        BuilderWithParent(OFBundlePropTimeVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

    @Override
    public int getType() {
        return 0x1;
    }

    @Override
    public List<OFTime> getScheduledTime() {
        return scheduledTime;
    }

    @Override
    public OFBundlePropTime.Builder setScheduledTime(List<OFTime> scheduledTime) {
        this.scheduledTime = scheduledTime;
        this.scheduledTimeSet = true;
        return this;
    }
    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }



        @Override
        public OFBundlePropTime build() {
                List<OFTime> scheduledTime = this.scheduledTimeSet ? this.scheduledTime : parentMessage.scheduledTime;
                if(scheduledTime == null)
                    throw new NullPointerException("Property scheduledTime must not be null");

                //
                return new OFBundlePropTimeVer15(
                    scheduledTime
                );
        }

    }

    static class Builder implements OFBundlePropTime.Builder {
        // OF message fields
        private boolean scheduledTimeSet;
        private List<OFTime> scheduledTime;

    @Override
    public int getType() {
        return 0x1;
    }

    @Override
    public List<OFTime> getScheduledTime() {
        return scheduledTime;
    }

    @Override
    public OFBundlePropTime.Builder setScheduledTime(List<OFTime> scheduledTime) {
        this.scheduledTime = scheduledTime;
        this.scheduledTimeSet = true;
        return this;
    }
    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

//
        @Override
        public OFBundlePropTime build() {
            List<OFTime> scheduledTime = this.scheduledTimeSet ? this.scheduledTime : DEFAULT_SCHEDULED_TIME;
            if(scheduledTime == null)
                throw new NullPointerException("Property scheduledTime must not be null");


            return new OFBundlePropTimeVer15(
                    scheduledTime
                );
        }

    }


    final static Reader READER = new Reader();
    static class Reader implements OFMessageReader<OFBundlePropTime> {
        @Override
        public OFBundlePropTime readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            // fixed value property type == 0x1
            short type = bb.readShort();
            if(type != (short) 0x1)
                throw new OFParseError("Wrong type: Expected=0x1(0x1), got="+type);
            int length = U16.f(bb.readShort());
            if(length < MINIMUM_LENGTH)
                throw new OFParseError("Wrong length: Expected to be >= " + MINIMUM_LENGTH + ", was: " + length);
            if(bb.readableBytes() + (bb.readerIndex() - start) < length) {
                // Buffer does not have all data yet
                bb.readerIndex(start);
                return null;
            }
            if(logger.isTraceEnabled())
                logger.trace("readFrom - length={}", length);
            // pad: 4 bytes
            bb.skipBytes(4);
            List<OFTime> scheduledTime = ChannelUtils.readList(bb, length - (bb.readerIndex() - start), OFTimeVer15.READER);

            OFBundlePropTimeVer15 bundlePropTimeVer15 = new OFBundlePropTimeVer15(
                    scheduledTime
                    );
            if(logger.isTraceEnabled())
                logger.trace("readFrom - read={}", bundlePropTimeVer15);
            return bundlePropTimeVer15;
        }
    }

    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    final static OFBundlePropTimeVer15Funnel FUNNEL = new OFBundlePropTimeVer15Funnel();
    static class OFBundlePropTimeVer15Funnel implements Funnel<OFBundlePropTimeVer15> {
        private static final long serialVersionUID = 1L;
        @Override
        public void funnel(OFBundlePropTimeVer15 message, PrimitiveSink sink) {
            // fixed value property type = 0x1
            sink.putShort((short) 0x1);
            // FIXME: skip funnel of length
            // skip pad (4 bytes)
            FunnelUtils.putList(message.scheduledTime, sink);
        }
    }


    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    final static Writer WRITER = new Writer();
    static class Writer implements OFMessageWriter<OFBundlePropTimeVer15> {
        @Override
        public void write(ByteBuf bb, OFBundlePropTimeVer15 message) {
            int startIndex = bb.writerIndex();
            // fixed value property type = 0x1
            bb.writeShort((short) 0x1);
            // length is length of variable message, will be updated at the end
            int lengthIndex = bb.writerIndex();
            bb.writeShort(U16.t(0));

            // pad: 4 bytes
            bb.writeZero(4);
            ChannelUtils.writeList(bb, message.scheduledTime);

            // update length field
            int length = bb.writerIndex() - startIndex;
            if (length > MAXIMUM_LENGTH) {
                throw new IllegalArgumentException("OFBundlePropTimeVer15: message length (" + length + ") exceeds maximum (0xFFFF)");
            }
            bb.setShort(lengthIndex, length);

        }
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder("OFBundlePropTimeVer15(");
        b.append("scheduledTime=").append(scheduledTime);
        b.append(")");
        return b.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        OFBundlePropTimeVer15 other = (OFBundlePropTimeVer15) obj;

        if (scheduledTime == null) {
            if (other.scheduledTime != null)
                return false;
        } else if (!scheduledTime.equals(other.scheduledTime))
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;

        result = prime * result + ((scheduledTime == null) ? 0 : scheduledTime.hashCode());
        return result;
    }

}
