/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFErrorType;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFSwitchConfigFailedCode;
import org.projectfloodlight.openflow.protocol.OFType;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.errormsg.OFSwitchConfigFailedErrorMsg;
import org.projectfloodlight.openflow.protocol.ver15.OFSwitchConfigFailedCodeSerializerVer15;
import org.projectfloodlight.openflow.types.OFErrorCauseData;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFSwitchConfigFailedErrorMsgVer15
implements OFSwitchConfigFailedErrorMsg {
    private static final Logger logger = LoggerFactory.getLogger(OFSwitchConfigFailedErrorMsgVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int MINIMUM_LENGTH = 12;
    static final int MAXIMUM_LENGTH = 65535;
    private static final long DEFAULT_XID = 0L;
    private static final OFErrorCauseData DEFAULT_DATA = OFErrorCauseData.NONE;
    private final long xid;
    private final OFSwitchConfigFailedCode code;
    private final OFErrorCauseData data;
    static final Reader READER = new Reader();
    static final OFSwitchConfigFailedErrorMsgVer15Funnel FUNNEL = new OFSwitchConfigFailedErrorMsgVer15Funnel();
    static final Writer WRITER = new Writer();

    OFSwitchConfigFailedErrorMsgVer15(long xid, OFSwitchConfigFailedCode code, OFErrorCauseData data) {
        if (code == null) {
            throw new NullPointerException("OFSwitchConfigFailedErrorMsgVer15: property code cannot be null");
        }
        if (data == null) {
            throw new NullPointerException("OFSwitchConfigFailedErrorMsgVer15: property data cannot be null");
        }
        this.xid = U32.normalize(xid);
        this.code = code;
        this.data = data;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFType getType() {
        return OFType.ERROR;
    }

    @Override
    public long getXid() {
        return this.xid;
    }

    @Override
    public OFErrorType getErrType() {
        return OFErrorType.SWITCH_CONFIG_FAILED;
    }

    @Override
    public OFSwitchConfigFailedCode getCode() {
        return this.code;
    }

    @Override
    public OFErrorCauseData getData() {
        return this.data;
    }

    @Override
    public OFSwitchConfigFailedErrorMsg.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFSwitchConfigFailedErrorMsgVer15(");
        b.append("xid=").append(this.xid);
        b.append(", ");
        b.append("code=").append((Object)this.code);
        b.append(", ");
        b.append("data=").append(this.data);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFSwitchConfigFailedErrorMsgVer15 other = (OFSwitchConfigFailedErrorMsgVer15)obj;
        if (this.xid != other.xid) {
            return false;
        }
        if (this.code == null ? other.code != null : !this.code.equals((Object)other.code)) {
            return false;
        }
        return !(this.data == null ? other.data != null : !this.data.equals(other.data));
    }

    @Override
    public boolean equalsIgnoreXid(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFSwitchConfigFailedErrorMsgVer15 other = (OFSwitchConfigFailedErrorMsgVer15)obj;
        if (this.code == null ? other.code != null : !this.code.equals((Object)other.code)) {
            return false;
        }
        return !(this.data == null ? other.data != null : !this.data.equals(other.data));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.xid ^ this.xid >>> 32);
        result = 31 * result + (this.code == null ? 0 : this.code.hashCode());
        result = 31 * result + (this.data == null ? 0 : this.data.hashCode());
        return result;
    }

    @Override
    public int hashCodeIgnoreXid() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.code == null ? 0 : this.code.hashCode());
        result = 31 * result + (this.data == null ? 0 : this.data.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFSwitchConfigFailedErrorMsgVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFSwitchConfigFailedErrorMsgVer15 message) {
            int startIndex = bb.writerIndex();
            bb.writeByte(6);
            bb.writeByte(1);
            int lengthIndex = bb.writerIndex();
            bb.writeShort((int)U16.t(0));
            bb.writeInt(U32.t(message.xid));
            bb.writeShort(10);
            OFSwitchConfigFailedCodeSerializerVer15.writeTo(bb, message.code);
            message.data.writeTo(bb);
            int length = bb.writerIndex() - startIndex;
            if (length > 65535) {
                throw new IllegalArgumentException("OFSwitchConfigFailedErrorMsgVer15: message length (" + length + ") exceeds maximum (0xFFFF)");
            }
            bb.setShort(lengthIndex, length);
        }
    }

    static class OFSwitchConfigFailedErrorMsgVer15Funnel
    implements Funnel<OFSwitchConfigFailedErrorMsgVer15> {
        private static final long serialVersionUID = 1L;

        OFSwitchConfigFailedErrorMsgVer15Funnel() {
        }

        public void funnel(OFSwitchConfigFailedErrorMsgVer15 message, PrimitiveSink sink) {
            sink.putByte((byte)6);
            sink.putByte((byte)1);
            sink.putLong(message.xid);
            sink.putShort((short)10);
            OFSwitchConfigFailedCodeSerializerVer15.putTo(message.code, sink);
            message.data.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFSwitchConfigFailedErrorMsg> {
        Reader() {
        }

        @Override
        public OFSwitchConfigFailedErrorMsg readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 6) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_15(6), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 1) {
                throw new OFParseError("Wrong type: Expected=OFType.ERROR(1), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length < 12) {
                throw new OFParseError("Wrong length: Expected to be >= 12, was: " + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long xid = U32.f(bb.readInt());
            short errType = bb.readShort();
            if (errType != 10) {
                throw new OFParseError("Wrong errType: Expected=OFErrorType.SWITCH_CONFIG_FAILED(10), got=" + errType);
            }
            OFSwitchConfigFailedCode code = OFSwitchConfigFailedCodeSerializerVer15.readFrom(bb);
            OFErrorCauseData data = OFErrorCauseData.read(bb, length - (bb.readerIndex() - start), OFVersion.OF_15);
            OFSwitchConfigFailedErrorMsgVer15 switchConfigFailedErrorMsgVer15 = new OFSwitchConfigFailedErrorMsgVer15(xid, code, data);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)switchConfigFailedErrorMsgVer15);
            }
            return switchConfigFailedErrorMsgVer15;
        }
    }

    static class Builder
    implements OFSwitchConfigFailedErrorMsg.Builder {
        private boolean xidSet;
        private long xid;
        private boolean codeSet;
        private OFSwitchConfigFailedCode code;
        private boolean dataSet;
        private OFErrorCauseData data;

        Builder() {
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFType getType() {
            return OFType.ERROR;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFSwitchConfigFailedErrorMsg.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public OFErrorType getErrType() {
            return OFErrorType.SWITCH_CONFIG_FAILED;
        }

        @Override
        public OFSwitchConfigFailedCode getCode() {
            return this.code;
        }

        @Override
        public OFSwitchConfigFailedErrorMsg.Builder setCode(OFSwitchConfigFailedCode code) {
            this.code = code;
            this.codeSet = true;
            return this;
        }

        @Override
        public OFErrorCauseData getData() {
            return this.data;
        }

        @Override
        public OFSwitchConfigFailedErrorMsg.Builder setData(OFErrorCauseData data) {
            this.data = data;
            this.dataSet = true;
            return this;
        }

        @Override
        public OFSwitchConfigFailedErrorMsg build() {
            OFErrorCauseData data;
            long xid;
            long l = xid = this.xidSet ? this.xid : 0L;
            if (!this.codeSet) {
                throw new IllegalStateException("Property code doesn't have default value -- must be set");
            }
            if (this.code == null) {
                throw new NullPointerException("Property code must not be null");
            }
            OFErrorCauseData oFErrorCauseData = data = this.dataSet ? this.data : DEFAULT_DATA;
            if (data == null) {
                throw new NullPointerException("Property data must not be null");
            }
            return new OFSwitchConfigFailedErrorMsgVer15(xid, this.code, data);
        }
    }

    static class BuilderWithParent
    implements OFSwitchConfigFailedErrorMsg.Builder {
        final OFSwitchConfigFailedErrorMsgVer15 parentMessage;
        private boolean xidSet;
        private long xid;
        private boolean codeSet;
        private OFSwitchConfigFailedCode code;
        private boolean dataSet;
        private OFErrorCauseData data;

        BuilderWithParent(OFSwitchConfigFailedErrorMsgVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFType getType() {
            return OFType.ERROR;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFSwitchConfigFailedErrorMsg.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public OFErrorType getErrType() {
            return OFErrorType.SWITCH_CONFIG_FAILED;
        }

        @Override
        public OFSwitchConfigFailedCode getCode() {
            return this.code;
        }

        @Override
        public OFSwitchConfigFailedErrorMsg.Builder setCode(OFSwitchConfigFailedCode code) {
            this.code = code;
            this.codeSet = true;
            return this;
        }

        @Override
        public OFErrorCauseData getData() {
            return this.data;
        }

        @Override
        public OFSwitchConfigFailedErrorMsg.Builder setData(OFErrorCauseData data) {
            this.data = data;
            this.dataSet = true;
            return this;
        }

        @Override
        public OFSwitchConfigFailedErrorMsg build() {
            OFErrorCauseData data;
            OFSwitchConfigFailedCode code;
            long xid = this.xidSet ? this.xid : this.parentMessage.xid;
            OFSwitchConfigFailedCode oFSwitchConfigFailedCode = code = this.codeSet ? this.code : this.parentMessage.code;
            if (code == null) {
                throw new NullPointerException("Property code must not be null");
            }
            OFErrorCauseData oFErrorCauseData = data = this.dataSet ? this.data : this.parentMessage.data;
            if (data == null) {
                throw new NullPointerException("Property data must not be null");
            }
            return new OFSwitchConfigFailedErrorMsgVer15(xid, code, data);
        }
    }
}

