/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.collect.ImmutableSet;
import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import java.util.Set;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFConfigFlags;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFSetConfig;
import org.projectfloodlight.openflow.protocol.OFType;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.ver15.OFConfigFlagsSerializerVer15;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFSetConfigVer15
implements OFSetConfig {
    private static final Logger logger = LoggerFactory.getLogger(OFSetConfigVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int LENGTH = 12;
    private static final long DEFAULT_XID = 0L;
    private static final Set<OFConfigFlags> DEFAULT_FLAGS = ImmutableSet.of();
    private static final int DEFAULT_MISS_SEND_LEN = 0;
    private final long xid;
    private final Set<OFConfigFlags> flags;
    private final int missSendLen;
    static final OFSetConfigVer15 DEFAULT = new OFSetConfigVer15(0L, DEFAULT_FLAGS, 0);
    static final Reader READER = new Reader();
    static final OFSetConfigVer15Funnel FUNNEL = new OFSetConfigVer15Funnel();
    static final Writer WRITER = new Writer();

    OFSetConfigVer15(long xid, Set<OFConfigFlags> flags, int missSendLen) {
        if (flags == null) {
            throw new NullPointerException("OFSetConfigVer15: property flags cannot be null");
        }
        this.xid = U32.normalize(xid);
        this.flags = flags;
        this.missSendLen = U16.normalize(missSendLen);
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFType getType() {
        return OFType.SET_CONFIG;
    }

    @Override
    public long getXid() {
        return this.xid;
    }

    @Override
    public Set<OFConfigFlags> getFlags() {
        return this.flags;
    }

    @Override
    public int getMissSendLen() {
        return this.missSendLen;
    }

    @Override
    public OFSetConfig.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFSetConfigVer15(");
        b.append("xid=").append(this.xid);
        b.append(", ");
        b.append("flags=").append(this.flags);
        b.append(", ");
        b.append("missSendLen=").append(this.missSendLen);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFSetConfigVer15 other = (OFSetConfigVer15)obj;
        if (this.xid != other.xid) {
            return false;
        }
        if (this.flags == null ? other.flags != null : !this.flags.equals(other.flags)) {
            return false;
        }
        return this.missSendLen == other.missSendLen;
    }

    @Override
    public boolean equalsIgnoreXid(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFSetConfigVer15 other = (OFSetConfigVer15)obj;
        if (this.flags == null ? other.flags != null : !this.flags.equals(other.flags)) {
            return false;
        }
        return this.missSendLen == other.missSendLen;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.xid ^ this.xid >>> 32);
        result = 31 * result + (this.flags == null ? 0 : this.flags.hashCode());
        result = 31 * result + this.missSendLen;
        return result;
    }

    @Override
    public int hashCodeIgnoreXid() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.flags == null ? 0 : this.flags.hashCode());
        result = 31 * result + this.missSendLen;
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFSetConfigVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFSetConfigVer15 message) {
            bb.writeByte(6);
            bb.writeByte(9);
            bb.writeShort(12);
            bb.writeInt(U32.t(message.xid));
            OFConfigFlagsSerializerVer15.writeTo(bb, message.flags);
            bb.writeShort((int)U16.t(message.missSendLen));
        }
    }

    static class OFSetConfigVer15Funnel
    implements Funnel<OFSetConfigVer15> {
        private static final long serialVersionUID = 1L;

        OFSetConfigVer15Funnel() {
        }

        public void funnel(OFSetConfigVer15 message, PrimitiveSink sink) {
            sink.putByte((byte)6);
            sink.putByte((byte)9);
            sink.putShort((short)12);
            sink.putLong(message.xid);
            OFConfigFlagsSerializerVer15.putTo(message.flags, sink);
            sink.putInt(message.missSendLen);
        }
    }

    static class Reader
    implements OFMessageReader<OFSetConfig> {
        Reader() {
        }

        @Override
        public OFSetConfig readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 6) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_15(6), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 9) {
                throw new OFParseError("Wrong type: Expected=OFType.SET_CONFIG(9), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 12) {
                throw new OFParseError("Wrong length: Expected=12(12), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long xid = U32.f(bb.readInt());
            Set<OFConfigFlags> flags = OFConfigFlagsSerializerVer15.readFrom(bb);
            int missSendLen = U16.f(bb.readShort());
            OFSetConfigVer15 setConfigVer15 = new OFSetConfigVer15(xid, flags, missSendLen);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)setConfigVer15);
            }
            return setConfigVer15;
        }
    }

    static class Builder
    implements OFSetConfig.Builder {
        private boolean xidSet;
        private long xid;
        private boolean flagsSet;
        private Set<OFConfigFlags> flags;
        private boolean missSendLenSet;
        private int missSendLen;

        Builder() {
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFType getType() {
            return OFType.SET_CONFIG;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFSetConfig.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public Set<OFConfigFlags> getFlags() {
            return this.flags;
        }

        @Override
        public OFSetConfig.Builder setFlags(Set<OFConfigFlags> flags) {
            this.flags = flags;
            this.flagsSet = true;
            return this;
        }

        @Override
        public int getMissSendLen() {
            return this.missSendLen;
        }

        @Override
        public OFSetConfig.Builder setMissSendLen(int missSendLen) {
            this.missSendLen = missSendLen;
            this.missSendLenSet = true;
            return this;
        }

        @Override
        public OFSetConfig build() {
            Set<OFConfigFlags> flags;
            long xid = this.xidSet ? this.xid : 0L;
            Set<OFConfigFlags> set = flags = this.flagsSet ? this.flags : DEFAULT_FLAGS;
            if (flags == null) {
                throw new NullPointerException("Property flags must not be null");
            }
            int missSendLen = this.missSendLenSet ? this.missSendLen : 0;
            return new OFSetConfigVer15(xid, flags, missSendLen);
        }
    }

    static class BuilderWithParent
    implements OFSetConfig.Builder {
        final OFSetConfigVer15 parentMessage;
        private boolean xidSet;
        private long xid;
        private boolean flagsSet;
        private Set<OFConfigFlags> flags;
        private boolean missSendLenSet;
        private int missSendLen;

        BuilderWithParent(OFSetConfigVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFType getType() {
            return OFType.SET_CONFIG;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFSetConfig.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public Set<OFConfigFlags> getFlags() {
            return this.flags;
        }

        @Override
        public OFSetConfig.Builder setFlags(Set<OFConfigFlags> flags) {
            this.flags = flags;
            this.flagsSet = true;
            return this;
        }

        @Override
        public int getMissSendLen() {
            return this.missSendLen;
        }

        @Override
        public OFSetConfig.Builder setMissSendLen(int missSendLen) {
            this.missSendLen = missSendLen;
            this.missSendLenSet = true;
            return this;
        }

        @Override
        public OFSetConfig build() {
            Set flags;
            long xid = this.xidSet ? this.xid : this.parentMessage.xid;
            Set set = flags = this.flagsSet ? this.flags : this.parentMessage.flags;
            if (flags == null) {
                throw new NullPointerException("Property flags must not be null");
            }
            int missSendLen = this.missSendLenSet ? this.missSendLen : this.parentMessage.missSendLen;
            return new OFSetConfigVer15(xid, flags, missSendLen);
        }
    }
}

