/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFQueueStatsPropBsn;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.util.ChannelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFQueueStatsPropBsnVer15
implements OFQueueStatsPropBsn {
    private static final Logger logger = LoggerFactory.getLogger(OFQueueStatsPropBsnVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int MINIMUM_LENGTH = 12;
    static final int MAXIMUM_LENGTH = 65535;
    private static final byte[] DEFAULT_EXPERIMENTER_DATA = new byte[0];
    private final byte[] experimenterData;
    static final OFQueueStatsPropBsnVer15 DEFAULT = new OFQueueStatsPropBsnVer15(DEFAULT_EXPERIMENTER_DATA);
    static final Reader READER = new Reader();
    static final OFQueueStatsPropBsnVer15Funnel FUNNEL = new OFQueueStatsPropBsnVer15Funnel();
    static final Writer WRITER = new Writer();

    OFQueueStatsPropBsnVer15(byte[] experimenterData) {
        if (experimenterData == null) {
            throw new NullPointerException("OFQueueStatsPropBsnVer15: property experimenterData cannot be null");
        }
        this.experimenterData = experimenterData;
    }

    @Override
    public int getType() {
        return 65535;
    }

    @Override
    public long getExperimenter() {
        return 6035143L;
    }

    @Override
    public long getExpType() {
        return 0L;
    }

    @Override
    public byte[] getExperimenterData() {
        return this.experimenterData;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFQueueStatsPropBsn.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFQueueStatsPropBsnVer15(");
        b.append("experimenterData=").append(Arrays.toString(this.experimenterData));
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFQueueStatsPropBsnVer15 other = (OFQueueStatsPropBsnVer15)obj;
        return Arrays.equals(this.experimenterData, other.experimenterData);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.experimenterData);
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFQueueStatsPropBsnVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFQueueStatsPropBsnVer15 message) {
            int startIndex = bb.writerIndex();
            bb.writeShort(-1);
            int lengthIndex = bb.writerIndex();
            bb.writeShort((int)U16.t(0));
            bb.writeInt(6035143);
            bb.writeInt(0);
            bb.writeBytes(message.experimenterData);
            int length = bb.writerIndex() - startIndex;
            if (length > 65535) {
                throw new IllegalArgumentException("OFQueueStatsPropBsnVer15: message length (" + length + ") exceeds maximum (0xFFFF)");
            }
            bb.setShort(lengthIndex, length);
        }
    }

    static class OFQueueStatsPropBsnVer15Funnel
    implements Funnel<OFQueueStatsPropBsnVer15> {
        private static final long serialVersionUID = 1L;

        OFQueueStatsPropBsnVer15Funnel() {
        }

        public void funnel(OFQueueStatsPropBsnVer15 message, PrimitiveSink sink) {
            sink.putShort((short)-1);
            sink.putInt(6035143);
            sink.putInt(0);
            sink.putBytes(message.experimenterData);
        }
    }

    static class Reader
    implements OFMessageReader<OFQueueStatsPropBsn> {
        Reader() {
        }

        @Override
        public OFQueueStatsPropBsn readFrom(ByteBuf bb) throws OFParseError {
            int experimenter;
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != -1) {
                throw new OFParseError("Wrong type: Expected=0xffff(0xffff), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length < 12) {
                throw new OFParseError("Wrong length: Expected to be >= 12, was: " + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            if ((experimenter = bb.readInt()) != 6035143) {
                throw new OFParseError("Wrong experimenter: Expected=0x5c16c7L(0x5c16c7L), got=" + experimenter);
            }
            int expType = bb.readInt();
            if (expType != 0) {
                throw new OFParseError("Wrong expType: Expected=0x0L(0x0L), got=" + expType);
            }
            byte[] experimenterData = ChannelUtils.readBytes(bb, length - (bb.readerIndex() - start));
            OFQueueStatsPropBsnVer15 queueStatsPropBsnVer15 = new OFQueueStatsPropBsnVer15(experimenterData);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)queueStatsPropBsnVer15);
            }
            return queueStatsPropBsnVer15;
        }
    }

    static class Builder
    implements OFQueueStatsPropBsn.Builder {
        private boolean experimenterDataSet;
        private byte[] experimenterData;

        Builder() {
        }

        @Override
        public int getType() {
            return 65535;
        }

        @Override
        public long getExperimenter() {
            return 6035143L;
        }

        @Override
        public long getExpType() {
            return 0L;
        }

        @Override
        public OFQueueStatsPropBsn.Builder setExpType(long expType) {
            throw new UnsupportedOperationException("Property expType is not writeable");
        }

        @Override
        public byte[] getExperimenterData() {
            return this.experimenterData;
        }

        @Override
        public OFQueueStatsPropBsn.Builder setExperimenterData(byte[] experimenterData) {
            this.experimenterData = experimenterData;
            this.experimenterDataSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFQueueStatsPropBsn build() {
            byte[] experimenterData;
            byte[] byArray = experimenterData = this.experimenterDataSet ? this.experimenterData : DEFAULT_EXPERIMENTER_DATA;
            if (experimenterData == null) {
                throw new NullPointerException("Property experimenterData must not be null");
            }
            return new OFQueueStatsPropBsnVer15(experimenterData);
        }
    }

    static class BuilderWithParent
    implements OFQueueStatsPropBsn.Builder {
        final OFQueueStatsPropBsnVer15 parentMessage;
        private boolean experimenterDataSet;
        private byte[] experimenterData;

        BuilderWithParent(OFQueueStatsPropBsnVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 65535;
        }

        @Override
        public long getExperimenter() {
            return 6035143L;
        }

        @Override
        public long getExpType() {
            return 0L;
        }

        @Override
        public OFQueueStatsPropBsn.Builder setExpType(long expType) {
            throw new UnsupportedOperationException("Property expType is not writeable");
        }

        @Override
        public byte[] getExperimenterData() {
            return this.experimenterData;
        }

        @Override
        public OFQueueStatsPropBsn.Builder setExperimenterData(byte[] experimenterData) {
            this.experimenterData = experimenterData;
            this.experimenterDataSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFQueueStatsPropBsn build() {
            byte[] experimenterData;
            byte[] byArray = experimenterData = this.experimenterDataSet ? this.experimenterData : this.parentMessage.experimenterData;
            if (experimenterData == null) {
                throw new NullPointerException("Property experimenterData must not be null");
            }
            return new OFQueueStatsPropBsnVer15(experimenterData);
        }
    }
}

