/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFPortStatsPropEthernet;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFPortStatsPropEthernetVer15
implements OFPortStatsPropEthernet {
    private static final Logger logger = LoggerFactory.getLogger(OFPortStatsPropEthernetVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int LENGTH = 40;
    private static final U64 DEFAULT_RX_FRAME_ERR = U64.ZERO;
    private static final U64 DEFAULT_RX_OVER_ERR = U64.ZERO;
    private static final U64 DEFAULT_RX_CRC_ERR = U64.ZERO;
    private static final U64 DEFAULT_COLLISIONS = U64.ZERO;
    private final U64 rxFrameErr;
    private final U64 rxOverErr;
    private final U64 rxCrcErr;
    private final U64 collisions;
    static final OFPortStatsPropEthernetVer15 DEFAULT = new OFPortStatsPropEthernetVer15(DEFAULT_RX_FRAME_ERR, DEFAULT_RX_OVER_ERR, DEFAULT_RX_CRC_ERR, DEFAULT_COLLISIONS);
    static final Reader READER = new Reader();
    static final OFPortStatsPropEthernetVer15Funnel FUNNEL = new OFPortStatsPropEthernetVer15Funnel();
    static final Writer WRITER = new Writer();

    OFPortStatsPropEthernetVer15(U64 rxFrameErr, U64 rxOverErr, U64 rxCrcErr, U64 collisions) {
        if (rxFrameErr == null) {
            throw new NullPointerException("OFPortStatsPropEthernetVer15: property rxFrameErr cannot be null");
        }
        if (rxOverErr == null) {
            throw new NullPointerException("OFPortStatsPropEthernetVer15: property rxOverErr cannot be null");
        }
        if (rxCrcErr == null) {
            throw new NullPointerException("OFPortStatsPropEthernetVer15: property rxCrcErr cannot be null");
        }
        if (collisions == null) {
            throw new NullPointerException("OFPortStatsPropEthernetVer15: property collisions cannot be null");
        }
        this.rxFrameErr = rxFrameErr;
        this.rxOverErr = rxOverErr;
        this.rxCrcErr = rxCrcErr;
        this.collisions = collisions;
    }

    @Override
    public int getType() {
        return 0;
    }

    @Override
    public U64 getRxFrameErr() {
        return this.rxFrameErr;
    }

    @Override
    public U64 getRxOverErr() {
        return this.rxOverErr;
    }

    @Override
    public U64 getRxCrcErr() {
        return this.rxCrcErr;
    }

    @Override
    public U64 getCollisions() {
        return this.collisions;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFPortStatsPropEthernet.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFPortStatsPropEthernetVer15(");
        b.append("rxFrameErr=").append(this.rxFrameErr);
        b.append(", ");
        b.append("rxOverErr=").append(this.rxOverErr);
        b.append(", ");
        b.append("rxCrcErr=").append(this.rxCrcErr);
        b.append(", ");
        b.append("collisions=").append(this.collisions);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFPortStatsPropEthernetVer15 other = (OFPortStatsPropEthernetVer15)obj;
        if (this.rxFrameErr == null ? other.rxFrameErr != null : !this.rxFrameErr.equals(other.rxFrameErr)) {
            return false;
        }
        if (this.rxOverErr == null ? other.rxOverErr != null : !this.rxOverErr.equals(other.rxOverErr)) {
            return false;
        }
        if (this.rxCrcErr == null ? other.rxCrcErr != null : !this.rxCrcErr.equals(other.rxCrcErr)) {
            return false;
        }
        return !(this.collisions == null ? other.collisions != null : !this.collisions.equals(other.collisions));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.rxFrameErr == null ? 0 : this.rxFrameErr.hashCode());
        result = 31 * result + (this.rxOverErr == null ? 0 : this.rxOverErr.hashCode());
        result = 31 * result + (this.rxCrcErr == null ? 0 : this.rxCrcErr.hashCode());
        result = 31 * result + (this.collisions == null ? 0 : this.collisions.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFPortStatsPropEthernetVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFPortStatsPropEthernetVer15 message) {
            bb.writeShort(0);
            bb.writeShort(40);
            bb.writeZero(4);
            bb.writeLong(message.rxFrameErr.getValue());
            bb.writeLong(message.rxOverErr.getValue());
            bb.writeLong(message.rxCrcErr.getValue());
            bb.writeLong(message.collisions.getValue());
        }
    }

    static class OFPortStatsPropEthernetVer15Funnel
    implements Funnel<OFPortStatsPropEthernetVer15> {
        private static final long serialVersionUID = 1L;

        OFPortStatsPropEthernetVer15Funnel() {
        }

        public void funnel(OFPortStatsPropEthernetVer15 message, PrimitiveSink sink) {
            sink.putShort((short)0);
            sink.putShort((short)40);
            message.rxFrameErr.putTo(sink);
            message.rxOverErr.putTo(sink);
            message.rxCrcErr.putTo(sink);
            message.collisions.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFPortStatsPropEthernet> {
        Reader() {
        }

        @Override
        public OFPortStatsPropEthernet readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 0) {
                throw new OFParseError("Wrong type: Expected=0x0(0x0), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 40) {
                throw new OFParseError("Wrong length: Expected=40(40), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            bb.skipBytes(4);
            U64 rxFrameErr = U64.ofRaw(bb.readLong());
            U64 rxOverErr = U64.ofRaw(bb.readLong());
            U64 rxCrcErr = U64.ofRaw(bb.readLong());
            U64 collisions = U64.ofRaw(bb.readLong());
            OFPortStatsPropEthernetVer15 portStatsPropEthernetVer15 = new OFPortStatsPropEthernetVer15(rxFrameErr, rxOverErr, rxCrcErr, collisions);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)portStatsPropEthernetVer15);
            }
            return portStatsPropEthernetVer15;
        }
    }

    static class Builder
    implements OFPortStatsPropEthernet.Builder {
        private boolean rxFrameErrSet;
        private U64 rxFrameErr;
        private boolean rxOverErrSet;
        private U64 rxOverErr;
        private boolean rxCrcErrSet;
        private U64 rxCrcErr;
        private boolean collisionsSet;
        private U64 collisions;

        Builder() {
        }

        @Override
        public int getType() {
            return 0;
        }

        @Override
        public U64 getRxFrameErr() {
            return this.rxFrameErr;
        }

        @Override
        public OFPortStatsPropEthernet.Builder setRxFrameErr(U64 rxFrameErr) {
            this.rxFrameErr = rxFrameErr;
            this.rxFrameErrSet = true;
            return this;
        }

        @Override
        public U64 getRxOverErr() {
            return this.rxOverErr;
        }

        @Override
        public OFPortStatsPropEthernet.Builder setRxOverErr(U64 rxOverErr) {
            this.rxOverErr = rxOverErr;
            this.rxOverErrSet = true;
            return this;
        }

        @Override
        public U64 getRxCrcErr() {
            return this.rxCrcErr;
        }

        @Override
        public OFPortStatsPropEthernet.Builder setRxCrcErr(U64 rxCrcErr) {
            this.rxCrcErr = rxCrcErr;
            this.rxCrcErrSet = true;
            return this;
        }

        @Override
        public U64 getCollisions() {
            return this.collisions;
        }

        @Override
        public OFPortStatsPropEthernet.Builder setCollisions(U64 collisions) {
            this.collisions = collisions;
            this.collisionsSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFPortStatsPropEthernet build() {
            U64 collisions;
            U64 rxCrcErr;
            U64 rxOverErr;
            U64 rxFrameErr;
            U64 u64 = rxFrameErr = this.rxFrameErrSet ? this.rxFrameErr : DEFAULT_RX_FRAME_ERR;
            if (rxFrameErr == null) {
                throw new NullPointerException("Property rxFrameErr must not be null");
            }
            U64 u642 = rxOverErr = this.rxOverErrSet ? this.rxOverErr : DEFAULT_RX_OVER_ERR;
            if (rxOverErr == null) {
                throw new NullPointerException("Property rxOverErr must not be null");
            }
            U64 u643 = rxCrcErr = this.rxCrcErrSet ? this.rxCrcErr : DEFAULT_RX_CRC_ERR;
            if (rxCrcErr == null) {
                throw new NullPointerException("Property rxCrcErr must not be null");
            }
            U64 u644 = collisions = this.collisionsSet ? this.collisions : DEFAULT_COLLISIONS;
            if (collisions == null) {
                throw new NullPointerException("Property collisions must not be null");
            }
            return new OFPortStatsPropEthernetVer15(rxFrameErr, rxOverErr, rxCrcErr, collisions);
        }
    }

    static class BuilderWithParent
    implements OFPortStatsPropEthernet.Builder {
        final OFPortStatsPropEthernetVer15 parentMessage;
        private boolean rxFrameErrSet;
        private U64 rxFrameErr;
        private boolean rxOverErrSet;
        private U64 rxOverErr;
        private boolean rxCrcErrSet;
        private U64 rxCrcErr;
        private boolean collisionsSet;
        private U64 collisions;

        BuilderWithParent(OFPortStatsPropEthernetVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 0;
        }

        @Override
        public U64 getRxFrameErr() {
            return this.rxFrameErr;
        }

        @Override
        public OFPortStatsPropEthernet.Builder setRxFrameErr(U64 rxFrameErr) {
            this.rxFrameErr = rxFrameErr;
            this.rxFrameErrSet = true;
            return this;
        }

        @Override
        public U64 getRxOverErr() {
            return this.rxOverErr;
        }

        @Override
        public OFPortStatsPropEthernet.Builder setRxOverErr(U64 rxOverErr) {
            this.rxOverErr = rxOverErr;
            this.rxOverErrSet = true;
            return this;
        }

        @Override
        public U64 getRxCrcErr() {
            return this.rxCrcErr;
        }

        @Override
        public OFPortStatsPropEthernet.Builder setRxCrcErr(U64 rxCrcErr) {
            this.rxCrcErr = rxCrcErr;
            this.rxCrcErrSet = true;
            return this;
        }

        @Override
        public U64 getCollisions() {
            return this.collisions;
        }

        @Override
        public OFPortStatsPropEthernet.Builder setCollisions(U64 collisions) {
            this.collisions = collisions;
            this.collisionsSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFPortStatsPropEthernet build() {
            U64 collisions;
            U64 rxCrcErr;
            U64 rxOverErr;
            U64 rxFrameErr;
            U64 u64 = rxFrameErr = this.rxFrameErrSet ? this.rxFrameErr : this.parentMessage.rxFrameErr;
            if (rxFrameErr == null) {
                throw new NullPointerException("Property rxFrameErr must not be null");
            }
            U64 u642 = rxOverErr = this.rxOverErrSet ? this.rxOverErr : this.parentMessage.rxOverErr;
            if (rxOverErr == null) {
                throw new NullPointerException("Property rxOverErr must not be null");
            }
            U64 u643 = rxCrcErr = this.rxCrcErrSet ? this.rxCrcErr : this.parentMessage.rxCrcErr;
            if (rxCrcErr == null) {
                throw new NullPointerException("Property rxCrcErr must not be null");
            }
            U64 u644 = collisions = this.collisionsSet ? this.collisions : this.parentMessage.collisions;
            if (collisions == null) {
                throw new NullPointerException("Property collisions must not be null");
            }
            return new OFPortStatsPropEthernetVer15(rxFrameErr, rxOverErr, rxCrcErr, collisions);
        }
    }
}

