/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFPortDescPropRecirculate;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.util.ChannelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFPortDescPropRecirculateVer15
implements OFPortDescPropRecirculate {
    private static final Logger logger = LoggerFactory.getLogger(OFPortDescPropRecirculateVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int MINIMUM_LENGTH = 4;
    static final int MAXIMUM_LENGTH = 65535;
    private static final byte[] DEFAULT_PORT_NOS = new byte[0];
    private final byte[] portNos;
    static final OFPortDescPropRecirculateVer15 DEFAULT = new OFPortDescPropRecirculateVer15(DEFAULT_PORT_NOS);
    static final Reader READER = new Reader();
    static final OFPortDescPropRecirculateVer15Funnel FUNNEL = new OFPortDescPropRecirculateVer15Funnel();
    static final Writer WRITER = new Writer();

    OFPortDescPropRecirculateVer15(byte[] portNos) {
        if (portNos == null) {
            throw new NullPointerException("OFPortDescPropRecirculateVer15: property portNos cannot be null");
        }
        this.portNos = portNos;
    }

    @Override
    public int getType() {
        return 4;
    }

    @Override
    public byte[] getPortNos() {
        return this.portNos;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFPortDescPropRecirculate.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFPortDescPropRecirculateVer15(");
        b.append("portNos=").append(Arrays.toString(this.portNos));
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFPortDescPropRecirculateVer15 other = (OFPortDescPropRecirculateVer15)obj;
        return Arrays.equals(this.portNos, other.portNos);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.portNos);
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFPortDescPropRecirculateVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFPortDescPropRecirculateVer15 message) {
            int startIndex = bb.writerIndex();
            bb.writeShort(4);
            int lengthIndex = bb.writerIndex();
            bb.writeShort((int)U16.t(0));
            bb.writeBytes(message.portNos);
            int length = bb.writerIndex() - startIndex;
            if (length > 65535) {
                throw new IllegalArgumentException("OFPortDescPropRecirculateVer15: message length (" + length + ") exceeds maximum (0xFFFF)");
            }
            bb.setShort(lengthIndex, length);
        }
    }

    static class OFPortDescPropRecirculateVer15Funnel
    implements Funnel<OFPortDescPropRecirculateVer15> {
        private static final long serialVersionUID = 1L;

        OFPortDescPropRecirculateVer15Funnel() {
        }

        public void funnel(OFPortDescPropRecirculateVer15 message, PrimitiveSink sink) {
            sink.putShort((short)4);
            sink.putBytes(message.portNos);
        }
    }

    static class Reader
    implements OFMessageReader<OFPortDescPropRecirculate> {
        Reader() {
        }

        @Override
        public OFPortDescPropRecirculate readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 4) {
                throw new OFParseError("Wrong type: Expected=0x4(0x4), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length < 4) {
                throw new OFParseError("Wrong length: Expected to be >= 4, was: " + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            byte[] portNos = ChannelUtils.readBytes(bb, length - (bb.readerIndex() - start));
            OFPortDescPropRecirculateVer15 portDescPropRecirculateVer15 = new OFPortDescPropRecirculateVer15(portNos);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)portDescPropRecirculateVer15);
            }
            return portDescPropRecirculateVer15;
        }
    }

    static class Builder
    implements OFPortDescPropRecirculate.Builder {
        private boolean portNosSet;
        private byte[] portNos;

        Builder() {
        }

        @Override
        public int getType() {
            return 4;
        }

        @Override
        public byte[] getPortNos() {
            return this.portNos;
        }

        @Override
        public OFPortDescPropRecirculate.Builder setPortNos(byte[] portNos) {
            this.portNos = portNos;
            this.portNosSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFPortDescPropRecirculate build() {
            byte[] portNos;
            byte[] byArray = portNos = this.portNosSet ? this.portNos : DEFAULT_PORT_NOS;
            if (portNos == null) {
                throw new NullPointerException("Property portNos must not be null");
            }
            return new OFPortDescPropRecirculateVer15(portNos);
        }
    }

    static class BuilderWithParent
    implements OFPortDescPropRecirculate.Builder {
        final OFPortDescPropRecirculateVer15 parentMessage;
        private boolean portNosSet;
        private byte[] portNos;

        BuilderWithParent(OFPortDescPropRecirculateVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 4;
        }

        @Override
        public byte[] getPortNos() {
            return this.portNos;
        }

        @Override
        public OFPortDescPropRecirculate.Builder setPortNos(byte[] portNos) {
            this.portNos = portNos;
            this.portNosSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFPortDescPropRecirculate build() {
            byte[] portNos;
            byte[] byArray = portNos = this.portNosSet ? this.portNos : this.parentMessage.portNos;
            if (portNos == null) {
                throw new NullPointerException("Property portNos must not be null");
            }
            return new OFPortDescPropRecirculateVer15(portNos);
        }
    }
}

