/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFPortDescPropEgress;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.util.ChannelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFPortDescPropEgressVer15
implements OFPortDescPropEgress {
    private static final Logger logger = LoggerFactory.getLogger(OFPortDescPropEgressVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int MINIMUM_LENGTH = 4;
    static final int MAXIMUM_LENGTH = 65535;
    private static final byte[] DEFAULT_OXM_IDS = new byte[0];
    private final byte[] oxmIds;
    static final OFPortDescPropEgressVer15 DEFAULT = new OFPortDescPropEgressVer15(DEFAULT_OXM_IDS);
    static final Reader READER = new Reader();
    static final OFPortDescPropEgressVer15Funnel FUNNEL = new OFPortDescPropEgressVer15Funnel();
    static final Writer WRITER = new Writer();

    OFPortDescPropEgressVer15(byte[] oxmIds) {
        if (oxmIds == null) {
            throw new NullPointerException("OFPortDescPropEgressVer15: property oxmIds cannot be null");
        }
        this.oxmIds = oxmIds;
    }

    @Override
    public int getType() {
        return 3;
    }

    @Override
    public byte[] getOxmIds() {
        return this.oxmIds;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFPortDescPropEgress.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFPortDescPropEgressVer15(");
        b.append("oxmIds=").append(Arrays.toString(this.oxmIds));
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFPortDescPropEgressVer15 other = (OFPortDescPropEgressVer15)obj;
        return Arrays.equals(this.oxmIds, other.oxmIds);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.oxmIds);
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFPortDescPropEgressVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFPortDescPropEgressVer15 message) {
            int startIndex = bb.writerIndex();
            bb.writeShort(3);
            int lengthIndex = bb.writerIndex();
            bb.writeShort((int)U16.t(0));
            bb.writeBytes(message.oxmIds);
            int length = bb.writerIndex() - startIndex;
            if (length > 65535) {
                throw new IllegalArgumentException("OFPortDescPropEgressVer15: message length (" + length + ") exceeds maximum (0xFFFF)");
            }
            bb.setShort(lengthIndex, length);
        }
    }

    static class OFPortDescPropEgressVer15Funnel
    implements Funnel<OFPortDescPropEgressVer15> {
        private static final long serialVersionUID = 1L;

        OFPortDescPropEgressVer15Funnel() {
        }

        public void funnel(OFPortDescPropEgressVer15 message, PrimitiveSink sink) {
            sink.putShort((short)3);
            sink.putBytes(message.oxmIds);
        }
    }

    static class Reader
    implements OFMessageReader<OFPortDescPropEgress> {
        Reader() {
        }

        @Override
        public OFPortDescPropEgress readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 3) {
                throw new OFParseError("Wrong type: Expected=0x3(0x3), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length < 4) {
                throw new OFParseError("Wrong length: Expected to be >= 4, was: " + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            byte[] oxmIds = ChannelUtils.readBytes(bb, length - (bb.readerIndex() - start));
            OFPortDescPropEgressVer15 portDescPropEgressVer15 = new OFPortDescPropEgressVer15(oxmIds);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)portDescPropEgressVer15);
            }
            return portDescPropEgressVer15;
        }
    }

    static class Builder
    implements OFPortDescPropEgress.Builder {
        private boolean oxmIdsSet;
        private byte[] oxmIds;

        Builder() {
        }

        @Override
        public int getType() {
            return 3;
        }

        @Override
        public byte[] getOxmIds() {
            return this.oxmIds;
        }

        @Override
        public OFPortDescPropEgress.Builder setOxmIds(byte[] oxmIds) {
            this.oxmIds = oxmIds;
            this.oxmIdsSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFPortDescPropEgress build() {
            byte[] oxmIds;
            byte[] byArray = oxmIds = this.oxmIdsSet ? this.oxmIds : DEFAULT_OXM_IDS;
            if (oxmIds == null) {
                throw new NullPointerException("Property oxmIds must not be null");
            }
            return new OFPortDescPropEgressVer15(oxmIds);
        }
    }

    static class BuilderWithParent
    implements OFPortDescPropEgress.Builder {
        final OFPortDescPropEgressVer15 parentMessage;
        private boolean oxmIdsSet;
        private byte[] oxmIds;

        BuilderWithParent(OFPortDescPropEgressVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 3;
        }

        @Override
        public byte[] getOxmIds() {
            return this.oxmIds;
        }

        @Override
        public OFPortDescPropEgress.Builder setOxmIds(byte[] oxmIds) {
            this.oxmIds = oxmIds;
            this.oxmIdsSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFPortDescPropEgress build() {
            byte[] oxmIds;
            byte[] byArray = oxmIds = this.oxmIdsSet ? this.oxmIds : this.parentMessage.oxmIds;
            if (oxmIds == null) {
                throw new NullPointerException("Property oxmIds must not be null");
            }
            return new OFPortDescPropEgressVer15(oxmIds);
        }
    }
}

