/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.match.MatchField;
import org.projectfloodlight.openflow.protocol.oxm.OFOxm;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmVlanVidMasked;
import org.projectfloodlight.openflow.protocol.ver15.OFOxmVlanVidVer15;
import org.projectfloodlight.openflow.types.OFVlanVidMatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFOxmVlanVidMaskedVer15
implements OFOxmVlanVidMasked {
    private static final Logger logger = LoggerFactory.getLogger(OFOxmVlanVidMaskedVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int LENGTH = 8;
    private static final OFVlanVidMatch DEFAULT_VALUE = OFVlanVidMatch.NONE;
    private static final OFVlanVidMatch DEFAULT_VALUE_MASK = OFVlanVidMatch.NONE;
    private final OFVlanVidMatch value;
    private final OFVlanVidMatch mask;
    static final OFOxmVlanVidMaskedVer15 DEFAULT = new OFOxmVlanVidMaskedVer15(DEFAULT_VALUE, DEFAULT_VALUE_MASK);
    static final Reader READER = new Reader();
    static final OFOxmVlanVidMaskedVer15Funnel FUNNEL = new OFOxmVlanVidMaskedVer15Funnel();
    static final Writer WRITER = new Writer();

    OFOxmVlanVidMaskedVer15(OFVlanVidMatch value, OFVlanVidMatch mask) {
        if (value == null) {
            throw new NullPointerException("OFOxmVlanVidMaskedVer15: property value cannot be null");
        }
        if (mask == null) {
            throw new NullPointerException("OFOxmVlanVidMaskedVer15: property mask cannot be null");
        }
        this.value = value;
        this.mask = mask;
    }

    @Override
    public long getTypeLen() {
        return 2147486980L;
    }

    @Override
    public OFVlanVidMatch getValue() {
        return this.value;
    }

    @Override
    public OFVlanVidMatch getMask() {
        return this.mask;
    }

    @Override
    public MatchField<OFVlanVidMatch> getMatchField() {
        return MatchField.VLAN_VID;
    }

    @Override
    public boolean isMasked() {
        return true;
    }

    @Override
    public OFOxm<OFVlanVidMatch> getCanonical() {
        if (OFVlanVidMatch.NO_MASK.equals(this.mask)) {
            return new OFOxmVlanVidVer15(this.value);
        }
        if (OFVlanVidMatch.FULL_MASK.equals(this.mask)) {
            return null;
        }
        return this;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFOxmVlanVidMasked.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFOxmVlanVidMaskedVer15(");
        b.append("value=").append(this.value);
        b.append(", ");
        b.append("mask=").append(this.mask);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFOxmVlanVidMaskedVer15 other = (OFOxmVlanVidMaskedVer15)obj;
        if (this.value == null ? other.value != null : !this.value.equals(other.value)) {
            return false;
        }
        return !(this.mask == null ? other.mask != null : !this.mask.equals(other.mask));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        result = 31 * result + (this.mask == null ? 0 : this.mask.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFOxmVlanVidMaskedVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFOxmVlanVidMaskedVer15 message) {
            bb.writeInt(-2147480316);
            message.value.write2Bytes(bb);
            message.mask.write2Bytes(bb);
        }
    }

    static class OFOxmVlanVidMaskedVer15Funnel
    implements Funnel<OFOxmVlanVidMaskedVer15> {
        private static final long serialVersionUID = 1L;

        OFOxmVlanVidMaskedVer15Funnel() {
        }

        public void funnel(OFOxmVlanVidMaskedVer15 message, PrimitiveSink sink) {
            sink.putInt(-2147480316);
            message.value.putTo(sink);
            message.mask.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFOxmVlanVidMasked> {
        Reader() {
        }

        @Override
        public OFOxmVlanVidMasked readFrom(ByteBuf bb) throws OFParseError {
            int typeLen = bb.readInt();
            if (typeLen != -2147480316) {
                throw new OFParseError("Wrong typeLen: Expected=0x80000d04L(0x80000d04L), got=" + typeLen);
            }
            OFVlanVidMatch value = OFVlanVidMatch.read2Bytes(bb);
            OFVlanVidMatch mask = OFVlanVidMatch.read2Bytes(bb);
            OFOxmVlanVidMaskedVer15 oxmVlanVidMaskedVer15 = new OFOxmVlanVidMaskedVer15(value, mask);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)oxmVlanVidMaskedVer15);
            }
            return oxmVlanVidMaskedVer15;
        }
    }

    static class Builder
    implements OFOxmVlanVidMasked.Builder {
        private boolean valueSet;
        private OFVlanVidMatch value;
        private boolean maskSet;
        private OFVlanVidMatch mask;

        Builder() {
        }

        @Override
        public long getTypeLen() {
            return 2147486980L;
        }

        @Override
        public OFVlanVidMatch getValue() {
            return this.value;
        }

        @Override
        public OFOxmVlanVidMasked.Builder setValue(OFVlanVidMatch value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVlanVidMatch getMask() {
            return this.mask;
        }

        @Override
        public OFOxmVlanVidMasked.Builder setMask(OFVlanVidMatch mask) {
            this.mask = mask;
            this.maskSet = true;
            return this;
        }

        @Override
        public MatchField<OFVlanVidMatch> getMatchField() {
            return MatchField.VLAN_VID;
        }

        @Override
        public boolean isMasked() {
            return true;
        }

        @Override
        public OFOxm<OFVlanVidMatch> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.5");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFOxmVlanVidMasked build() {
            OFVlanVidMatch mask;
            OFVlanVidMatch value;
            OFVlanVidMatch oFVlanVidMatch = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            OFVlanVidMatch oFVlanVidMatch2 = mask = this.maskSet ? this.mask : DEFAULT_VALUE_MASK;
            if (mask == null) {
                throw new NullPointerException("Property mask must not be null");
            }
            return new OFOxmVlanVidMaskedVer15(value, mask);
        }
    }

    static class BuilderWithParent
    implements OFOxmVlanVidMasked.Builder {
        final OFOxmVlanVidMaskedVer15 parentMessage;
        private boolean valueSet;
        private OFVlanVidMatch value;
        private boolean maskSet;
        private OFVlanVidMatch mask;

        BuilderWithParent(OFOxmVlanVidMaskedVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public long getTypeLen() {
            return 2147486980L;
        }

        @Override
        public OFVlanVidMatch getValue() {
            return this.value;
        }

        @Override
        public OFOxmVlanVidMasked.Builder setValue(OFVlanVidMatch value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVlanVidMatch getMask() {
            return this.mask;
        }

        @Override
        public OFOxmVlanVidMasked.Builder setMask(OFVlanVidMatch mask) {
            this.mask = mask;
            this.maskSet = true;
            return this;
        }

        @Override
        public MatchField<OFVlanVidMatch> getMatchField() {
            return MatchField.VLAN_VID;
        }

        @Override
        public boolean isMasked() {
            return true;
        }

        @Override
        public OFOxm<OFVlanVidMatch> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.5");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFOxmVlanVidMasked build() {
            OFVlanVidMatch mask;
            OFVlanVidMatch value;
            OFVlanVidMatch oFVlanVidMatch = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            OFVlanVidMatch oFVlanVidMatch2 = mask = this.maskSet ? this.mask : this.parentMessage.mask;
            if (mask == null) {
                throw new NullPointerException("Property mask must not be null");
            }
            return new OFOxmVlanVidMaskedVer15(value, mask);
        }
    }
}

