/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.match.MatchField;
import org.projectfloodlight.openflow.protocol.oxm.OFOxm;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmTunnelIpv4Dst;
import org.projectfloodlight.openflow.types.IPv4Address;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFOxmTunnelIpv4DstVer15
implements OFOxmTunnelIpv4Dst {
    private static final Logger logger = LoggerFactory.getLogger(OFOxmTunnelIpv4DstVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int LENGTH = 8;
    private static final IPv4Address DEFAULT_VALUE = IPv4Address.NONE;
    private final IPv4Address value;
    static final OFOxmTunnelIpv4DstVer15 DEFAULT = new OFOxmTunnelIpv4DstVer15(DEFAULT_VALUE);
    static final Reader READER = new Reader();
    static final OFOxmTunnelIpv4DstVer15Funnel FUNNEL = new OFOxmTunnelIpv4DstVer15Funnel();
    static final Writer WRITER = new Writer();

    OFOxmTunnelIpv4DstVer15(IPv4Address value) {
        if (value == null) {
            throw new NullPointerException("OFOxmTunnelIpv4DstVer15: property value cannot be null");
        }
        this.value = value;
    }

    @Override
    public long getTypeLen() {
        return 81924L;
    }

    @Override
    public IPv4Address getValue() {
        return this.value;
    }

    @Override
    public MatchField<IPv4Address> getMatchField() {
        return MatchField.TUNNEL_IPV4_DST;
    }

    @Override
    public boolean isMasked() {
        return false;
    }

    @Override
    public OFOxm<IPv4Address> getCanonical() {
        return this;
    }

    @Override
    public IPv4Address getMask() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property mask not supported in version 1.5");
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFOxmTunnelIpv4Dst.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFOxmTunnelIpv4DstVer15(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFOxmTunnelIpv4DstVer15 other = (OFOxmTunnelIpv4DstVer15)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFOxmTunnelIpv4DstVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFOxmTunnelIpv4DstVer15 message) {
            bb.writeInt(81924);
            message.value.write4Bytes(bb);
        }
    }

    static class OFOxmTunnelIpv4DstVer15Funnel
    implements Funnel<OFOxmTunnelIpv4DstVer15> {
        private static final long serialVersionUID = 1L;

        OFOxmTunnelIpv4DstVer15Funnel() {
        }

        public void funnel(OFOxmTunnelIpv4DstVer15 message, PrimitiveSink sink) {
            sink.putInt(81924);
            message.value.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFOxmTunnelIpv4Dst> {
        Reader() {
        }

        @Override
        public OFOxmTunnelIpv4Dst readFrom(ByteBuf bb) throws OFParseError {
            int typeLen = bb.readInt();
            if (typeLen != 81924) {
                throw new OFParseError("Wrong typeLen: Expected=0x14004L(0x14004L), got=" + typeLen);
            }
            IPv4Address value = IPv4Address.read4Bytes(bb);
            OFOxmTunnelIpv4DstVer15 oxmTunnelIpv4DstVer15 = new OFOxmTunnelIpv4DstVer15(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)oxmTunnelIpv4DstVer15);
            }
            return oxmTunnelIpv4DstVer15;
        }
    }

    static class Builder
    implements OFOxmTunnelIpv4Dst.Builder {
        private boolean valueSet;
        private IPv4Address value;

        Builder() {
        }

        @Override
        public long getTypeLen() {
            return 81924L;
        }

        @Override
        public IPv4Address getValue() {
            return this.value;
        }

        @Override
        public OFOxmTunnelIpv4Dst.Builder setValue(IPv4Address value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public MatchField<IPv4Address> getMatchField() {
            return MatchField.TUNNEL_IPV4_DST;
        }

        @Override
        public boolean isMasked() {
            return false;
        }

        @Override
        public OFOxm<IPv4Address> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.5");
        }

        @Override
        public IPv4Address getMask() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property mask not supported in version 1.5");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFOxmTunnelIpv4Dst build() {
            IPv4Address value;
            IPv4Address iPv4Address = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFOxmTunnelIpv4DstVer15(value);
        }
    }

    static class BuilderWithParent
    implements OFOxmTunnelIpv4Dst.Builder {
        final OFOxmTunnelIpv4DstVer15 parentMessage;
        private boolean valueSet;
        private IPv4Address value;

        BuilderWithParent(OFOxmTunnelIpv4DstVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public long getTypeLen() {
            return 81924L;
        }

        @Override
        public IPv4Address getValue() {
            return this.value;
        }

        @Override
        public OFOxmTunnelIpv4Dst.Builder setValue(IPv4Address value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public MatchField<IPv4Address> getMatchField() {
            return MatchField.TUNNEL_IPV4_DST;
        }

        @Override
        public boolean isMasked() {
            return false;
        }

        @Override
        public OFOxm<IPv4Address> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.5");
        }

        @Override
        public IPv4Address getMask() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property mask not supported in version 1.5");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFOxmTunnelIpv4Dst build() {
            IPv4Address value;
            IPv4Address iPv4Address = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFOxmTunnelIpv4DstVer15(value);
        }
    }
}

