/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.match.MatchField;
import org.projectfloodlight.openflow.protocol.oxm.OFOxm;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmIpv6NdTllMasked;
import org.projectfloodlight.openflow.protocol.ver15.OFOxmIpv6NdTllVer15;
import org.projectfloodlight.openflow.types.MacAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFOxmIpv6NdTllMaskedVer15
implements OFOxmIpv6NdTllMasked {
    private static final Logger logger = LoggerFactory.getLogger(OFOxmIpv6NdTllMaskedVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int LENGTH = 16;
    private static final MacAddress DEFAULT_VALUE = MacAddress.NONE;
    private static final MacAddress DEFAULT_VALUE_MASK = MacAddress.NONE;
    private final MacAddress value;
    private final MacAddress mask;
    static final OFOxmIpv6NdTllMaskedVer15 DEFAULT = new OFOxmIpv6NdTllMaskedVer15(DEFAULT_VALUE, DEFAULT_VALUE_MASK);
    static final Reader READER = new Reader();
    static final OFOxmIpv6NdTllMaskedVer15Funnel FUNNEL = new OFOxmIpv6NdTllMaskedVer15Funnel();
    static final Writer WRITER = new Writer();

    OFOxmIpv6NdTllMaskedVer15(MacAddress value, MacAddress mask) {
        if (value == null) {
            throw new NullPointerException("OFOxmIpv6NdTllMaskedVer15: property value cannot be null");
        }
        if (mask == null) {
            throw new NullPointerException("OFOxmIpv6NdTllMaskedVer15: property mask cannot be null");
        }
        this.value = value;
        this.mask = mask;
    }

    @Override
    public long getTypeLen() {
        return 2147500812L;
    }

    @Override
    public MacAddress getValue() {
        return this.value;
    }

    @Override
    public MacAddress getMask() {
        return this.mask;
    }

    @Override
    public MatchField<MacAddress> getMatchField() {
        return MatchField.IPV6_ND_TLL;
    }

    @Override
    public boolean isMasked() {
        return true;
    }

    @Override
    public OFOxm<MacAddress> getCanonical() {
        if (MacAddress.NO_MASK.equals(this.mask)) {
            return new OFOxmIpv6NdTllVer15(this.value);
        }
        if (MacAddress.FULL_MASK.equals(this.mask)) {
            return null;
        }
        return this;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFOxmIpv6NdTllMasked.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFOxmIpv6NdTllMaskedVer15(");
        b.append("value=").append(this.value);
        b.append(", ");
        b.append("mask=").append(this.mask);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFOxmIpv6NdTllMaskedVer15 other = (OFOxmIpv6NdTllMaskedVer15)obj;
        if (this.value == null ? other.value != null : !this.value.equals(other.value)) {
            return false;
        }
        return !(this.mask == null ? other.mask != null : !this.mask.equals(other.mask));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        result = 31 * result + (this.mask == null ? 0 : this.mask.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFOxmIpv6NdTllMaskedVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFOxmIpv6NdTllMaskedVer15 message) {
            bb.writeInt(-2147466484);
            message.value.write6Bytes(bb);
            message.mask.write6Bytes(bb);
        }
    }

    static class OFOxmIpv6NdTllMaskedVer15Funnel
    implements Funnel<OFOxmIpv6NdTllMaskedVer15> {
        private static final long serialVersionUID = 1L;

        OFOxmIpv6NdTllMaskedVer15Funnel() {
        }

        public void funnel(OFOxmIpv6NdTllMaskedVer15 message, PrimitiveSink sink) {
            sink.putInt(-2147466484);
            message.value.putTo(sink);
            message.mask.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFOxmIpv6NdTllMasked> {
        Reader() {
        }

        @Override
        public OFOxmIpv6NdTllMasked readFrom(ByteBuf bb) throws OFParseError {
            int typeLen = bb.readInt();
            if (typeLen != -2147466484) {
                throw new OFParseError("Wrong typeLen: Expected=0x8000430cL(0x8000430cL), got=" + typeLen);
            }
            MacAddress value = MacAddress.read6Bytes(bb);
            MacAddress mask = MacAddress.read6Bytes(bb);
            OFOxmIpv6NdTllMaskedVer15 oxmIpv6NdTllMaskedVer15 = new OFOxmIpv6NdTllMaskedVer15(value, mask);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)oxmIpv6NdTllMaskedVer15);
            }
            return oxmIpv6NdTllMaskedVer15;
        }
    }

    static class Builder
    implements OFOxmIpv6NdTllMasked.Builder {
        private boolean valueSet;
        private MacAddress value;
        private boolean maskSet;
        private MacAddress mask;

        Builder() {
        }

        @Override
        public long getTypeLen() {
            return 2147500812L;
        }

        @Override
        public MacAddress getValue() {
            return this.value;
        }

        @Override
        public OFOxmIpv6NdTllMasked.Builder setValue(MacAddress value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public MacAddress getMask() {
            return this.mask;
        }

        @Override
        public OFOxmIpv6NdTllMasked.Builder setMask(MacAddress mask) {
            this.mask = mask;
            this.maskSet = true;
            return this;
        }

        @Override
        public MatchField<MacAddress> getMatchField() {
            return MatchField.IPV6_ND_TLL;
        }

        @Override
        public boolean isMasked() {
            return true;
        }

        @Override
        public OFOxm<MacAddress> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.5");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFOxmIpv6NdTllMasked build() {
            MacAddress mask;
            MacAddress value;
            MacAddress macAddress = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            MacAddress macAddress2 = mask = this.maskSet ? this.mask : DEFAULT_VALUE_MASK;
            if (mask == null) {
                throw new NullPointerException("Property mask must not be null");
            }
            return new OFOxmIpv6NdTllMaskedVer15(value, mask);
        }
    }

    static class BuilderWithParent
    implements OFOxmIpv6NdTllMasked.Builder {
        final OFOxmIpv6NdTllMaskedVer15 parentMessage;
        private boolean valueSet;
        private MacAddress value;
        private boolean maskSet;
        private MacAddress mask;

        BuilderWithParent(OFOxmIpv6NdTllMaskedVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public long getTypeLen() {
            return 2147500812L;
        }

        @Override
        public MacAddress getValue() {
            return this.value;
        }

        @Override
        public OFOxmIpv6NdTllMasked.Builder setValue(MacAddress value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public MacAddress getMask() {
            return this.mask;
        }

        @Override
        public OFOxmIpv6NdTllMasked.Builder setMask(MacAddress mask) {
            this.mask = mask;
            this.maskSet = true;
            return this;
        }

        @Override
        public MatchField<MacAddress> getMatchField() {
            return MatchField.IPV6_ND_TLL;
        }

        @Override
        public boolean isMasked() {
            return true;
        }

        @Override
        public OFOxm<MacAddress> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.5");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFOxmIpv6NdTllMasked build() {
            MacAddress mask;
            MacAddress value;
            MacAddress macAddress = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            MacAddress macAddress2 = mask = this.maskSet ? this.mask : this.parentMessage.mask;
            if (mask == null) {
                throw new NullPointerException("Property mask must not be null");
            }
            return new OFOxmIpv6NdTllMaskedVer15(value, mask);
        }
    }
}

