/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.match.MatchField;
import org.projectfloodlight.openflow.protocol.oxm.OFOxm;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmInPhyPort;
import org.projectfloodlight.openflow.types.OFPort;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFOxmInPhyPortVer15
implements OFOxmInPhyPort {
    private static final Logger logger = LoggerFactory.getLogger(OFOxmInPhyPortVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int LENGTH = 8;
    private static final OFPort DEFAULT_VALUE = OFPort.ANY;
    private final OFPort value;
    static final OFOxmInPhyPortVer15 DEFAULT = new OFOxmInPhyPortVer15(DEFAULT_VALUE);
    static final Reader READER = new Reader();
    static final OFOxmInPhyPortVer15Funnel FUNNEL = new OFOxmInPhyPortVer15Funnel();
    static final Writer WRITER = new Writer();

    OFOxmInPhyPortVer15(OFPort value) {
        if (value == null) {
            throw new NullPointerException("OFOxmInPhyPortVer15: property value cannot be null");
        }
        this.value = value;
    }

    @Override
    public long getTypeLen() {
        return 2147484164L;
    }

    @Override
    public OFPort getValue() {
        return this.value;
    }

    @Override
    public MatchField<OFPort> getMatchField() {
        return MatchField.IN_PHY_PORT;
    }

    @Override
    public boolean isMasked() {
        return false;
    }

    @Override
    public OFOxm<OFPort> getCanonical() {
        return this;
    }

    @Override
    public OFPort getMask() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property mask not supported in version 1.5");
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFOxmInPhyPort.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFOxmInPhyPortVer15(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFOxmInPhyPortVer15 other = (OFOxmInPhyPortVer15)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFOxmInPhyPortVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFOxmInPhyPortVer15 message) {
            bb.writeInt(-2147483132);
            message.value.write4Bytes(bb);
        }
    }

    static class OFOxmInPhyPortVer15Funnel
    implements Funnel<OFOxmInPhyPortVer15> {
        private static final long serialVersionUID = 1L;

        OFOxmInPhyPortVer15Funnel() {
        }

        public void funnel(OFOxmInPhyPortVer15 message, PrimitiveSink sink) {
            sink.putInt(-2147483132);
            message.value.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFOxmInPhyPort> {
        Reader() {
        }

        @Override
        public OFOxmInPhyPort readFrom(ByteBuf bb) throws OFParseError {
            int typeLen = bb.readInt();
            if (typeLen != -2147483132) {
                throw new OFParseError("Wrong typeLen: Expected=0x80000204L(0x80000204L), got=" + typeLen);
            }
            OFPort value = OFPort.read4Bytes(bb);
            OFOxmInPhyPortVer15 oxmInPhyPortVer15 = new OFOxmInPhyPortVer15(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)oxmInPhyPortVer15);
            }
            return oxmInPhyPortVer15;
        }
    }

    static class Builder
    implements OFOxmInPhyPort.Builder {
        private boolean valueSet;
        private OFPort value;

        Builder() {
        }

        @Override
        public long getTypeLen() {
            return 2147484164L;
        }

        @Override
        public OFPort getValue() {
            return this.value;
        }

        @Override
        public OFOxmInPhyPort.Builder setValue(OFPort value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public MatchField<OFPort> getMatchField() {
            return MatchField.IN_PHY_PORT;
        }

        @Override
        public boolean isMasked() {
            return false;
        }

        @Override
        public OFOxm<OFPort> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.5");
        }

        @Override
        public OFPort getMask() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property mask not supported in version 1.5");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFOxmInPhyPort build() {
            OFPort value;
            OFPort oFPort = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFOxmInPhyPortVer15(value);
        }
    }

    static class BuilderWithParent
    implements OFOxmInPhyPort.Builder {
        final OFOxmInPhyPortVer15 parentMessage;
        private boolean valueSet;
        private OFPort value;

        BuilderWithParent(OFOxmInPhyPortVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public long getTypeLen() {
            return 2147484164L;
        }

        @Override
        public OFPort getValue() {
            return this.value;
        }

        @Override
        public OFOxmInPhyPort.Builder setValue(OFPort value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public MatchField<OFPort> getMatchField() {
            return MatchField.IN_PHY_PORT;
        }

        @Override
        public boolean isMasked() {
            return false;
        }

        @Override
        public OFOxm<OFPort> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.5");
        }

        @Override
        public OFPort getMask() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property mask not supported in version 1.5");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFOxmInPhyPort build() {
            OFPort value;
            OFPort oFPort = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFOxmInPhyPortVer15(value);
        }
    }
}

