/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.match.MatchField;
import org.projectfloodlight.openflow.protocol.oxm.OFOxm;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmIcmpv4Code;
import org.projectfloodlight.openflow.types.ICMPv4Code;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFOxmIcmpv4CodeVer15
implements OFOxmIcmpv4Code {
    private static final Logger logger = LoggerFactory.getLogger(OFOxmIcmpv4CodeVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int LENGTH = 5;
    private static final ICMPv4Code DEFAULT_VALUE = ICMPv4Code.NONE;
    private final ICMPv4Code value;
    static final OFOxmIcmpv4CodeVer15 DEFAULT = new OFOxmIcmpv4CodeVer15(DEFAULT_VALUE);
    static final Reader READER = new Reader();
    static final OFOxmIcmpv4CodeVer15Funnel FUNNEL = new OFOxmIcmpv4CodeVer15Funnel();
    static final Writer WRITER = new Writer();

    OFOxmIcmpv4CodeVer15(ICMPv4Code value) {
        if (value == null) {
            throw new NullPointerException("OFOxmIcmpv4CodeVer15: property value cannot be null");
        }
        this.value = value;
    }

    @Override
    public long getTypeLen() {
        return 2147493889L;
    }

    @Override
    public ICMPv4Code getValue() {
        return this.value;
    }

    @Override
    public MatchField<ICMPv4Code> getMatchField() {
        return MatchField.ICMPV4_CODE;
    }

    @Override
    public boolean isMasked() {
        return false;
    }

    @Override
    public OFOxm<ICMPv4Code> getCanonical() {
        return this;
    }

    @Override
    public ICMPv4Code getMask() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property mask not supported in version 1.5");
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFOxmIcmpv4Code.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFOxmIcmpv4CodeVer15(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFOxmIcmpv4CodeVer15 other = (OFOxmIcmpv4CodeVer15)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFOxmIcmpv4CodeVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFOxmIcmpv4CodeVer15 message) {
            bb.writeInt(-2147473407);
            message.value.writeByte(bb);
        }
    }

    static class OFOxmIcmpv4CodeVer15Funnel
    implements Funnel<OFOxmIcmpv4CodeVer15> {
        private static final long serialVersionUID = 1L;

        OFOxmIcmpv4CodeVer15Funnel() {
        }

        public void funnel(OFOxmIcmpv4CodeVer15 message, PrimitiveSink sink) {
            sink.putInt(-2147473407);
            message.value.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFOxmIcmpv4Code> {
        Reader() {
        }

        @Override
        public OFOxmIcmpv4Code readFrom(ByteBuf bb) throws OFParseError {
            int typeLen = bb.readInt();
            if (typeLen != -2147473407) {
                throw new OFParseError("Wrong typeLen: Expected=0x80002801L(0x80002801L), got=" + typeLen);
            }
            ICMPv4Code value = ICMPv4Code.readByte(bb);
            OFOxmIcmpv4CodeVer15 oxmIcmpv4CodeVer15 = new OFOxmIcmpv4CodeVer15(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)oxmIcmpv4CodeVer15);
            }
            return oxmIcmpv4CodeVer15;
        }
    }

    static class Builder
    implements OFOxmIcmpv4Code.Builder {
        private boolean valueSet;
        private ICMPv4Code value;

        Builder() {
        }

        @Override
        public long getTypeLen() {
            return 2147493889L;
        }

        @Override
        public ICMPv4Code getValue() {
            return this.value;
        }

        @Override
        public OFOxmIcmpv4Code.Builder setValue(ICMPv4Code value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public MatchField<ICMPv4Code> getMatchField() {
            return MatchField.ICMPV4_CODE;
        }

        @Override
        public boolean isMasked() {
            return false;
        }

        @Override
        public OFOxm<ICMPv4Code> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.5");
        }

        @Override
        public ICMPv4Code getMask() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property mask not supported in version 1.5");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFOxmIcmpv4Code build() {
            ICMPv4Code value;
            ICMPv4Code iCMPv4Code = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFOxmIcmpv4CodeVer15(value);
        }
    }

    static class BuilderWithParent
    implements OFOxmIcmpv4Code.Builder {
        final OFOxmIcmpv4CodeVer15 parentMessage;
        private boolean valueSet;
        private ICMPv4Code value;

        BuilderWithParent(OFOxmIcmpv4CodeVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public long getTypeLen() {
            return 2147493889L;
        }

        @Override
        public ICMPv4Code getValue() {
            return this.value;
        }

        @Override
        public OFOxmIcmpv4Code.Builder setValue(ICMPv4Code value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public MatchField<ICMPv4Code> getMatchField() {
            return MatchField.ICMPV4_CODE;
        }

        @Override
        public boolean isMasked() {
            return false;
        }

        @Override
        public OFOxm<ICMPv4Code> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.5");
        }

        @Override
        public ICMPv4Code getMask() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property mask not supported in version 1.5");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFOxmIcmpv4Code build() {
            ICMPv4Code value;
            ICMPv4Code iCMPv4Code = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFOxmIcmpv4CodeVer15(value);
        }
    }
}

