/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessage;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.ver15.OFAsyncGetReplyVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFAsyncGetRequestVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFAsyncSetVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFBarrierReplyVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFBarrierRequestVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFBundleAddMsgVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFBundleCtrlMsgVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFControllerStatusVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFEchoReplyVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFEchoRequestVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFErrorMsgVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFExperimenterVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFFeaturesReplyVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFFeaturesRequestVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFFlowModVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFFlowRemovedVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFGetConfigReplyVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFGetConfigRequestVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFGroupModVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFHelloVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFMeterModVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFPacketInVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFPacketOutVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFPortModVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFPortStatusVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFRequestforwardVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFRoleReplyVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFRoleRequestVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFRoleStatusVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFSetConfigVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFStatsReplyVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFStatsRequestVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFTableModVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFTableStatusVer15;

abstract class OFMessageVer15 {
    static final byte WIRE_VERSION = 6;
    static final int MINIMUM_LENGTH = 8;
    public static final Reader READER = new Reader();

    OFMessageVer15() {
    }

    static class Reader
    implements OFMessageReader<OFMessage> {
        Reader() {
        }

        @Override
        public OFMessage readFrom(ByteBuf bb) throws OFParseError {
            if (bb.readableBytes() < 8) {
                return null;
            }
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 6) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_15(6), got=" + version);
            }
            byte type = bb.readByte();
            bb.readerIndex(start);
            switch (type) {
                case 19: {
                    return OFStatsReplyVer15.READER.readFrom(bb);
                }
                case 18: {
                    return OFStatsRequestVer15.READER.readFrom(bb);
                }
                case 1: {
                    return OFErrorMsgVer15.READER.readFrom(bb);
                }
                case 21: {
                    return OFBarrierReplyVer15.READER.readFrom(bb);
                }
                case 20: {
                    return OFBarrierRequestVer15.READER.readFrom(bb);
                }
                case 4: {
                    return OFExperimenterVer15.READER.readFrom(bb);
                }
                case 3: {
                    return OFEchoReplyVer15.READER.readFrom(bb);
                }
                case 2: {
                    return OFEchoRequestVer15.READER.readFrom(bb);
                }
                case 6: {
                    return OFFeaturesReplyVer15.READER.readFrom(bb);
                }
                case 5: {
                    return OFFeaturesRequestVer15.READER.readFrom(bb);
                }
                case 14: {
                    return OFFlowModVer15.READER.readFrom(bb);
                }
                case 11: {
                    return OFFlowRemovedVer15.READER.readFrom(bb);
                }
                case 8: {
                    return OFGetConfigReplyVer15.READER.readFrom(bb);
                }
                case 7: {
                    return OFGetConfigRequestVer15.READER.readFrom(bb);
                }
                case 0: {
                    return OFHelloVer15.READER.readFrom(bb);
                }
                case 10: {
                    return OFPacketInVer15.READER.readFrom(bb);
                }
                case 13: {
                    return OFPacketOutVer15.READER.readFrom(bb);
                }
                case 16: {
                    return OFPortModVer15.READER.readFrom(bb);
                }
                case 12: {
                    return OFPortStatusVer15.READER.readFrom(bb);
                }
                case 9: {
                    return OFSetConfigVer15.READER.readFrom(bb);
                }
                case 17: {
                    return OFTableModVer15.READER.readFrom(bb);
                }
                case 15: {
                    return OFGroupModVer15.READER.readFrom(bb);
                }
                case 25: {
                    return OFRoleReplyVer15.READER.readFrom(bb);
                }
                case 24: {
                    return OFRoleRequestVer15.READER.readFrom(bb);
                }
                case 27: {
                    return OFAsyncGetReplyVer15.READER.readFrom(bb);
                }
                case 26: {
                    return OFAsyncGetRequestVer15.READER.readFrom(bb);
                }
                case 28: {
                    return OFAsyncSetVer15.READER.readFrom(bb);
                }
                case 29: {
                    return OFMeterModVer15.READER.readFrom(bb);
                }
                case 34: {
                    return OFBundleAddMsgVer15.READER.readFrom(bb);
                }
                case 33: {
                    return OFBundleCtrlMsgVer15.READER.readFrom(bb);
                }
                case 32: {
                    return OFRequestforwardVer15.READER.readFrom(bb);
                }
                case 30: {
                    return OFRoleStatusVer15.READER.readFrom(bb);
                }
                case 31: {
                    return OFTableStatusVer15.READER.readFrom(bb);
                }
                case 35: {
                    return OFControllerStatusVer15.READER.readFrom(bb);
                }
            }
            throw new OFParseError("Unknown value for discriminator type of class OFMessageVer15: " + type);
        }
    }
}

