/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFInstructionType;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.instructionid.OFInstructionIdBsnPacketOfDeath;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFInstructionIdBsnPacketOfDeathVer15
implements OFInstructionIdBsnPacketOfDeath {
    private static final Logger logger = LoggerFactory.getLogger(OFInstructionIdBsnPacketOfDeathVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int LENGTH = 12;
    static final OFInstructionIdBsnPacketOfDeathVer15 DEFAULT = new OFInstructionIdBsnPacketOfDeathVer15();
    static final OFInstructionIdBsnPacketOfDeathVer15 INSTANCE = new OFInstructionIdBsnPacketOfDeathVer15();
    static final Reader READER = new Reader();
    static final OFInstructionIdBsnPacketOfDeathVer15Funnel FUNNEL = new OFInstructionIdBsnPacketOfDeathVer15Funnel();
    static final Writer WRITER = new Writer();

    private OFInstructionIdBsnPacketOfDeathVer15() {
    }

    @Override
    public OFInstructionType getType() {
        return OFInstructionType.EXPERIMENTER;
    }

    @Override
    public long getExperimenter() {
        return 6035143L;
    }

    @Override
    public long getSubtype() {
        return 6L;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFInstructionIdBsnPacketOfDeath.Builder createBuilder() {
        throw new UnsupportedOperationException("OFInstructionIdBsnPacketOfDeathVer15 has no mutable properties -- builder unneeded");
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFInstructionIdBsnPacketOfDeathVer15(");
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        return this.getClass() == obj.getClass();
    }

    public int hashCode() {
        int result = 1;
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFInstructionIdBsnPacketOfDeathVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFInstructionIdBsnPacketOfDeathVer15 message) {
            bb.writeShort(-1);
            bb.writeShort(12);
            bb.writeInt(6035143);
            bb.writeInt(6);
        }
    }

    static class OFInstructionIdBsnPacketOfDeathVer15Funnel
    implements Funnel<OFInstructionIdBsnPacketOfDeathVer15> {
        private static final long serialVersionUID = 1L;

        OFInstructionIdBsnPacketOfDeathVer15Funnel() {
        }

        public void funnel(OFInstructionIdBsnPacketOfDeathVer15 message, PrimitiveSink sink) {
            sink.putShort((short)-1);
            sink.putShort((short)12);
            sink.putInt(6035143);
            sink.putInt(6);
        }
    }

    static class Reader
    implements OFMessageReader<OFInstructionIdBsnPacketOfDeath> {
        Reader() {
        }

        @Override
        public OFInstructionIdBsnPacketOfDeath readFrom(ByteBuf bb) throws OFParseError {
            int experimenter;
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != -1) {
                throw new OFParseError("Wrong type: Expected=OFInstructionType.EXPERIMENTER(65535), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 12) {
                throw new OFParseError("Wrong length: Expected=12(12), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            if ((experimenter = bb.readInt()) != 6035143) {
                throw new OFParseError("Wrong experimenter: Expected=0x5c16c7L(0x5c16c7L), got=" + experimenter);
            }
            int subtype = bb.readInt();
            if (subtype != 6) {
                throw new OFParseError("Wrong subtype: Expected=0x6L(0x6L), got=" + subtype);
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - returning shared instance={}", (Object)INSTANCE);
            }
            return INSTANCE;
        }
    }
}

