/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Set;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFFlowLightweightStatsEntry;
import org.projectfloodlight.openflow.protocol.OFFlowLightweightStatsReply;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFStatsReplyFlags;
import org.projectfloodlight.openflow.protocol.OFStatsType;
import org.projectfloodlight.openflow.protocol.OFType;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.ver15.OFFlowLightweightStatsEntryVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFStatsReplyFlagsSerializerVer15;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.projectfloodlight.openflow.util.ChannelUtils;
import org.projectfloodlight.openflow.util.FunnelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFFlowLightweightStatsReplyVer15
implements OFFlowLightweightStatsReply {
    private static final Logger logger = LoggerFactory.getLogger(OFFlowLightweightStatsReplyVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int MINIMUM_LENGTH = 16;
    static final int MAXIMUM_LENGTH = 65535;
    private static final long DEFAULT_XID = 0L;
    private static final Set<OFStatsReplyFlags> DEFAULT_FLAGS = ImmutableSet.of();
    private static final List<OFFlowLightweightStatsEntry> DEFAULT_ENTRIES = ImmutableList.of();
    private final long xid;
    private final Set<OFStatsReplyFlags> flags;
    private final List<OFFlowLightweightStatsEntry> entries;
    static final OFFlowLightweightStatsReplyVer15 DEFAULT = new OFFlowLightweightStatsReplyVer15(0L, DEFAULT_FLAGS, DEFAULT_ENTRIES);
    static final Reader READER = new Reader();
    static final OFFlowLightweightStatsReplyVer15Funnel FUNNEL = new OFFlowLightweightStatsReplyVer15Funnel();
    static final Writer WRITER = new Writer();

    OFFlowLightweightStatsReplyVer15(long xid, Set<OFStatsReplyFlags> flags, List<OFFlowLightweightStatsEntry> entries) {
        if (flags == null) {
            throw new NullPointerException("OFFlowLightweightStatsReplyVer15: property flags cannot be null");
        }
        if (entries == null) {
            throw new NullPointerException("OFFlowLightweightStatsReplyVer15: property entries cannot be null");
        }
        this.xid = U32.normalize(xid);
        this.flags = flags;
        this.entries = entries;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFType getType() {
        return OFType.STATS_REPLY;
    }

    @Override
    public long getXid() {
        return this.xid;
    }

    @Override
    public OFStatsType getStatsType() {
        return OFStatsType.FLOW_LIGHTWEIGHT;
    }

    @Override
    public Set<OFStatsReplyFlags> getFlags() {
        return this.flags;
    }

    @Override
    public List<OFFlowLightweightStatsEntry> getEntries() {
        return this.entries;
    }

    @Override
    public OFFlowLightweightStatsReply.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFFlowLightweightStatsReplyVer15(");
        b.append("xid=").append(this.xid);
        b.append(", ");
        b.append("flags=").append(this.flags);
        b.append(", ");
        b.append("entries=").append(this.entries);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFFlowLightweightStatsReplyVer15 other = (OFFlowLightweightStatsReplyVer15)obj;
        if (this.xid != other.xid) {
            return false;
        }
        if (this.flags == null ? other.flags != null : !this.flags.equals(other.flags)) {
            return false;
        }
        return !(this.entries == null ? other.entries != null : !this.entries.equals(other.entries));
    }

    @Override
    public boolean equalsIgnoreXid(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFFlowLightweightStatsReplyVer15 other = (OFFlowLightweightStatsReplyVer15)obj;
        if (this.flags == null ? other.flags != null : !this.flags.equals(other.flags)) {
            return false;
        }
        return !(this.entries == null ? other.entries != null : !this.entries.equals(other.entries));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.xid ^ this.xid >>> 32);
        result = 31 * result + (this.flags == null ? 0 : this.flags.hashCode());
        result = 31 * result + (this.entries == null ? 0 : this.entries.hashCode());
        return result;
    }

    @Override
    public int hashCodeIgnoreXid() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.flags == null ? 0 : this.flags.hashCode());
        result = 31 * result + (this.entries == null ? 0 : this.entries.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFFlowLightweightStatsReplyVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFFlowLightweightStatsReplyVer15 message) {
            int startIndex = bb.writerIndex();
            bb.writeByte(6);
            bb.writeByte(19);
            int lengthIndex = bb.writerIndex();
            bb.writeShort((int)U16.t(0));
            bb.writeInt(U32.t(message.xid));
            bb.writeShort(17);
            OFStatsReplyFlagsSerializerVer15.writeTo(bb, message.flags);
            bb.writeZero(4);
            ChannelUtils.writeList(bb, message.entries);
            int length = bb.writerIndex() - startIndex;
            if (length > 65535) {
                throw new IllegalArgumentException("OFFlowLightweightStatsReplyVer15: message length (" + length + ") exceeds maximum (0xFFFF)");
            }
            bb.setShort(lengthIndex, length);
        }
    }

    static class OFFlowLightweightStatsReplyVer15Funnel
    implements Funnel<OFFlowLightweightStatsReplyVer15> {
        private static final long serialVersionUID = 1L;

        OFFlowLightweightStatsReplyVer15Funnel() {
        }

        public void funnel(OFFlowLightweightStatsReplyVer15 message, PrimitiveSink sink) {
            sink.putByte((byte)6);
            sink.putByte((byte)19);
            sink.putLong(message.xid);
            sink.putShort((short)17);
            OFStatsReplyFlagsSerializerVer15.putTo(message.flags, sink);
            FunnelUtils.putList(message.entries, sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFFlowLightweightStatsReply> {
        Reader() {
        }

        @Override
        public OFFlowLightweightStatsReply readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 6) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_15(6), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 19) {
                throw new OFParseError("Wrong type: Expected=OFType.STATS_REPLY(19), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length < 16) {
                throw new OFParseError("Wrong length: Expected to be >= 16, was: " + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long xid = U32.f(bb.readInt());
            short statsType = bb.readShort();
            if (statsType != 17) {
                throw new OFParseError("Wrong statsType: Expected=OFStatsType.FLOW_LIGHTWEIGHT(17), got=" + statsType);
            }
            Set<OFStatsReplyFlags> flags = OFStatsReplyFlagsSerializerVer15.readFrom(bb);
            bb.skipBytes(4);
            List<OFFlowLightweightStatsEntry> entries = ChannelUtils.readList(bb, length - (bb.readerIndex() - start), OFFlowLightweightStatsEntryVer15.READER);
            OFFlowLightweightStatsReplyVer15 flowLightweightStatsReplyVer15 = new OFFlowLightweightStatsReplyVer15(xid, flags, entries);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)flowLightweightStatsReplyVer15);
            }
            return flowLightweightStatsReplyVer15;
        }
    }

    static class Builder
    implements OFFlowLightweightStatsReply.Builder {
        private boolean xidSet;
        private long xid;
        private boolean flagsSet;
        private Set<OFStatsReplyFlags> flags;
        private boolean entriesSet;
        private List<OFFlowLightweightStatsEntry> entries;

        Builder() {
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFType getType() {
            return OFType.STATS_REPLY;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFFlowLightweightStatsReply.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public OFStatsType getStatsType() {
            return OFStatsType.FLOW_LIGHTWEIGHT;
        }

        @Override
        public Set<OFStatsReplyFlags> getFlags() {
            return this.flags;
        }

        @Override
        public OFFlowLightweightStatsReply.Builder setFlags(Set<OFStatsReplyFlags> flags) {
            this.flags = flags;
            this.flagsSet = true;
            return this;
        }

        @Override
        public List<OFFlowLightweightStatsEntry> getEntries() {
            return this.entries;
        }

        @Override
        public OFFlowLightweightStatsReply.Builder setEntries(List<OFFlowLightweightStatsEntry> entries) {
            this.entries = entries;
            this.entriesSet = true;
            return this;
        }

        @Override
        public OFFlowLightweightStatsReply build() {
            List<OFFlowLightweightStatsEntry> entries;
            Set<OFStatsReplyFlags> flags;
            long xid = this.xidSet ? this.xid : 0L;
            Set<OFStatsReplyFlags> set = flags = this.flagsSet ? this.flags : DEFAULT_FLAGS;
            if (flags == null) {
                throw new NullPointerException("Property flags must not be null");
            }
            List<OFFlowLightweightStatsEntry> list = entries = this.entriesSet ? this.entries : DEFAULT_ENTRIES;
            if (entries == null) {
                throw new NullPointerException("Property entries must not be null");
            }
            return new OFFlowLightweightStatsReplyVer15(xid, flags, entries);
        }
    }

    static class BuilderWithParent
    implements OFFlowLightweightStatsReply.Builder {
        final OFFlowLightweightStatsReplyVer15 parentMessage;
        private boolean xidSet;
        private long xid;
        private boolean flagsSet;
        private Set<OFStatsReplyFlags> flags;
        private boolean entriesSet;
        private List<OFFlowLightweightStatsEntry> entries;

        BuilderWithParent(OFFlowLightweightStatsReplyVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFType getType() {
            return OFType.STATS_REPLY;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFFlowLightweightStatsReply.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public OFStatsType getStatsType() {
            return OFStatsType.FLOW_LIGHTWEIGHT;
        }

        @Override
        public Set<OFStatsReplyFlags> getFlags() {
            return this.flags;
        }

        @Override
        public OFFlowLightweightStatsReply.Builder setFlags(Set<OFStatsReplyFlags> flags) {
            this.flags = flags;
            this.flagsSet = true;
            return this;
        }

        @Override
        public List<OFFlowLightweightStatsEntry> getEntries() {
            return this.entries;
        }

        @Override
        public OFFlowLightweightStatsReply.Builder setEntries(List<OFFlowLightweightStatsEntry> entries) {
            this.entries = entries;
            this.entriesSet = true;
            return this;
        }

        @Override
        public OFFlowLightweightStatsReply build() {
            List entries;
            Set flags;
            long xid = this.xidSet ? this.xid : this.parentMessage.xid;
            Set set = flags = this.flagsSet ? this.flags : this.parentMessage.flags;
            if (flags == null) {
                throw new NullPointerException("Property flags must not be null");
            }
            List list = entries = this.entriesSet ? this.entries : this.parentMessage.entries;
            if (entries == null) {
                throw new NullPointerException("Property entries must not be null");
            }
            return new OFFlowLightweightStatsReplyVer15(xid, flags, entries);
        }
    }
}

