/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBsnVirtualPortCreateReply;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFType;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnVirtualPortCreateReplyVer15
implements OFBsnVirtualPortCreateReply {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnVirtualPortCreateReplyVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int LENGTH = 24;
    private static final long DEFAULT_XID = 0L;
    private static final long DEFAULT_STATUS = 0L;
    private static final long DEFAULT_VPORT_NO = 0L;
    private final long xid;
    private final long status;
    private final long vportNo;
    static final OFBsnVirtualPortCreateReplyVer15 DEFAULT = new OFBsnVirtualPortCreateReplyVer15(0L, 0L, 0L);
    static final Reader READER = new Reader();
    static final OFBsnVirtualPortCreateReplyVer15Funnel FUNNEL = new OFBsnVirtualPortCreateReplyVer15Funnel();
    static final Writer WRITER = new Writer();

    OFBsnVirtualPortCreateReplyVer15(long xid, long status, long vportNo) {
        this.xid = U32.normalize(xid);
        this.status = U32.normalize(status);
        this.vportNo = U32.normalize(vportNo);
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFType getType() {
        return OFType.EXPERIMENTER;
    }

    @Override
    public long getXid() {
        return this.xid;
    }

    @Override
    public long getExperimenter() {
        return 6035143L;
    }

    @Override
    public long getSubtype() {
        return 16L;
    }

    @Override
    public long getStatus() {
        return this.status;
    }

    @Override
    public long getVportNo() {
        return this.vportNo;
    }

    @Override
    public OFBsnVirtualPortCreateReply.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnVirtualPortCreateReplyVer15(");
        b.append("xid=").append(this.xid);
        b.append(", ");
        b.append("status=").append(this.status);
        b.append(", ");
        b.append("vportNo=").append(this.vportNo);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnVirtualPortCreateReplyVer15 other = (OFBsnVirtualPortCreateReplyVer15)obj;
        if (this.xid != other.xid) {
            return false;
        }
        if (this.status != other.status) {
            return false;
        }
        return this.vportNo == other.vportNo;
    }

    @Override
    public boolean equalsIgnoreXid(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnVirtualPortCreateReplyVer15 other = (OFBsnVirtualPortCreateReplyVer15)obj;
        if (this.status != other.status) {
            return false;
        }
        return this.vportNo == other.vportNo;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.xid ^ this.xid >>> 32);
        result = 31 * (int)(this.status ^ this.status >>> 32);
        result = 31 * (int)(this.vportNo ^ this.vportNo >>> 32);
        return result;
    }

    @Override
    public int hashCodeIgnoreXid() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.status ^ this.status >>> 32);
        result = 31 * (int)(this.vportNo ^ this.vportNo >>> 32);
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnVirtualPortCreateReplyVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnVirtualPortCreateReplyVer15 message) {
            bb.writeByte(6);
            bb.writeByte(4);
            bb.writeShort(24);
            bb.writeInt(U32.t(message.xid));
            bb.writeInt(6035143);
            bb.writeInt(16);
            bb.writeInt(U32.t(message.status));
            bb.writeInt(U32.t(message.vportNo));
        }
    }

    static class OFBsnVirtualPortCreateReplyVer15Funnel
    implements Funnel<OFBsnVirtualPortCreateReplyVer15> {
        private static final long serialVersionUID = 1L;

        OFBsnVirtualPortCreateReplyVer15Funnel() {
        }

        public void funnel(OFBsnVirtualPortCreateReplyVer15 message, PrimitiveSink sink) {
            sink.putByte((byte)6);
            sink.putByte((byte)4);
            sink.putShort((short)24);
            sink.putLong(message.xid);
            sink.putInt(6035143);
            sink.putInt(16);
            sink.putLong(message.status);
            sink.putLong(message.vportNo);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnVirtualPortCreateReply> {
        Reader() {
        }

        @Override
        public OFBsnVirtualPortCreateReply readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 6) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_15(6), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 4) {
                throw new OFParseError("Wrong type: Expected=OFType.EXPERIMENTER(4), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 24) {
                throw new OFParseError("Wrong length: Expected=24(24), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long xid = U32.f(bb.readInt());
            int experimenter = bb.readInt();
            if (experimenter != 6035143) {
                throw new OFParseError("Wrong experimenter: Expected=0x5c16c7L(0x5c16c7L), got=" + experimenter);
            }
            int subtype = bb.readInt();
            if (subtype != 16) {
                throw new OFParseError("Wrong subtype: Expected=0x10L(0x10L), got=" + subtype);
            }
            long status = U32.f(bb.readInt());
            long vportNo = U32.f(bb.readInt());
            OFBsnVirtualPortCreateReplyVer15 bsnVirtualPortCreateReplyVer15 = new OFBsnVirtualPortCreateReplyVer15(xid, status, vportNo);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnVirtualPortCreateReplyVer15);
            }
            return bsnVirtualPortCreateReplyVer15;
        }
    }

    static class Builder
    implements OFBsnVirtualPortCreateReply.Builder {
        private boolean xidSet;
        private long xid;
        private boolean statusSet;
        private long status;
        private boolean vportNoSet;
        private long vportNo;

        Builder() {
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFType getType() {
            return OFType.EXPERIMENTER;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFBsnVirtualPortCreateReply.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public long getExperimenter() {
            return 6035143L;
        }

        @Override
        public long getSubtype() {
            return 16L;
        }

        @Override
        public long getStatus() {
            return this.status;
        }

        @Override
        public OFBsnVirtualPortCreateReply.Builder setStatus(long status) {
            this.status = status;
            this.statusSet = true;
            return this;
        }

        @Override
        public long getVportNo() {
            return this.vportNo;
        }

        @Override
        public OFBsnVirtualPortCreateReply.Builder setVportNo(long vportNo) {
            this.vportNo = vportNo;
            this.vportNoSet = true;
            return this;
        }

        @Override
        public OFBsnVirtualPortCreateReply build() {
            long xid = this.xidSet ? this.xid : 0L;
            long status = this.statusSet ? this.status : 0L;
            long vportNo = this.vportNoSet ? this.vportNo : 0L;
            return new OFBsnVirtualPortCreateReplyVer15(xid, status, vportNo);
        }
    }

    static class BuilderWithParent
    implements OFBsnVirtualPortCreateReply.Builder {
        final OFBsnVirtualPortCreateReplyVer15 parentMessage;
        private boolean xidSet;
        private long xid;
        private boolean statusSet;
        private long status;
        private boolean vportNoSet;
        private long vportNo;

        BuilderWithParent(OFBsnVirtualPortCreateReplyVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFType getType() {
            return OFType.EXPERIMENTER;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFBsnVirtualPortCreateReply.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public long getExperimenter() {
            return 6035143L;
        }

        @Override
        public long getSubtype() {
            return 16L;
        }

        @Override
        public long getStatus() {
            return this.status;
        }

        @Override
        public OFBsnVirtualPortCreateReply.Builder setStatus(long status) {
            this.status = status;
            this.statusSet = true;
            return this;
        }

        @Override
        public long getVportNo() {
            return this.vportNo;
        }

        @Override
        public OFBsnVirtualPortCreateReply.Builder setVportNo(long vportNo) {
            this.vportNo = vportNo;
            this.vportNoSet = true;
            return this;
        }

        @Override
        public OFBsnVirtualPortCreateReply build() {
            long xid = this.xidSet ? this.xid : this.parentMessage.xid;
            long status = this.statusSet ? this.status : this.parentMessage.status;
            long vportNo = this.vportNoSet ? this.vportNo : this.parentMessage.vportNo;
            return new OFBsnVirtualPortCreateReplyVer15(xid, status, vportNo);
        }
    }
}

