/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.collect.ImmutableSet;
import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import java.util.Set;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBsnStripVlan;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlvStripVlanOnEgress;
import org.projectfloodlight.openflow.protocol.ver15.OFBsnStripVlanSerializerVer15;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnTlvStripVlanOnEgressVer15
implements OFBsnTlvStripVlanOnEgress {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnTlvStripVlanOnEgressVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int LENGTH = 5;
    private static final Set<OFBsnStripVlan> DEFAULT_FLAGS = ImmutableSet.of();
    private final Set<OFBsnStripVlan> flags;
    static final OFBsnTlvStripVlanOnEgressVer15 DEFAULT = new OFBsnTlvStripVlanOnEgressVer15(DEFAULT_FLAGS);
    static final Reader READER = new Reader();
    static final OFBsnTlvStripVlanOnEgressVer15Funnel FUNNEL = new OFBsnTlvStripVlanOnEgressVer15Funnel();
    static final Writer WRITER = new Writer();

    OFBsnTlvStripVlanOnEgressVer15(Set<OFBsnStripVlan> flags) {
        if (flags == null) {
            throw new NullPointerException("OFBsnTlvStripVlanOnEgressVer15: property flags cannot be null");
        }
        this.flags = flags;
    }

    @Override
    public int getType() {
        return 73;
    }

    @Override
    public Set<OFBsnStripVlan> getFlags() {
        return this.flags;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFBsnTlvStripVlanOnEgress.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnTlvStripVlanOnEgressVer15(");
        b.append("flags=").append(this.flags);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnTlvStripVlanOnEgressVer15 other = (OFBsnTlvStripVlanOnEgressVer15)obj;
        return !(this.flags == null ? other.flags != null : !this.flags.equals(other.flags));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.flags == null ? 0 : this.flags.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnTlvStripVlanOnEgressVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnTlvStripVlanOnEgressVer15 message) {
            bb.writeShort(73);
            bb.writeShort(5);
            OFBsnStripVlanSerializerVer15.writeTo(bb, message.flags);
        }
    }

    static class OFBsnTlvStripVlanOnEgressVer15Funnel
    implements Funnel<OFBsnTlvStripVlanOnEgressVer15> {
        private static final long serialVersionUID = 1L;

        OFBsnTlvStripVlanOnEgressVer15Funnel() {
        }

        public void funnel(OFBsnTlvStripVlanOnEgressVer15 message, PrimitiveSink sink) {
            sink.putShort((short)73);
            sink.putShort((short)5);
            OFBsnStripVlanSerializerVer15.putTo(message.flags, sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnTlvStripVlanOnEgress> {
        Reader() {
        }

        @Override
        public OFBsnTlvStripVlanOnEgress readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 73) {
                throw new OFParseError("Wrong type: Expected=0x49(0x49), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 5) {
                throw new OFParseError("Wrong length: Expected=5(5), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            Set<OFBsnStripVlan> flags = OFBsnStripVlanSerializerVer15.readFrom(bb);
            OFBsnTlvStripVlanOnEgressVer15 bsnTlvStripVlanOnEgressVer15 = new OFBsnTlvStripVlanOnEgressVer15(flags);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnTlvStripVlanOnEgressVer15);
            }
            return bsnTlvStripVlanOnEgressVer15;
        }
    }

    static class Builder
    implements OFBsnTlvStripVlanOnEgress.Builder {
        private boolean flagsSet;
        private Set<OFBsnStripVlan> flags;

        Builder() {
        }

        @Override
        public int getType() {
            return 73;
        }

        @Override
        public Set<OFBsnStripVlan> getFlags() {
            return this.flags;
        }

        @Override
        public OFBsnTlvStripVlanOnEgress.Builder setFlags(Set<OFBsnStripVlan> flags) {
            this.flags = flags;
            this.flagsSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFBsnTlvStripVlanOnEgress build() {
            Set<OFBsnStripVlan> flags;
            Set<OFBsnStripVlan> set = flags = this.flagsSet ? this.flags : DEFAULT_FLAGS;
            if (flags == null) {
                throw new NullPointerException("Property flags must not be null");
            }
            return new OFBsnTlvStripVlanOnEgressVer15(flags);
        }
    }

    static class BuilderWithParent
    implements OFBsnTlvStripVlanOnEgress.Builder {
        final OFBsnTlvStripVlanOnEgressVer15 parentMessage;
        private boolean flagsSet;
        private Set<OFBsnStripVlan> flags;

        BuilderWithParent(OFBsnTlvStripVlanOnEgressVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 73;
        }

        @Override
        public Set<OFBsnStripVlan> getFlags() {
            return this.flags;
        }

        @Override
        public OFBsnTlvStripVlanOnEgress.Builder setFlags(Set<OFBsnStripVlan> flags) {
            this.flags = flags;
            this.flagsSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFBsnTlvStripVlanOnEgress build() {
            Set flags;
            Set set = flags = this.flagsSet ? this.flags : this.parentMessage.flags;
            if (flags == null) {
                throw new NullPointerException("Property flags must not be null");
            }
            return new OFBsnTlvStripVlanOnEgressVer15(flags);
        }
    }
}

