/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlvSocket;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnTlvSocketVer15
implements OFBsnTlvSocket {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnTlvSocketVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int LENGTH = 8;
    private static final long DEFAULT_VALUE = 0L;
    private final long value;
    static final OFBsnTlvSocketVer15 DEFAULT = new OFBsnTlvSocketVer15(0L);
    static final Reader READER = new Reader();
    static final OFBsnTlvSocketVer15Funnel FUNNEL = new OFBsnTlvSocketVer15Funnel();
    static final Writer WRITER = new Writer();

    OFBsnTlvSocketVer15(long value) {
        this.value = U32.normalize(value);
    }

    @Override
    public int getType() {
        return 212;
    }

    @Override
    public long getValue() {
        return this.value;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFBsnTlvSocket.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnTlvSocketVer15(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnTlvSocketVer15 other = (OFBsnTlvSocketVer15)obj;
        return this.value == other.value;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.value ^ this.value >>> 32);
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnTlvSocketVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnTlvSocketVer15 message) {
            bb.writeShort(212);
            bb.writeShort(8);
            bb.writeInt(U32.t(message.value));
        }
    }

    static class OFBsnTlvSocketVer15Funnel
    implements Funnel<OFBsnTlvSocketVer15> {
        private static final long serialVersionUID = 1L;

        OFBsnTlvSocketVer15Funnel() {
        }

        public void funnel(OFBsnTlvSocketVer15 message, PrimitiveSink sink) {
            sink.putShort((short)212);
            sink.putShort((short)8);
            sink.putLong(message.value);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnTlvSocket> {
        Reader() {
        }

        @Override
        public OFBsnTlvSocket readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 212) {
                throw new OFParseError("Wrong type: Expected=0xd4(0xd4), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 8) {
                throw new OFParseError("Wrong length: Expected=8(8), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long value = U32.f(bb.readInt());
            OFBsnTlvSocketVer15 bsnTlvSocketVer15 = new OFBsnTlvSocketVer15(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnTlvSocketVer15);
            }
            return bsnTlvSocketVer15;
        }
    }

    static class Builder
    implements OFBsnTlvSocket.Builder {
        private boolean valueSet;
        private long value;

        Builder() {
        }

        @Override
        public int getType() {
            return 212;
        }

        @Override
        public long getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvSocket.Builder setValue(long value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFBsnTlvSocket build() {
            long value = this.valueSet ? this.value : 0L;
            return new OFBsnTlvSocketVer15(value);
        }
    }

    static class BuilderWithParent
    implements OFBsnTlvSocket.Builder {
        final OFBsnTlvSocketVer15 parentMessage;
        private boolean valueSet;
        private long value;

        BuilderWithParent(OFBsnTlvSocketVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 212;
        }

        @Override
        public long getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvSocket.Builder setValue(long value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFBsnTlvSocket build() {
            long value = this.valueSet ? this.value : this.parentMessage.value;
            return new OFBsnTlvSocketVer15(value);
        }
    }
}

