/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlvPassive;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnTlvPassiveVer15
implements OFBsnTlvPassive {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnTlvPassiveVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int LENGTH = 4;
    static final OFBsnTlvPassiveVer15 DEFAULT = new OFBsnTlvPassiveVer15();
    static final OFBsnTlvPassiveVer15 INSTANCE = new OFBsnTlvPassiveVer15();
    static final Reader READER = new Reader();
    static final OFBsnTlvPassiveVer15Funnel FUNNEL = new OFBsnTlvPassiveVer15Funnel();
    static final Writer WRITER = new Writer();

    private OFBsnTlvPassiveVer15() {
    }

    @Override
    public int getType() {
        return 172;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFBsnTlvPassive.Builder createBuilder() {
        throw new UnsupportedOperationException("OFBsnTlvPassiveVer15 has no mutable properties -- builder unneeded");
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnTlvPassiveVer15(");
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        return this.getClass() == obj.getClass();
    }

    public int hashCode() {
        int result = 1;
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnTlvPassiveVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnTlvPassiveVer15 message) {
            bb.writeShort(172);
            bb.writeShort(4);
        }
    }

    static class OFBsnTlvPassiveVer15Funnel
    implements Funnel<OFBsnTlvPassiveVer15> {
        private static final long serialVersionUID = 1L;

        OFBsnTlvPassiveVer15Funnel() {
        }

        public void funnel(OFBsnTlvPassiveVer15 message, PrimitiveSink sink) {
            sink.putShort((short)172);
            sink.putShort((short)4);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnTlvPassive> {
        Reader() {
        }

        @Override
        public OFBsnTlvPassive readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 172) {
                throw new OFParseError("Wrong type: Expected=0xac(0xac), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 4) {
                throw new OFParseError("Wrong length: Expected=4(4), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - returning shared instance={}", (Object)INSTANCE);
            }
            return INSTANCE;
        }
    }
}

