/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlvPartnerSystemPriority;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnTlvPartnerSystemPriorityVer15
implements OFBsnTlvPartnerSystemPriority {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnTlvPartnerSystemPriorityVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int LENGTH = 6;
    private static final int DEFAULT_VALUE = 0;
    private final int value;
    static final OFBsnTlvPartnerSystemPriorityVer15 DEFAULT = new OFBsnTlvPartnerSystemPriorityVer15(0);
    static final Reader READER = new Reader();
    static final OFBsnTlvPartnerSystemPriorityVer15Funnel FUNNEL = new OFBsnTlvPartnerSystemPriorityVer15Funnel();
    static final Writer WRITER = new Writer();

    OFBsnTlvPartnerSystemPriorityVer15(int value) {
        this.value = U16.normalize(value);
    }

    @Override
    public int getType() {
        return 47;
    }

    @Override
    public int getValue() {
        return this.value;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFBsnTlvPartnerSystemPriority.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnTlvPartnerSystemPriorityVer15(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnTlvPartnerSystemPriorityVer15 other = (OFBsnTlvPartnerSystemPriorityVer15)obj;
        return this.value == other.value;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.value;
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnTlvPartnerSystemPriorityVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnTlvPartnerSystemPriorityVer15 message) {
            bb.writeShort(47);
            bb.writeShort(6);
            bb.writeShort((int)U16.t(message.value));
        }
    }

    static class OFBsnTlvPartnerSystemPriorityVer15Funnel
    implements Funnel<OFBsnTlvPartnerSystemPriorityVer15> {
        private static final long serialVersionUID = 1L;

        OFBsnTlvPartnerSystemPriorityVer15Funnel() {
        }

        public void funnel(OFBsnTlvPartnerSystemPriorityVer15 message, PrimitiveSink sink) {
            sink.putShort((short)47);
            sink.putShort((short)6);
            sink.putInt(message.value);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnTlvPartnerSystemPriority> {
        Reader() {
        }

        @Override
        public OFBsnTlvPartnerSystemPriority readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 47) {
                throw new OFParseError("Wrong type: Expected=0x2f(0x2f), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 6) {
                throw new OFParseError("Wrong length: Expected=6(6), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            int value = U16.f(bb.readShort());
            OFBsnTlvPartnerSystemPriorityVer15 bsnTlvPartnerSystemPriorityVer15 = new OFBsnTlvPartnerSystemPriorityVer15(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnTlvPartnerSystemPriorityVer15);
            }
            return bsnTlvPartnerSystemPriorityVer15;
        }
    }

    static class Builder
    implements OFBsnTlvPartnerSystemPriority.Builder {
        private boolean valueSet;
        private int value;

        Builder() {
        }

        @Override
        public int getType() {
            return 47;
        }

        @Override
        public int getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvPartnerSystemPriority.Builder setValue(int value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFBsnTlvPartnerSystemPriority build() {
            int value = this.valueSet ? this.value : 0;
            return new OFBsnTlvPartnerSystemPriorityVer15(value);
        }
    }

    static class BuilderWithParent
    implements OFBsnTlvPartnerSystemPriority.Builder {
        final OFBsnTlvPartnerSystemPriorityVer15 parentMessage;
        private boolean valueSet;
        private int value;

        BuilderWithParent(OFBsnTlvPartnerSystemPriorityVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 47;
        }

        @Override
        public int getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvPartnerSystemPriority.Builder setValue(int value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFBsnTlvPartnerSystemPriority build() {
            int value = this.valueSet ? this.value : this.parentMessage.value;
            return new OFBsnTlvPartnerSystemPriorityVer15(value);
        }
    }
}

