/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlvMatchedCount;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnTlvMatchedCountVer15
implements OFBsnTlvMatchedCount {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnTlvMatchedCountVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int LENGTH = 12;
    private static final U64 DEFAULT_VALUE = U64.ZERO;
    private final U64 value;
    static final OFBsnTlvMatchedCountVer15 DEFAULT = new OFBsnTlvMatchedCountVer15(DEFAULT_VALUE);
    static final Reader READER = new Reader();
    static final OFBsnTlvMatchedCountVer15Funnel FUNNEL = new OFBsnTlvMatchedCountVer15Funnel();
    static final Writer WRITER = new Writer();

    OFBsnTlvMatchedCountVer15(U64 value) {
        if (value == null) {
            throw new NullPointerException("OFBsnTlvMatchedCountVer15: property value cannot be null");
        }
        this.value = value;
    }

    @Override
    public int getType() {
        return 217;
    }

    @Override
    public U64 getValue() {
        return this.value;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFBsnTlvMatchedCount.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnTlvMatchedCountVer15(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnTlvMatchedCountVer15 other = (OFBsnTlvMatchedCountVer15)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnTlvMatchedCountVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnTlvMatchedCountVer15 message) {
            bb.writeShort(217);
            bb.writeShort(12);
            bb.writeLong(message.value.getValue());
        }
    }

    static class OFBsnTlvMatchedCountVer15Funnel
    implements Funnel<OFBsnTlvMatchedCountVer15> {
        private static final long serialVersionUID = 1L;

        OFBsnTlvMatchedCountVer15Funnel() {
        }

        public void funnel(OFBsnTlvMatchedCountVer15 message, PrimitiveSink sink) {
            sink.putShort((short)217);
            sink.putShort((short)12);
            message.value.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnTlvMatchedCount> {
        Reader() {
        }

        @Override
        public OFBsnTlvMatchedCount readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 217) {
                throw new OFParseError("Wrong type: Expected=0xd9(0xd9), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 12) {
                throw new OFParseError("Wrong length: Expected=12(12), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            U64 value = U64.ofRaw(bb.readLong());
            OFBsnTlvMatchedCountVer15 bsnTlvMatchedCountVer15 = new OFBsnTlvMatchedCountVer15(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnTlvMatchedCountVer15);
            }
            return bsnTlvMatchedCountVer15;
        }
    }

    static class Builder
    implements OFBsnTlvMatchedCount.Builder {
        private boolean valueSet;
        private U64 value;

        Builder() {
        }

        @Override
        public int getType() {
            return 217;
        }

        @Override
        public U64 getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvMatchedCount.Builder setValue(U64 value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFBsnTlvMatchedCount build() {
            U64 value;
            U64 u64 = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvMatchedCountVer15(value);
        }
    }

    static class BuilderWithParent
    implements OFBsnTlvMatchedCount.Builder {
        final OFBsnTlvMatchedCountVer15 parentMessage;
        private boolean valueSet;
        private U64 value;

        BuilderWithParent(OFBsnTlvMatchedCountVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 217;
        }

        @Override
        public U64 getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvMatchedCount.Builder setValue(U64 value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFBsnTlvMatchedCount build() {
            U64 value;
            U64 u64 = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvMatchedCountVer15(value);
        }
    }
}

