/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlvLcore;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnTlvLcoreVer15
implements OFBsnTlvLcore {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnTlvLcoreVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int LENGTH = 8;
    private static final long DEFAULT_VALUE = 0L;
    private final long value;
    static final OFBsnTlvLcoreVer15 DEFAULT = new OFBsnTlvLcoreVer15(0L);
    static final Reader READER = new Reader();
    static final OFBsnTlvLcoreVer15Funnel FUNNEL = new OFBsnTlvLcoreVer15Funnel();
    static final Writer WRITER = new Writer();

    OFBsnTlvLcoreVer15(long value) {
        this.value = U32.normalize(value);
    }

    @Override
    public int getType() {
        return 209;
    }

    @Override
    public long getValue() {
        return this.value;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFBsnTlvLcore.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnTlvLcoreVer15(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnTlvLcoreVer15 other = (OFBsnTlvLcoreVer15)obj;
        return this.value == other.value;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.value ^ this.value >>> 32);
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnTlvLcoreVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnTlvLcoreVer15 message) {
            bb.writeShort(209);
            bb.writeShort(8);
            bb.writeInt(U32.t(message.value));
        }
    }

    static class OFBsnTlvLcoreVer15Funnel
    implements Funnel<OFBsnTlvLcoreVer15> {
        private static final long serialVersionUID = 1L;

        OFBsnTlvLcoreVer15Funnel() {
        }

        public void funnel(OFBsnTlvLcoreVer15 message, PrimitiveSink sink) {
            sink.putShort((short)209);
            sink.putShort((short)8);
            sink.putLong(message.value);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnTlvLcore> {
        Reader() {
        }

        @Override
        public OFBsnTlvLcore readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 209) {
                throw new OFParseError("Wrong type: Expected=0xd1(0xd1), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 8) {
                throw new OFParseError("Wrong length: Expected=8(8), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long value = U32.f(bb.readInt());
            OFBsnTlvLcoreVer15 bsnTlvLcoreVer15 = new OFBsnTlvLcoreVer15(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnTlvLcoreVer15);
            }
            return bsnTlvLcoreVer15;
        }
    }

    static class Builder
    implements OFBsnTlvLcore.Builder {
        private boolean valueSet;
        private long value;

        Builder() {
        }

        @Override
        public int getType() {
            return 209;
        }

        @Override
        public long getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvLcore.Builder setValue(long value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFBsnTlvLcore build() {
            long value = this.valueSet ? this.value : 0L;
            return new OFBsnTlvLcoreVer15(value);
        }
    }

    static class BuilderWithParent
    implements OFBsnTlvLcore.Builder {
        final OFBsnTlvLcoreVer15 parentMessage;
        private boolean valueSet;
        private long value;

        BuilderWithParent(OFBsnTlvLcoreVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 209;
        }

        @Override
        public long getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvLcore.Builder setValue(long value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFBsnTlvLcore build() {
            long value = this.valueSet ? this.value : this.parentMessage.value;
            return new OFBsnTlvLcoreVer15(value);
        }
    }
}

