/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBsnLagType;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlvLagType;
import org.projectfloodlight.openflow.protocol.ver15.OFBsnLagTypeSerializerVer15;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnTlvLagTypeVer15
implements OFBsnTlvLagType {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnTlvLagTypeVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int LENGTH = 6;
    private final OFBsnLagType value;
    static final Reader READER = new Reader();
    static final OFBsnTlvLagTypeVer15Funnel FUNNEL = new OFBsnTlvLagTypeVer15Funnel();
    static final Writer WRITER = new Writer();

    OFBsnTlvLagTypeVer15(OFBsnLagType value) {
        if (value == null) {
            throw new NullPointerException("OFBsnTlvLagTypeVer15: property value cannot be null");
        }
        this.value = value;
    }

    @Override
    public int getType() {
        return 227;
    }

    @Override
    public OFBsnLagType getValue() {
        return this.value;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFBsnTlvLagType.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnTlvLagTypeVer15(");
        b.append("value=").append((Object)this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnTlvLagTypeVer15 other = (OFBsnTlvLagTypeVer15)obj;
        return !(this.value == null ? other.value != null : !this.value.equals((Object)other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnTlvLagTypeVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnTlvLagTypeVer15 message) {
            bb.writeShort(227);
            bb.writeShort(6);
            OFBsnLagTypeSerializerVer15.writeTo(bb, message.value);
        }
    }

    static class OFBsnTlvLagTypeVer15Funnel
    implements Funnel<OFBsnTlvLagTypeVer15> {
        private static final long serialVersionUID = 1L;

        OFBsnTlvLagTypeVer15Funnel() {
        }

        public void funnel(OFBsnTlvLagTypeVer15 message, PrimitiveSink sink) {
            sink.putShort((short)227);
            sink.putShort((short)6);
            OFBsnLagTypeSerializerVer15.putTo(message.value, sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnTlvLagType> {
        Reader() {
        }

        @Override
        public OFBsnTlvLagType readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 227) {
                throw new OFParseError("Wrong type: Expected=0xe3(0xe3), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 6) {
                throw new OFParseError("Wrong length: Expected=6(6), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            OFBsnLagType value = OFBsnLagTypeSerializerVer15.readFrom(bb);
            OFBsnTlvLagTypeVer15 bsnTlvLagTypeVer15 = new OFBsnTlvLagTypeVer15(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnTlvLagTypeVer15);
            }
            return bsnTlvLagTypeVer15;
        }
    }

    static class Builder
    implements OFBsnTlvLagType.Builder {
        private boolean valueSet;
        private OFBsnLagType value;

        Builder() {
        }

        @Override
        public int getType() {
            return 227;
        }

        @Override
        public OFBsnLagType getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvLagType.Builder setValue(OFBsnLagType value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFBsnTlvLagType build() {
            if (!this.valueSet) {
                throw new IllegalStateException("Property value doesn't have default value -- must be set");
            }
            if (this.value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvLagTypeVer15(this.value);
        }
    }

    static class BuilderWithParent
    implements OFBsnTlvLagType.Builder {
        final OFBsnTlvLagTypeVer15 parentMessage;
        private boolean valueSet;
        private OFBsnLagType value;

        BuilderWithParent(OFBsnTlvLagTypeVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 227;
        }

        @Override
        public OFBsnLagType getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvLagType.Builder setValue(OFBsnLagType value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFBsnTlvLagType build() {
            OFBsnLagType value;
            OFBsnLagType oFBsnLagType = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvLagTypeVer15(value);
        }
    }
}

